/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.lsp.services;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.lsp4j.DidChangeConfigurationParams;
import org.eclipse.lsp4j.DidChangeWatchedFilesParams;
import org.eclipse.lsp4j.DidChangeWorkspaceFoldersParams;
import org.eclipse.lsp4j.ExecuteCommandParams;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.SymbolInformation;
import org.eclipse.lsp4j.SymbolKind;
import org.eclipse.lsp4j.WorkspaceSymbolParams;
import org.eclipse.lsp4j.services.WorkspaceService;
import org.mule.weave.extension.api.WeaveCommand;
import org.mule.weave.lsp.commands.CommandManager;
import org.mule.weave.lsp.commands.Commands$;
import org.mule.weave.lsp.commands.InternalWeaveCommand;
import org.mule.weave.lsp.extension.client.SetContextParams;
import org.mule.weave.lsp.extension.client.SetContextValue;
import org.mule.weave.lsp.extension.client.WeaveLanguageClient;
import org.mule.weave.lsp.indexer.LSPWeaveIndexService;
import org.mule.weave.lsp.jobs.JobManagerService;
import org.mule.weave.lsp.jobs.Status;
import org.mule.weave.lsp.jobs.Task;
import org.mule.weave.lsp.project.Project;
import org.mule.weave.lsp.project.ProjectKind;
import org.mule.weave.lsp.services.ClientLogger;
import org.mule.weave.lsp.services.ToolingService;
import org.mule.weave.lsp.services.events.DocumentChangedEvent$;
import org.mule.weave.lsp.services.events.DocumentFocusChangedEvent$;
import org.mule.weave.lsp.services.events.DocumentOpenedEvent$;
import org.mule.weave.lsp.services.events.FileChangedEvent;
import org.mule.weave.lsp.services.events.OnDocumentChanged;
import org.mule.weave.lsp.services.events.OnDocumentFocused;
import org.mule.weave.lsp.services.events.OnDocumentOpened;
import org.mule.weave.lsp.utils.EventBus;
import org.mule.weave.lsp.utils.LSPConverters$;
import org.mule.weave.v2.editor.VirtualFile;
import org.mule.weave.v2.editor.VirtualFileSystem;
import org.mule.weave.v2.editor.indexing.IdentifierType$;
import org.mule.weave.v2.editor.indexing.LocatedResult;
import org.mule.weave.v2.editor.indexing.WeaveIdentifier;
import org.mule.weave.v2.parser.ast.variables.NameIdentifier;
import org.mule.weave.v2.parser.location.Position;
import org.mule.weave.v2.sdk.WeaveResource;
import org.mule.weave.v2.sdk.WeaveResourceResolver;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.Seq$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

@ScalaSignature(bytes="\u0006\u0001\u0005\rg\u0001\u0002\r\u001a\u0001\u0011B\u0001B\u000f\u0001\u0003\u0002\u0003\u0006Ia\u000f\u0005\t\u0001\u0002\u0011\t\u0011)A\u0005\u0003\"A\u0011\n\u0001B\u0001B\u0003%!\n\u0003\u0005N\u0001\t\u0005\t\u0015!\u0003O\u0011!1\u0006A!A!\u0002\u00139\u0006\u0002C/\u0001\u0005\u0003\u0005\u000b\u0011\u00020\t\u0011\u0011\u0004!\u0011!Q\u0001\n\u0015DQa\u001b\u0001\u0005\u00021Dq!\u001e\u0001C\u0002\u0013%a\u000f\u0003\u0004\u0000\u0001\u0001\u0006Ia\u001e\u0005\f\u0003\u0003\u0001\u0001\u0019!a\u0001\n\u0013\t\u0019\u0001C\u0006\u0002\u0012\u0001\u0001\r\u00111A\u0005\n\u0005M\u0001bCA\u0013\u0001\u0001\u0007\t\u0011)Q\u0005\u0003\u000bA1\"a\n\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002*!Y\u0011\u0011\u0007\u0001A\u0002\u0003\u0007I\u0011BA\u001a\u0011-\t9\u0004\u0001a\u0001\u0002\u0003\u0006K!a\u000b\t\u000f\u0005e\u0002\u0001\"\u0011\u0002<!9\u0011\u0011\t\u0001\u0005\n\u0005\r\u0003bBA(\u0001\u0011\u0005\u0013\u0011\u000b\u0005\b\u0003\u0017\u0003A\u0011IAG\u0011\u001d\t9\n\u0001C!\u00033Cq!a+\u0001\t\u0003\ni\u000bC\u0004\u00028\u0002!\t%!/\u00033\u0011\u000bG/Y,fCZ,wk\u001c:lgB\f7-Z*feZL7-\u001a\u0006\u00035m\t\u0001b]3sm&\u001cWm\u001d\u0006\u00039u\t1\u0001\\:q\u0015\tqr$A\u0003xK\u00064XM\u0003\u0002!C\u0005!Q.\u001e7f\u0015\u0005\u0011\u0013aA8sO\u000e\u00011\u0003\u0002\u0001&[Y\u0002\"AJ\u0016\u000e\u0003\u001dR!\u0001K\u0015\u0002\t1\fgn\u001a\u0006\u0002U\u0005!!.\u0019<b\u0013\tasE\u0001\u0004PE*,7\r\u001e\t\u0003]Qj\u0011a\f\u0006\u00035AR!!\r\u001a\u0002\u000b1\u001c\b\u000f\u000e6\u000b\u0005M\n\u0013aB3dY&\u00048/Z\u0005\u0003k=\u0012\u0001cV8sWN\u0004\u0018mY3TKJ4\u0018nY3\u0011\u0005]BT\"A\r\n\u0005eJ\"A\u0004+p_2LgnZ*feZL7-Z\u0001\baJ|'.Z2u!\tad(D\u0001>\u0015\tQ4$\u0003\u0002@{\t9\u0001K]8kK\u000e$\u0018a\u0001<ggB\u0011!iR\u0007\u0002\u0007*\u0011A)R\u0001\u0007K\u0012LGo\u001c:\u000b\u0005\u0019k\u0012A\u0001<3\u0013\tA5IA\tWSJ$X/\u00197GS2,7+_:uK6\fAb\u00197jK:$Hj\\4hKJ\u0004\"aN&\n\u00051K\"\u0001D\"mS\u0016tG\u000fT8hO\u0016\u0014\u0018A\u00047b]\u001e,\u0018mZ3DY&,g\u000e\u001e\t\u0003\u001fRk\u0011\u0001\u0015\u0006\u0003#J\u000baa\u00197jK:$(BA*\u001c\u0003%)\u0007\u0010^3og&|g.\u0003\u0002V!\n\u0019r+Z1wK2\u000bgnZ;bO\u0016\u001cE.[3oi\u0006\t\"n\u001c2NC:\fw-\u001a:TKJ4\u0018nY3\u0011\u0005a[V\"A-\u000b\u0005i[\u0012\u0001\u00026pENL!\u0001X-\u0003#){'-T1oC\u001e,'oU3sm&\u001cW-\u0001\u0007j]\u0012,\u0007pU3sm&\u001cW\r\u0005\u0002`E6\t\u0001M\u0003\u0002b7\u00059\u0011N\u001c3fq\u0016\u0014\u0018BA2a\u0005Qa5\u000bU,fCZ,\u0017J\u001c3fqN+'O^5dK\u0006q1m\\7nC:$W*\u00198bO\u0016\u0014\bC\u00014j\u001b\u00059'B\u00015\u001c\u0003!\u0019w.\\7b]\u0012\u001c\u0018B\u00016h\u00059\u0019u.\\7b]\u0012l\u0015M\\1hKJ\fa\u0001P5oSRtD\u0003C7o_B\f(o\u001d;\u0011\u0005]\u0002\u0001\"\u0002\u001e\t\u0001\u0004Y\u0004\"\u0002!\t\u0001\u0004\t\u0005\"B%\t\u0001\u0004Q\u0005\"B'\t\u0001\u0004q\u0005\"\u0002,\t\u0001\u00049\u0006\"B/\t\u0001\u0004q\u0006\"\u00023\t\u0001\u0004)\u0017A\u00027pO\u001e,'/F\u0001x!\tAX0D\u0001z\u0015\tQ80A\u0004m_\u001e<\u0017N\\4\u000b\u0005qL\u0013\u0001B;uS2L!A`=\u0003\r1{wmZ3s\u0003\u001dawnZ4fe\u0002\n\u0001\"\u001a<f]R\u0014Uo]\u000b\u0003\u0003\u000b\u0001B!a\u0002\u0002\u000e5\u0011\u0011\u0011\u0002\u0006\u0004\u0003\u0017Y\u0012!B;uS2\u001c\u0018\u0002BA\b\u0003\u0013\u0011\u0001\"\u0012<f]R\u0014Uo]\u0001\rKZ,g\u000e\u001e\"vg~#S-\u001d\u000b\u0005\u0003+\t\t\u0003\u0005\u0003\u0002\u0018\u0005uQBAA\r\u0015\t\tY\"A\u0003tG\u0006d\u0017-\u0003\u0003\u0002 \u0005e!\u0001B+oSRD\u0011\"a\t\r\u0003\u0003\u0005\r!!\u0002\u0002\u0007a$\u0013'A\u0005fm\u0016tGOQ;tA\u0005Y\u0001O]8kK\u000e$8*\u001b8e+\t\tY\u0003E\u0002=\u0003[I1!a\f>\u0005-\u0001&o\u001c6fGR\\\u0015N\u001c3\u0002\u001fA\u0014xN[3di.Kg\u000eZ0%KF$B!!\u0006\u00026!I\u00111E\b\u0002\u0002\u0003\u0007\u00111F\u0001\raJ|'.Z2u\u0017&tG\rI\u0001\u0005S:LG\u000f\u0006\u0004\u0002\u0016\u0005u\u0012q\b\u0005\b\u0003O\t\u0002\u0019AA\u0016\u0011\u001d\t\t!\u0005a\u0001\u0003\u000b\tAC\\8uS\u001aL8i\u001c8uKb$8\t[1oO\u0016$G\u0003BA\u000b\u0003\u000bBq!a\u0012\u0013\u0001\u0004\tI%\u0001\u0002wMB\u0019!)a\u0013\n\u0007\u000553IA\u0006WSJ$X/\u00197GS2,\u0017AB:z[\n|G\u000e\u0006\u0003\u0002T\u0005\u0005\u0005CBA+\u00037\ny&\u0004\u0002\u0002X)\u0019\u0011\u0011L>\u0002\u0015\r|gnY;se\u0016tG/\u0003\u0003\u0002^\u0005]#!E\"p[BdW\r^1cY\u00164U\u000f^;sKB\"\u0011\u0011MA7!\u0019\t\u0019'!\u001a\u0002j5\t10C\u0002\u0002hm\u0014A\u0001T5tiB!\u00111NA7\u0019\u0001!1\"a\u001c\u0014\u0003\u0003\u0005\tQ!\u0001\u0002r\t\u0019q\fJ\u0019\u0012\t\u0005M\u0014\u0011\u0010\t\u0005\u0003/\t)(\u0003\u0003\u0002x\u0005e!a\u0002(pi\"Lgn\u001a\t\u0005\u0003w\ni(D\u00011\u0013\r\ty\b\r\u0002\u0012'fl'm\u001c7J]\u001a|'/\\1uS>t\u0007bBAB'\u0001\u0007\u0011QQ\u0001\u0007a\u0006\u0014\u0018-\\:\u0011\t\u0005m\u0014qQ\u0005\u0004\u0003\u0013\u0003$!F,pe.\u001c\b/Y2f'fl'm\u001c7QCJ\fWn]\u0001\u0017I&$7\t[1oO\u0016\u001cuN\u001c4jOV\u0014\u0018\r^5p]R!\u0011QCAH\u0011\u001d\t\u0019\t\u0006a\u0001\u0003#\u0003B!a\u001f\u0002\u0014&\u0019\u0011Q\u0013\u0019\u00039\u0011KGm\u00115b]\u001e,7i\u001c8gS\u001e,(/\u0019;j_:\u0004\u0016M]1ng\u0006qQ\r_3dkR,7i\\7nC:$G\u0003BAN\u0003G\u0003b!!\u0016\u0002\\\u0005u\u0005\u0003BA\f\u0003?KA!!)\u0002\u001a\t1\u0011I\\=SK\u001aDq!a!\u0016\u0001\u0004\t)\u000b\u0005\u0003\u0002|\u0005\u001d\u0016bAAUa\t!R\t_3dkR,7i\\7nC:$\u0007+\u0019:b[N\f\u0011\u0004Z5e\u0007\"\fgnZ3X_J\\7\u000f]1dK\u001a{G\u000eZ3sgR!\u0011QCAX\u0011\u001d\t\u0019I\u0006a\u0001\u0003c\u0003B!a\u001f\u00024&\u0019\u0011Q\u0017\u0019\u0003?\u0011KGm\u00115b]\u001e,wk\u001c:lgB\f7-\u001a$pY\u0012,'o\u001d)be\u0006l7/A\u000beS\u0012\u001c\u0005.\u00198hK^\u000bGo\u00195fI\u001aKG.Z:\u0015\t\u0005U\u00111\u0018\u0005\b\u0003\u0007;\u0002\u0019AA_!\u0011\tY(a0\n\u0007\u0005\u0005\u0007GA\u000eES\u0012\u001c\u0005.\u00198hK^\u000bGo\u00195fI\u001aKG.Z:QCJ\fWn\u001d")
public class DataWeaveWorkspaceService
implements WorkspaceService,
ToolingService {
    private final Project project;
    private final VirtualFileSystem vfs;
    private final ClientLogger clientLogger;
    private final WeaveLanguageClient languageClient;
    private final JobManagerService jobManagerService;
    private final LSPWeaveIndexService indexService;
    private final CommandManager commandManager;
    private final Logger logger;
    private EventBus eventBus;
    private ProjectKind projectKind;

    private Logger logger() {
        return this.logger;
    }

    private EventBus eventBus() {
        return this.eventBus;
    }

    private void eventBus_$eq(EventBus x$1) {
        this.eventBus = x$1;
    }

    private ProjectKind projectKind() {
        return this.projectKind;
    }

    private void projectKind_$eq(ProjectKind x$1) {
        this.projectKind = x$1;
    }

    @Override
    public void init(ProjectKind projectKind, EventBus eventBus) {
        this.eventBus_$eq(eventBus);
        this.projectKind_$eq(projectKind);
        eventBus.register(DocumentChangedEvent$.MODULE$.DOCUMENT_CHANGED(), new OnDocumentChanged(this){
            private final /* synthetic */ DataWeaveWorkspaceService $outer;

            public void onDocumentChanged(VirtualFile vf) {
                this.$outer.org$mule$weave$lsp$services$DataWeaveWorkspaceService$$notifyContextChanged(vf);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        eventBus.register(DocumentOpenedEvent$.MODULE$.DOCUMENT_OPENED(), new OnDocumentOpened(this){
            private final /* synthetic */ DataWeaveWorkspaceService $outer;

            public void onDocumentOpened(VirtualFile vf) {
                this.$outer.org$mule$weave$lsp$services$DataWeaveWorkspaceService$$notifyContextChanged(vf);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        eventBus.register(DocumentFocusChangedEvent$.MODULE$.DOCUMENT_FOCUS_CHANGED(), new OnDocumentFocused(this){
            private final /* synthetic */ DataWeaveWorkspaceService $outer;

            public void onDocumentFocused(VirtualFile vf) {
                this.$outer.org$mule$weave$lsp$services$DataWeaveWorkspaceService$$notifyContextChanged(vf);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public void org$mule$weave$lsp$services$DataWeaveWorkspaceService$$notifyContextChanged(VirtualFile vf) {
        SetContextParams params = new SetContextParams(JavaConverters$.MODULE$.seqAsJavaListConverter(this.commandManager.commands().map((Function1<WeaveCommand, SetContextValue> & Serializable & scala.Serializable)command -> {
            boolean bl;
            WeaveCommand weaveCommand = command;
            if (weaveCommand instanceof InternalWeaveCommand) {
                InternalWeaveCommand internalWeaveCommand = (InternalWeaveCommand)weaveCommand;
                bl = internalWeaveCommand.enabled(vf);
            } else {
                bl = true;
            }
            boolean isEnabled = bl;
            return new SetContextValue(new StringBuilder(0).append(command.commandId()).append(Commands$.MODULE$.COMMAND_ENABLED_SUFFIX()).toString(), isEnabled, vf.url());
        }, Seq$.MODULE$.canBuildFrom())).asJava());
        this.languageClient.setContext(params);
    }

    public CompletableFuture<List<? extends SymbolInformation>> symbol(WorkspaceSymbolParams params) {
        return CompletableFuture.supplyAsync(() -> {
            WeaveResourceResolver resourceResolver = $this.vfs.asResourceResolver();
            Iterable<LocatedResult<WeaveIdentifier>> iterable = $this.indexService.searchSymbol(params.getQuery());
            ArrayList result2 = new ArrayList();
            iterable.foreach((Function1<LocatedResult, Object> & Serializable & scala.Serializable)lr -> {
                Option<WeaveResource> moduleResource;
                SymbolInformation information = new SymbolInformation();
                information.setName(((WeaveIdentifier)lr.value()).value());
                int n = ((WeaveIdentifier)lr.value()).idType();
                SymbolKind kind = IdentifierType$.MODULE$.FUNCTION() == n ? SymbolKind.Function : (IdentifierType$.MODULE$.VARIABLE() == n ? SymbolKind.Variable : (IdentifierType$.MODULE$.NAMESPACE() == n ? SymbolKind.Namespace : (IdentifierType$.MODULE$.ANNOTATION() == n ? SymbolKind.Interface : SymbolKind.Field)));
                information.setKind(kind);
                NameIdentifier name = lr.moduleName();
                Option<WeaveResource> option = moduleResource = resourceResolver.resolve(name);
                if (option instanceof Some) {
                    Some some = (Some)option;
                    WeaveResource weaveResource = (WeaveResource)some.value();
                    Range range = new Range();
                    Position startPosition = weaveResource.positionOf(((WeaveIdentifier)lr.value()).startLocation());
                    Position endPosition = weaveResource.positionOf(((WeaveIdentifier)lr.value()).endLocation());
                    range.setStart(LSPConverters$.MODULE$.toPosition(startPosition));
                    range.setEnd(LSPConverters$.MODULE$.toPosition(endPosition));
                    Location location = new Location(weaveResource.url(), range);
                    information.setLocation(location);
                    return BoxesRunTime.boxToBoolean(result2.add(information));
                }
                return BoxedUnit.UNIT;
            });
            return result2;
        });
    }

    public void didChangeConfiguration(DidChangeConfigurationParams params) {
        this.logger().log(Level.INFO, new StringBuilder(24).append("didChangeConfiguration: ").append(params.getSettings()).toString());
        this.project.settings().update(params.getSettings());
    }

    public CompletableFuture<Object> executeCommand(ExecuteCommandParams params) {
        this.logger().log(Level.INFO, new StringBuilder(16).append("executeCommand: ").append(params).toString());
        return CompletableFuture.supplyAsync(() -> $this.commandManager.commandBy(params.getCommand()).map((Function1<WeaveCommand, Object> & Serializable & scala.Serializable)c -> {
            ObjectRef<Object> result2 = ObjectRef.create(null);
            $this.jobManagerService.execute(new Task(null, result2, (WeaveCommand)c, params){
                private final ObjectRef result$2;
                private final WeaveCommand c$1;
                private final ExecuteCommandParams params$2;

                public void run(Status cancelable) {
                    this.result$2.elem = this.c$1.execute(this.params$2);
                }
                {
                    this.result$2 = result$2;
                    this.c$1 = c$1;
                    this.params$2 = params$2;
                }
            }, new StringBuilder(17).append("Running command: ").append(c.name()).toString(), String.valueOf(c.description(params)));
            return result2.elem;
        }).orNull(Predef$.MODULE$.$conforms()));
    }

    public void didChangeWorkspaceFolders(DidChangeWorkspaceFoldersParams params) {
        this.logger().log(Level.INFO, new StringBuilder(45).append("[DataWeaveWorkspaceService] Changed Folders: ").append(params.getEvent()).toString());
    }

    public void didChangeWatchedFiles(DidChangeWatchedFilesParams params) {
        params.getChanges().forEach(fe -> {
            if (this.projectKind().isProjectFile(fe.getUri())) {
                $this.clientLogger.logDebug(new StringBuilder(54).append("[DataWeaveWorkspaceService] Changed Watched File : ").append(fe.getUri()).append(" - ").append(fe.getType()).toString());
                this.eventBus().fire(new FileChangedEvent(fe.getUri(), fe.getType()));
                return;
            }
            $this.clientLogger.logDebug(new StringBuilder(54).append("[DataWeaveWorkspaceService] Ignored Watched File : ").append(fe.getUri()).append(" - ").append(fe.getType()).toString());
        });
    }

    public DataWeaveWorkspaceService(Project project, VirtualFileSystem vfs, ClientLogger clientLogger, WeaveLanguageClient languageClient, JobManagerService jobManagerService, LSPWeaveIndexService indexService, CommandManager commandManager) {
        this.project = project;
        this.vfs = vfs;
        this.clientLogger = clientLogger;
        this.languageClient = languageClient;
        this.jobManagerService = jobManagerService;
        this.indexService = indexService;
        this.commandManager = commandManager;
        ToolingService.$init$(this);
        this.logger = Logger.getLogger(this.getClass().getName());
    }
}

