/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.lsp.vfs;

import java.io.File;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.nio.file.Path;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.lsp4j.FileChangeType;
import org.mule.weave.lsp.project.ProjectKind;
import org.mule.weave.lsp.project.components.ModuleStructure;
import org.mule.weave.lsp.project.components.ProjectStructure;
import org.mule.weave.lsp.project.components.ProjectStructure$;
import org.mule.weave.lsp.project.components.RootStructure;
import org.mule.weave.lsp.services.ToolingService;
import org.mule.weave.lsp.services.events.FileChangedEvent$;
import org.mule.weave.lsp.services.events.OnFileChanged;
import org.mule.weave.lsp.utils.EventBus;
import org.mule.weave.lsp.utils.URLUtils$;
import org.mule.weave.lsp.utils.VFUtils$;
import org.mule.weave.lsp.vfs.CompositeNameIdentifierResolver;
import org.mule.weave.lsp.vfs.InMemoryVirtualFileResourceResolver;
import org.mule.weave.lsp.vfs.JarFileNameIdentifierResolver;
import org.mule.weave.lsp.vfs.NameIdentifierResolver;
import org.mule.weave.lsp.vfs.ProjectFileNameIdentifierResolver;
import org.mule.weave.lsp.vfs.ProjectVirtualFile;
import org.mule.weave.lsp.vfs.ProjectVirtualFile$;
import org.mule.weave.lsp.vfs.ProjectVirtualFileSystem$;
import org.mule.weave.lsp.vfs.SimpleNameIdentifierResolver$;
import org.mule.weave.lsp.vfs.events.ProjectVirtualFileChangedEvent;
import org.mule.weave.lsp.vfs.events.ProjectVirtualFileCreatedEvent;
import org.mule.weave.lsp.vfs.events.ProjectVirtualFileDeletedEvent;
import org.mule.weave.lsp.vfs.resource.FolderWeaveResourceResolver;
import org.mule.weave.v2.editor.ChangeListener;
import org.mule.weave.v2.editor.VirtualFile;
import org.mule.weave.v2.editor.VirtualFileSystem;
import org.mule.weave.v2.sdk.ChainedWeaveResourceResolver;
import org.mule.weave.v2.sdk.WeaveResourceResolver;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Predef$DummyImplicit$;
import scala.Some;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;

@ScalaSignature(bytes="\u0006\u0001\tMb\u0001B\u0016-\u0001]B\u0001\u0002\u0014\u0001\u0003\u0002\u0003\u0006I!\u0014\u0005\u0006#\u0002!\tA\u0015\u0005\b+\u0002\u0011\r\u0011\"\u0003W\u0011\u0019i\u0007\u0001)A\u0005/\"9a\u000e\u0001b\u0001\n\u0013y\u0007BB:\u0001A\u0003%\u0001\u000fC\u0004u\u0001\t\u0007I\u0011B;\t\rq\u0004\u0001\u0015!\u0003w\u0011\u001di\bA1A\u0005\nyDq!a\u0005\u0001A\u0003%q\u0010C\u0006\u0002\u0016\u0001\u0001\r\u00111A\u0005\n\u0005]\u0001bCA\u0013\u0001\u0001\u0007\t\u0019!C\u0005\u0003OA1\"a\r\u0001\u0001\u0004\u0005\t\u0015)\u0003\u0002\u001a!Y\u0011Q\u0007\u0001A\u0002\u0003\u0007I\u0011BA\u001c\u0011-\t)\u0005\u0001a\u0001\u0002\u0004%I!a\u0012\t\u0017\u0005-\u0003\u00011A\u0001B\u0003&\u0011\u0011\b\u0005\f\u0003\u001b\u0002\u0001\u0019!a\u0001\n\u0013\ty\u0005C\u0006\u0002^\u0001\u0001\r\u00111A\u0005\n\u0005}\u0003bCA2\u0001\u0001\u0007\t\u0011)Q\u0005\u0003#B1\"!\u001a\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002h!Y\u0011q\u000e\u0001A\u0002\u0003\u0007I\u0011BA9\u0011-\t)\b\u0001a\u0001\u0002\u0003\u0006K!!\u001b\t\u000f\u0005]\u0004\u0001\"\u0011\u0002z!9\u0011q\u0010\u0001\u0005\u0002\u0005\u0005\u0005bBAL\u0001\u0011\u0005\u0011\u0011\u0014\u0005\b\u0003;\u0003A\u0011AAP\u0011\u001d\t\u0019\u000b\u0001C\u0005\u0003KCq!!+\u0001\t\u0013\tY\u000bC\u0004\u00020\u0002!I!!-\t\u000f\u0005U\u0006\u0001\"\u0011\u00028\"9\u0011Q\u0018\u0001\u0005B\u0005}\u0006bBAc\u0001\u0011%\u0011q\u0019\u0005\b\u0003\u0017\u0004A\u0011BAg\u0011\u001d\t\t\u000e\u0001C\u0005\u0003'Dq!a6\u0001\t\u0003\nI\u000eC\u0004\u0002`\u0002!\t%!9\t\u000f\u0005\u0015\b\u0001\"\u0003\u0002h\"9\u0011\u0011\u001f\u0001\u0005\n\u0005M\bbBA|\u0001\u0011%\u0011\u0011 \u0005\b\u0005\u0007\u0001A\u0011\u0001B\u0003\u0011\u001d\u00119\u0002\u0001C!\u00053AqAa\n\u0001\t\u0003\u0012IC\u0001\rQe>TWm\u0019;WSJ$X/\u00197GS2,7+_:uK6T!!\f\u0018\u0002\u0007Y47O\u0003\u00020a\u0005\u0019An\u001d9\u000b\u0005E\u0012\u0014!B<fCZ,'BA\u001a5\u0003\u0011iW\u000f\\3\u000b\u0003U\n1a\u001c:h\u0007\u0001\u0019B\u0001\u0001\u001d?\rB\u0011\u0011\bP\u0007\u0002u)\t1(A\u0003tG\u0006d\u0017-\u0003\u0002>u\t1\u0011I\\=SK\u001a\u0004\"a\u0010#\u000e\u0003\u0001S!!\u0011\"\u0002\r\u0015$\u0017\u000e^8s\u0015\t\u0019\u0005'\u0001\u0002we%\u0011Q\t\u0011\u0002\u0012-&\u0014H/^1m\r&dWmU=ti\u0016l\u0007CA$K\u001b\u0005A%BA%/\u0003!\u0019XM\u001d<jG\u0016\u001c\u0018BA&I\u00059!vn\u001c7j]\u001e\u001cVM\u001d<jG\u0016\fQD[1s\r&dWMT1nK&#WM\u001c;jM&,'OU3t_24XM\u001d\t\u0003\u001d>k\u0011\u0001L\u0005\u0003!2\u0012QDS1s\r&dWMT1nK&#WM\u001c;jM&,'OU3t_24XM]\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005M#\u0006C\u0001(\u0001\u0011\u0015a%\u00011\u0001N\u00035Ig.T3n_JLh)\u001b7fgV\tq\u000b\u0005\u0003Y;~SW\"A-\u000b\u0005i[\u0016aB7vi\u0006\u0014G.\u001a\u0006\u00039j\n!bY8mY\u0016\u001cG/[8o\u0013\tq\u0016LA\u0002NCB\u0004\"\u0001Y4\u000f\u0005\u0005,\u0007C\u00012;\u001b\u0005\u0019'B\u000137\u0003\u0019a$o\\8u}%\u0011aMO\u0001\u0007!J,G-\u001a4\n\u0005!L'AB*ue&twM\u0003\u0002guA\u0011aj[\u0005\u0003Y2\u0012!\u0003\u0015:pU\u0016\u001cGOV5siV\fGNR5mK\u0006q\u0011N\\'f[>\u0014\u0018PR5mKN\u0004\u0013aC8qK:,GMR5mKN,\u0012\u0001\u001d\t\u00041F|\u0016B\u0001:Z\u0005\r\u0019V\r^\u0001\r_B,g.\u001a3GS2,7\u000fI\u0001\u0013m\u001a\u001c8\t[1oO\u0016d\u0015n\u001d;f]\u0016\u00148/F\u0001w!\rAv/_\u0005\u0003qf\u00131\"\u0011:sCf\u0014UO\u001a4feB\u0011qH_\u0005\u0003w\u0002\u0013ab\u00115b]\u001e,G*[:uK:,'/A\nwMN\u001c\u0005.\u00198hK2K7\u000f^3oKJ\u001c\b%\u0001\u0004m_\u001e<WM]\u000b\u0002\u007fB!\u0011\u0011AA\b\u001b\t\t\u0019A\u0003\u0003\u0002\u0006\u0005\u001d\u0011a\u00027pO\u001eLgn\u001a\u0006\u0005\u0003\u0013\tY!\u0001\u0003vi&d'BAA\u0007\u0003\u0011Q\u0017M^1\n\t\u0005E\u00111\u0001\u0002\u0007\u0019><w-\u001a:\u0002\u000f1|wmZ3sA\u0005Y\u0001O]8kK\u000e$8*\u001b8e+\t\tI\u0002\u0005\u0003\u0002\u001c\u0005\u0005RBAA\u000f\u0015\r\tyBL\u0001\baJ|'.Z2u\u0013\u0011\t\u0019#!\b\u0003\u0017A\u0013xN[3di.Kg\u000eZ\u0001\u0010aJ|'.Z2u\u0017&tGm\u0018\u0013fcR!\u0011\u0011FA\u0018!\rI\u00141F\u0005\u0004\u0003[Q$\u0001B+oSRD\u0011\"!\r\r\u0003\u0003\u0005\r!!\u0007\u0002\u0007a$\u0013'\u0001\u0007qe>TWm\u0019;LS:$\u0007%\u0001\tqe>TWm\u0019;TiJ,8\r^;sKV\u0011\u0011\u0011\b\t\u0005\u0003w\t\t%\u0004\u0002\u0002>)!\u0011qHA\u000f\u0003)\u0019w.\u001c9p]\u0016tGo]\u0005\u0005\u0003\u0007\niD\u0001\tQe>TWm\u0019;TiJ,8\r^;sK\u0006!\u0002O]8kK\u000e$8\u000b\u001e:vGR,(/Z0%KF$B!!\u000b\u0002J!I\u0011\u0011G\b\u0002\u0002\u0003\u0007\u0011\u0011H\u0001\u0012aJ|'.Z2u'R\u0014Xo\u0019;ve\u0016\u0004\u0013\u0001C3wK:$()^:\u0016\u0005\u0005E\u0003\u0003BA*\u00033j!!!\u0016\u000b\u0007\u0005]c&A\u0003vi&d7/\u0003\u0003\u0002\\\u0005U#\u0001C#wK:$()^:\u0002\u0019\u00154XM\u001c;CkN|F%Z9\u0015\t\u0005%\u0012\u0011\r\u0005\n\u0003c\u0011\u0012\u0011!a\u0001\u0003#\n\u0011\"\u001a<f]R\u0014Uo\u001d\u0011\u0002-9\fW.Z%eK:$\u0018NZ5feJ+7o\u001c7wKJ,\"!!\u001b\u0011\u00079\u000bY'C\u0002\u0002n1\u0012aCT1nK&#WM\u001c;jM&,'OU3t_24XM]\u0001\u001b]\u0006lW-\u00133f]RLg-[3s%\u0016\u001cx\u000e\u001c<fe~#S-\u001d\u000b\u0005\u0003S\t\u0019\bC\u0005\u00022U\t\t\u00111\u0001\u0002j\u00059b.Y7f\u0013\u0012,g\u000e^5gS\u0016\u0014(+Z:pYZ,'\u000fI\u0001\u0005S:LG\u000f\u0006\u0004\u0002*\u0005m\u0014Q\u0010\u0005\b\u0003+9\u0002\u0019AA\r\u0011\u001d\tie\u0006a\u0001\u0003#\na!\u001e9eCR,GCBAB\u0003\u001f\u000b\u0019\nE\u0003:\u0003\u000b\u000bI)C\u0002\u0002\bj\u0012aa\u00149uS>t\u0007cA \u0002\f&\u0019\u0011Q\u0012!\u0003\u0017YK'\u000f^;bY\u001aKG.\u001a\u0005\u0007\u0003#C\u0002\u0019A0\u0002\u0007U\u0014\u0018\u000e\u0003\u0004\u0002\u0016b\u0001\raX\u0001\bG>tG/\u001a8u\u0003\u0019\u0019Gn\\:fIR!\u00111QAN\u0011\u0019\t\t*\u0007a\u0001?\u0006)1/\u0019<fIR!\u00111QAQ\u0011\u0019\t\tJ\u0007a\u0001?\u000691\r[1oO\u0016$G\u0003BA\u0015\u0003OCa!!%\u001c\u0001\u0004y\u0016a\u00023fY\u0016$X\r\u001a\u000b\u0005\u0003S\ti\u000b\u0003\u0004\u0002\u0012r\u0001\raX\u0001\bGJ,\u0017\r^3e)\u0011\tI#a-\t\r\u0005EU\u00041\u0001`\u00039\u0019\u0007.\u00198hK2K7\u000f^3oKJ$B!!\u000b\u0002:\"1\u00111\u0018\u0010A\u0002e\f!a\u00197\u0002\u0013=t7\t[1oO\u0016$G\u0003BA\u0015\u0003\u0003Dq!a1 \u0001\u0004\tI)\u0001\u0002wM\u0006qAO]5hO\u0016\u00148\t[1oO\u0016\u001cH\u0003BA\u0015\u0003\u0013Dq!a1!\u0001\u0004\tI)\u0001\bue&<w-\u001a:De\u0016\fG/\u001a3\u0015\t\u0005%\u0012q\u001a\u0005\b\u0003\u0007\f\u0003\u0019AAE\u00039!(/[4hKJ$U\r\\3uK\u0012$B!!\u000b\u0002V\"9\u00111\u0019\u0012A\u0002\u0005%\u0015\u0001\u0006:f[>4Xm\u00115b]\u001e,G*[:uK:,'\u000f\u0006\u0003\u0002*\u0005m\u0007BBAoG\u0001\u0007\u00110A\u0004tKJ4\u0018nY3\u0002\t\u0019LG.\u001a\u000b\u0005\u0003\u0013\u000b\u0019\u000f\u0003\u0004\u0002\u0012\u0012\u0002\raX\u0001\rG>tG/Y5og\u001aKG.\u001a\u000b\u0005\u0003S\fy\u000fE\u0002:\u0003WL1!!<;\u0005\u001d\u0011un\u001c7fC:Da!!%&\u0001\u0004y\u0016!\u00033p\u000f\u0016$h)\u001b7f)\rQ\u0017Q\u001f\u0005\u0007\u0003#3\u0003\u0019A0\u0002\u0019\u0011|W\u000b\u001d3bi\u00164\u0015\u000e\\3\u0015\r\u0005m\u0018Q`A\u0000!\u0011I\u0014Q\u00116\t\r\u0005Eu\u00051\u0001`\u0011\u0019\u0011\ta\na\u0001U\u0006Ya/\u001b:uk\u0006dg)\u001b7f\u00031\u0019x.\u001e:dKJ{w\u000e^(g)\u0011\u00119A!\u0006\u0011\u000be\n)I!\u0003\u0011\t\t-!\u0011C\u0007\u0003\u0005\u001bQAAa\u0004\u0002\f\u0005\u0011\u0011n\\\u0005\u0005\u0005'\u0011iA\u0001\u0003GS2,\u0007BBAIQ\u0001\u0007q,\u0001\nbgJ+7o\\;sG\u0016\u0014Vm]8mm\u0016\u0014XC\u0001B\u000e!\u0011\u0011iBa\t\u000e\u0005\t}!b\u0001B\u0011\u0005\u0006\u00191\u000fZ6\n\t\t\u0015\"q\u0004\u0002\u0016/\u0016\fg/\u001a*fg>,(oY3SKN|GN^3s\u0003%a\u0017n\u001d;GS2,7\u000f\u0006\u0002\u0003,A1!Q\u0006B\u0018\u0003\u0013k!!a\u0002\n\t\tE\u0012q\u0001\u0002\t\u0013R,'/\u0019;pe\u0002")
public class ProjectVirtualFileSystem
implements VirtualFileSystem,
ToolingService {
    private final JarFileNameIdentifierResolver jarFileNameIdentifierResolver;
    private final Map<String, ProjectVirtualFile> inMemoryFiles;
    private final Set<String> org$mule$weave$lsp$vfs$ProjectVirtualFileSystem$$openedFiles;
    private final ArrayBuffer<ChangeListener> vfsChangeListeners;
    private final Logger logger;
    private ProjectKind projectKind;
    private ProjectStructure org$mule$weave$lsp$vfs$ProjectVirtualFileSystem$$projectStructure;
    private EventBus eventBus;
    private NameIdentifierResolver nameIdentifierResolver;

    private Map<String, ProjectVirtualFile> inMemoryFiles() {
        return this.inMemoryFiles;
    }

    public Set<String> org$mule$weave$lsp$vfs$ProjectVirtualFileSystem$$openedFiles() {
        return this.org$mule$weave$lsp$vfs$ProjectVirtualFileSystem$$openedFiles;
    }

    private ArrayBuffer<ChangeListener> vfsChangeListeners() {
        return this.vfsChangeListeners;
    }

    private Logger logger() {
        return this.logger;
    }

    private ProjectKind projectKind() {
        return this.projectKind;
    }

    private void projectKind_$eq(ProjectKind x$1) {
        this.projectKind = x$1;
    }

    public ProjectStructure org$mule$weave$lsp$vfs$ProjectVirtualFileSystem$$projectStructure() {
        return this.org$mule$weave$lsp$vfs$ProjectVirtualFileSystem$$projectStructure;
    }

    private void org$mule$weave$lsp$vfs$ProjectVirtualFileSystem$$projectStructure_$eq(ProjectStructure x$1) {
        this.org$mule$weave$lsp$vfs$ProjectVirtualFileSystem$$projectStructure = x$1;
    }

    private EventBus eventBus() {
        return this.eventBus;
    }

    private void eventBus_$eq(EventBus x$1) {
        this.eventBus = x$1;
    }

    private NameIdentifierResolver nameIdentifierResolver() {
        return this.nameIdentifierResolver;
    }

    private void nameIdentifierResolver_$eq(NameIdentifierResolver x$1) {
        this.nameIdentifierResolver = x$1;
    }

    @Override
    public void init(ProjectKind projectKind, EventBus eventBus) {
        this.projectKind_$eq(projectKind);
        this.org$mule$weave$lsp$vfs$ProjectVirtualFileSystem$$projectStructure_$eq(projectKind.structure());
        this.nameIdentifierResolver_$eq(new CompositeNameIdentifierResolver((NameIdentifierResolver[])((Object[])new NameIdentifierResolver[]{new ProjectFileNameIdentifierResolver(this.org$mule$weave$lsp$vfs$ProjectVirtualFileSystem$$projectStructure()), this.jarFileNameIdentifierResolver, SimpleNameIdentifierResolver$.MODULE$})));
        this.eventBus_$eq(eventBus);
        eventBus.register(FileChangedEvent$.MODULE$.FILE_CHANGED_EVENT(), new OnFileChanged(this){
            private final /* synthetic */ ProjectVirtualFileSystem $outer;

            public void onFileChanged(String uri2, FileChangeType changeType) {
                FileChangeType fileChangeType = changeType;
                if (FileChangeType.Created.equals(fileChangeType)) {
                    if (ProjectStructure$.MODULE$.isAProjectFile(uri2, this.$outer.org$mule$weave$lsp$vfs$ProjectVirtualFileSystem$$projectStructure()) && URLUtils$.MODULE$.toFile(uri2).exists((Function1<File, Object> & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean($anon$1.$anonfun$onFileChanged$1(f)))) {
                        this.$outer.org$mule$weave$lsp$vfs$ProjectVirtualFileSystem$$created(uri2);
                        return;
                    }
                    return;
                }
                if (FileChangeType.Changed.equals(fileChangeType)) {
                    if (ProjectStructure$.MODULE$.isAProjectFile(uri2, this.$outer.org$mule$weave$lsp$vfs$ProjectVirtualFileSystem$$projectStructure())) {
                        this.$outer.org$mule$weave$lsp$vfs$ProjectVirtualFileSystem$$openedFiles().iterator().filter((Function1<String, Object> & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean($anon$1.$anonfun$onFileChanged$2(uri2, p))).foreach((Function1<String, Object> & Serializable & scala.Serializable)uri -> {
                            $anon$1.$anonfun$onFileChanged$3(this, uri);
                            return BoxedUnit.UNIT;
                        });
                        return;
                    }
                    return;
                }
                if (FileChangeType.Deleted.equals(fileChangeType)) {
                    if (ProjectStructure$.MODULE$.isAProjectFile(uri2, this.$outer.org$mule$weave$lsp$vfs$ProjectVirtualFileSystem$$projectStructure())) {
                        this.$outer.org$mule$weave$lsp$vfs$ProjectVirtualFileSystem$$openedFiles().iterator().filter((Function1<String, Object> & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean($anon$1.$anonfun$onFileChanged$4(uri2, p))).foreach((Function1<String, Object> & Serializable & scala.Serializable)uri -> {
                            $anon$1.$anonfun$onFileChanged$5(this, uri);
                            return BoxedUnit.UNIT;
                        });
                        return;
                    }
                    return;
                }
                throw new MatchError(fileChangeType);
            }

            public static final /* synthetic */ boolean $anonfun$onFileChanged$1(File f) {
                return f.exists() && f.isFile();
            }

            public static final /* synthetic */ boolean $anonfun$onFileChanged$2(String uri$1, String p) {
                return URLUtils$.MODULE$.isChildOf(p, uri$1);
            }

            public static final /* synthetic */ void $anonfun$onFileChanged$3($anon$1 $this, String uri) {
                $this.$outer.org$mule$weave$lsp$vfs$ProjectVirtualFileSystem$$changed(uri);
            }

            public static final /* synthetic */ boolean $anonfun$onFileChanged$4(String uri$1, String p) {
                return URLUtils$.MODULE$.isChildOf(p, uri$1);
            }

            public static final /* synthetic */ void $anonfun$onFileChanged$5($anon$1 $this, String uri) {
                $this.$outer.org$mule$weave$lsp$vfs$ProjectVirtualFileSystem$$deleted(uri);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$onFileChanged$1$adapted(java.io.File ), $anonfun$onFileChanged$2$adapted(java.lang.String java.lang.String ), $anonfun$onFileChanged$3$adapted(org.mule.weave.lsp.vfs.ProjectVirtualFileSystem$$anon$1 java.lang.String ), $anonfun$onFileChanged$4$adapted(java.lang.String java.lang.String ), $anonfun$onFileChanged$5$adapted(org.mule.weave.lsp.vfs.ProjectVirtualFileSystem$$anon$1 java.lang.String )}, serializedLambda);
            }
        });
    }

    public Option<VirtualFile> update(String uri, String content) {
        this.logger().log(Level.INFO, new StringBuilder(13).append("Update `").append(uri).append("` -> ").append(content).toString());
        Option<VirtualFile> option = Option$.MODULE$.apply(this.file(uri));
        if (option instanceof Some) {
            Some some = (Some)option;
            VirtualFile vf = (VirtualFile)some.value();
            boolean written = vf.write(content);
            if (written) {
                this.triggerChanges(vf);
            }
            return new Some<VirtualFile>(vf);
        }
        if (None$.MODULE$.equals(option)) {
            ProjectVirtualFile virtualFile = new ProjectVirtualFile(this, this.nameIdentifierResolver(), URLUtils$.MODULE$.toCanonicalString(uri), None$.MODULE$, new Some<String>(content), !this.projectKind().isSupportedEditableScheme(uri));
            this.doUpdateFile(uri, virtualFile);
            this.triggerChanges(virtualFile);
            return new Some<VirtualFile>(virtualFile);
        }
        throw new MatchError(option);
    }

    public Option<VirtualFile> closed(String uri) {
        this.logger().log(Level.INFO, new StringBuilder(7).append("closed ").append(uri).toString());
        return this.inMemoryFiles().remove(uri);
    }

    public Option<VirtualFile> saved(String uri) {
        this.logger().log(Level.INFO, new StringBuilder(7).append("saved: ").append(uri).toString());
        return this.inMemoryFiles().get(uri).map((Function1<ProjectVirtualFile, ProjectVirtualFile> & Serializable & scala.Serializable)x$1 -> x$1.save());
    }

    public void org$mule$weave$lsp$vfs$ProjectVirtualFileSystem$$changed(String uri) {
        this.logger().log(Level.INFO, new StringBuilder(9).append("changed: ").append(uri).toString());
        VirtualFile virtualFile = this.file(uri);
        this.triggerChanges(virtualFile);
    }

    public void org$mule$weave$lsp$vfs$ProjectVirtualFileSystem$$deleted(String uri) {
        this.logger().log(Level.INFO, new StringBuilder(8).append("deleted ").append(uri).toString());
        this.inMemoryFiles().remove(uri);
        this.org$mule$weave$lsp$vfs$ProjectVirtualFileSystem$$openedFiles().remove(uri);
        ProjectVirtualFile virtualFile = new ProjectVirtualFile(this, this.nameIdentifierResolver(), uri, URLUtils$.MODULE$.toFile(uri), ProjectVirtualFile$.MODULE$.$lessinit$greater$default$5(), ProjectVirtualFile$.MODULE$.$lessinit$greater$default$6());
        this.triggerDeleted(virtualFile);
    }

    public void org$mule$weave$lsp$vfs$ProjectVirtualFileSystem$$created(String uri) {
        this.logger().log(Level.INFO, new StringBuilder(9).append("created: ").append(uri).toString());
        this.org$mule$weave$lsp$vfs$ProjectVirtualFileSystem$$openedFiles().add(uri);
        ProjectVirtualFile virtualFile = new ProjectVirtualFile(this, this.nameIdentifierResolver(), uri, URLUtils$.MODULE$.toFile(uri), ProjectVirtualFile$.MODULE$.$lessinit$greater$default$5(), ProjectVirtualFile$.MODULE$.$lessinit$greater$default$6());
        this.triggerCreated(virtualFile);
    }

    @Override
    public void changeListener(ChangeListener cl) {
        this.vfsChangeListeners().$plus$eq((Object)cl);
    }

    @Override
    public void onChanged(VirtualFile vf) {
        this.triggerChanges(vf);
    }

    private void triggerChanges(VirtualFile vf) {
        this.vfsChangeListeners().foreach((Function1<ChangeListener, Object> & Serializable & scala.Serializable)listener -> {
            listener.onChanged(vf);
            return BoxedUnit.UNIT;
        });
        if (this.eventBus() != null) {
            this.eventBus().fire(new ProjectVirtualFileChangedEvent(vf));
            return;
        }
    }

    private void triggerCreated(VirtualFile vf) {
        this.vfsChangeListeners().foreach((Function1<ChangeListener, Object> & Serializable & scala.Serializable)listener -> {
            listener.onCreated(vf);
            return BoxedUnit.UNIT;
        });
        if (this.eventBus() != null) {
            this.eventBus().fire(new ProjectVirtualFileCreatedEvent(vf));
            return;
        }
    }

    private void triggerDeleted(VirtualFile vf) {
        this.vfsChangeListeners().foreach((Function1<ChangeListener, Object> & Serializable & scala.Serializable)listener -> {
            listener.onDeleted(vf);
            return BoxedUnit.UNIT;
        });
        if (this.eventBus() != null) {
            this.eventBus().fire(new ProjectVirtualFileDeletedEvent(vf));
            return;
        }
    }

    @Override
    public void removeChangeListener(ChangeListener service) {
        this.vfsChangeListeners().remove(this.vfsChangeListeners().indexOf(service));
    }

    @Override
    public VirtualFile file(String uri) {
        this.logger().log(Level.FINE, new StringBuilder(5).append("file ").append(uri).toString());
        this.org$mule$weave$lsp$vfs$ProjectVirtualFileSystem$$openedFiles().add(uri);
        if (this.containsFile(uri)) {
            return this.doGetFile(uri);
        }
        Option<File> maybeFile = URLUtils$.MODULE$.toFile(uri);
        if (maybeFile.isEmpty()) {
            return null;
        }
        if (maybeFile.get().exists()) {
            ProjectVirtualFileSystem x$1 = this;
            NameIdentifierResolver x$2 = this.nameIdentifierResolver();
            String x$3 = URLUtils$.MODULE$.toCanonicalString(uri);
            Option<File> x$4 = maybeFile;
            boolean x$5 = !this.projectKind().isSupportedEditableScheme(uri);
            Option<String> x$6 = ProjectVirtualFile$.MODULE$.$lessinit$greater$default$5();
            ProjectVirtualFile virtualFile = new ProjectVirtualFile(x$1, x$2, x$3, x$4, x$6, x$5);
            this.doUpdateFile(uri, virtualFile);
            return virtualFile;
        }
        return null;
    }

    private boolean containsFile(String uri) {
        return this.inMemoryFiles().contains(URLUtils$.MODULE$.toCanonicalString(uri));
    }

    private ProjectVirtualFile doGetFile(String uri) {
        return (ProjectVirtualFile)this.inMemoryFiles().apply(URLUtils$.MODULE$.toCanonicalString(uri));
    }

    private Option<ProjectVirtualFile> doUpdateFile(String uri, ProjectVirtualFile virtualFile) {
        return this.inMemoryFiles().put(URLUtils$.MODULE$.toCanonicalString(uri), virtualFile);
    }

    public Option<File> sourceRootOf(String uri) {
        File[] rootFolders = (File[])new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])this.org$mule$weave$lsp$vfs$ProjectVirtualFileSystem$$projectStructure().modules())).flatMap((Function1<ModuleStructure, Object> & Serializable & scala.Serializable)module -> new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])module.roots())).flatMap((Function1<RootStructure, Object> & Serializable & scala.Serializable)x$2 -> new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])x$2.sources())), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(File.class))))).$plus$plus(new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])module.roots())).flatMap((Function1<RootStructure, Object> & Serializable & scala.Serializable)x$3 -> new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])x$3.resources())), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(File.class))))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(File.class))))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(File.class)));
        return new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])rootFolders)).find((Function1<Object, Object>)(Function1<File, Object> & Serializable & scala.Serializable)root -> BoxesRunTime.boxToBoolean(ProjectVirtualFileSystem.$anonfun$sourceRootOf$4(uri, root)));
    }

    @Override
    public WeaveResourceResolver asResourceResolver() {
        InMemoryVirtualFileResourceResolver inMemoryVirtualFileResourceResolver;
        FolderWeaveResourceResolver[] resolvers = (FolderWeaveResourceResolver[])new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])this.org$mule$weave$lsp$vfs$ProjectVirtualFileSystem$$projectStructure().modules())).flatMap((Function1<ModuleStructure, Object> & Serializable & scala.Serializable)module -> new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])module.roots())).flatMap((Function1<RootStructure, Object> & Serializable & scala.Serializable)root -> new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])root.sources())).map((Function1<File, FolderWeaveResourceResolver> & Serializable & scala.Serializable)root -> new FolderWeaveResourceResolver((File)root, $this), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(FolderWeaveResourceResolver.class))))).$plus$plus(new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])root.resources())).map((Function1<File, FolderWeaveResourceResolver> & Serializable & scala.Serializable)root -> new FolderWeaveResourceResolver((File)root, $this), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(FolderWeaveResourceResolver.class))))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(FolderWeaveResourceResolver.class))))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(FolderWeaveResourceResolver.class))))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(FolderWeaveResourceResolver.class)));
        InMemoryVirtualFileResourceResolver inMemoryVirtualFileResourceResolver2 = inMemoryVirtualFileResourceResolver = new InMemoryVirtualFileResourceResolver(this.inMemoryFiles());
        return new ChainedWeaveResourceResolver(new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])resolvers)).$plus$colon(inMemoryVirtualFileResourceResolver2, Array$.MODULE$.fallbackCanBuildFrom(Predef$DummyImplicit$.MODULE$.dummyImplicit())));
    }

    @Override
    public java.util.Iterator<VirtualFile> listFiles() {
        Iterator result2 = new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])this.org$mule$weave$lsp$vfs$ProjectVirtualFileSystem$$projectStructure().modules())).toIterator().flatMap((Function1<ModuleStructure, Iterator> & Serializable & scala.Serializable)module -> new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])module.roots())).toIterator().flatMap((Function1<RootStructure, Iterator> & Serializable & scala.Serializable)root2 -> new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])root2.sources())).toIterator().flatMap((Function1<File, Iterator> & Serializable & scala.Serializable)root -> VFUtils$.MODULE$.listFiles((File)root, this)).$plus$plus((Function0<Iterator> & Serializable & scala.Serializable)() -> new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])root2.resources())).toIterator().flatMap((Function1<File, Iterator> & Serializable & scala.Serializable)root -> VFUtils$.MODULE$.listFiles((File)root, this)))));
        Iterator<VirtualFile> wrapper = new Iterator<VirtualFile>(this, result2){
            private final /* synthetic */ ProjectVirtualFileSystem $outer;
            private final Iterator result$1;

            public String toString() {
                return Iterator.toString$(this);
            }

            public boolean hasNext() {
                return this.result$1.hasNext();
            }

            public VirtualFile next() {
                VirtualFile next = (VirtualFile)this.result$1.next();
                this.$outer.org$mule$weave$lsp$vfs$ProjectVirtualFileSystem$$openedFiles().add(next.url());
                return next;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.result$1 = result$1;
                GenTraversableOnce.$init$(this);
                TraversableOnce.$init$(this);
                Iterator.$init$(this);
            }
        };
        return JavaConverters$.MODULE$.asJavaIteratorConverter(wrapper).asJava();
    }

    public static final /* synthetic */ boolean $anonfun$sourceRootOf$4(String uri$2, File root) {
        Option<Path> maybePath = URLUtils$.MODULE$.toPath(uri$2);
        return maybePath.exists((Function1<Path, Object> & Serializable & scala.Serializable)path -> BoxesRunTime.boxToBoolean(path.startsWith(root.toPath())));
    }

    public ProjectVirtualFileSystem(JarFileNameIdentifierResolver jarFileNameIdentifierResolver) {
        this.jarFileNameIdentifierResolver = jarFileNameIdentifierResolver;
        VirtualFileSystem.$init$(this);
        ToolingService.$init$(this);
        this.inMemoryFiles = (Map)Map$.MODULE$.apply(Nil$.MODULE$);
        this.org$mule$weave$lsp$vfs$ProjectVirtualFileSystem$$openedFiles = (Set)Set$.MODULE$.apply(Nil$.MODULE$);
        this.vfsChangeListeners = (ArrayBuffer)ArrayBuffer$.MODULE$.apply(Nil$.MODULE$);
        this.logger = Logger.getLogger(this.getClass().getName());
    }
}

