/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.v2.sdk;

import java.io.Serializable;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import org.mule.weave.v2.parser.ast.variables.NameIdentifier;
import org.mule.weave.v2.sdk.ClassLoaderWeaveResourceResolver$;
import org.mule.weave.v2.sdk.DefaultWeaveResource;
import org.mule.weave.v2.sdk.NameIdentifierHelper$;
import org.mule.weave.v2.sdk.WeaveResource;
import org.mule.weave.v2.sdk.WeaveResource$;
import org.mule.weave.v2.sdk.WeaveResourceResolver;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.io.BufferedSource;
import scala.io.Source$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001U4AAD\b\u00015!AQ\u0005\u0001B\u0001B\u0003%a\u0005C\u0003>\u0001\u0011\u0005a\bC\u0003B\u0001\u0011\u0005#\tC\u0003V\u0001\u0011\u0005c\u000bC\u0003b\u0001\u0011\u0005#\rC\u0003f\u0001\u0011\u0005amB\u0003i\u001f!\u0005\u0011NB\u0003\u000f\u001f!\u0005!\u000eC\u0003>\u0011\u0011\u00051\u000eC\u0003m\u0011\u0011\u0005Q\u000eC\u0003o\u0011\u0011\u0005Q\u000eC\u0003p\u0011\u0011\u0005Q\u000eC\u0003q\u0011\u0011\u0005\u0011O\u0001\u0011DY\u0006\u001c8\u000fT8bI\u0016\u0014x+Z1wKJ+7o\\;sG\u0016\u0014Vm]8mm\u0016\u0014(B\u0001\t\u0012\u0003\r\u0019Hm\u001b\u0006\u0003%M\t!A\u001e\u001a\u000b\u0005Q)\u0012!B<fCZ,'B\u0001\f\u0018\u0003\u0011iW\u000f\\3\u000b\u0003a\t1a\u001c:h\u0007\u0001\u00192\u0001A\u000e\"!\tar$D\u0001\u001e\u0015\u0005q\u0012!B:dC2\f\u0017B\u0001\u0011\u001e\u0005\u0019\te.\u001f*fMB\u0011!eI\u0007\u0002\u001f%\u0011Ae\u0004\u0002\u0016/\u0016\fg/\u001a*fg>,(oY3SKN|GN^3s\u00031\u0019G.Y:tY>\fG-\u001a:t!\r9sF\r\b\u0003Q5r!!\u000b\u0017\u000e\u0003)R!aK\r\u0002\rq\u0012xn\u001c;?\u0013\u0005q\u0012B\u0001\u0018\u001e\u0003\u001d\u0001\u0018mY6bO\u0016L!\u0001M\u0019\u0003\u0007M+\u0017O\u0003\u0002/;A\u0019AdM\u001b\n\u0005Qj\"!\u0003$v]\u000e$\u0018n\u001c81!\t14(D\u00018\u0015\tA\u0014(\u0001\u0003mC:<'\"\u0001\u001e\u0002\t)\fg/Y\u0005\u0003y]\u00121b\u00117bgNdu.\u00193fe\u00061A(\u001b8jiz\"\"a\u0010!\u0011\u0005\t\u0002\u0001\"B\u0013\u0003\u0001\u00041\u0013a\u0002:fg>dg/\u001a\u000b\u0003\u0007&\u00032\u0001\b#G\u0013\t)UD\u0001\u0004PaRLwN\u001c\t\u0003E\u001dK!\u0001S\b\u0003\u001b]+\u0017M^3SKN|WO]2f\u0011\u0015Q5\u00011\u0001L\u0003\u0011q\u0017-\\3\u0011\u00051\u001bV\"A'\u000b\u00059{\u0015!\u0003<be&\f'\r\\3t\u0015\t\u0001\u0016+A\u0002bgRT!AU\t\u0002\rA\f'o]3s\u0013\t!VJ\u0001\bOC6,\u0017\nZ3oi&4\u0017.\u001a:\u0002\u0017I,7o\u001c7wKB\u000bG\u000f\u001b\u000b\u0003\u0007^CQ\u0001\u0017\u0003A\u0002e\u000bA\u0001]1uQB\u0011!L\u0018\b\u00037r\u0003\"!K\u000f\n\u0005uk\u0012A\u0002)sK\u0012,g-\u0003\u0002`A\n11\u000b\u001e:j]\u001eT!!X\u000f\u0002\u0015I,7o\u001c7wK\u0006cG\u000e\u0006\u0002dIB\u0019qe\f$\t\u000b)+\u0001\u0019A&\u0002\u001f1|wn[;q%\u0016\u001cx.\u001e:dKN$\"aY4\t\u000ba3\u0001\u0019A-\u0002A\rc\u0017m]:M_\u0006$WM],fCZ,'+Z:pkJ\u001cWMU3t_24XM\u001d\t\u0003E!\u0019\"\u0001C\u000e\u0015\u0003%\fQ!\u00199qYf$\u0012aP\u0001\u0015]>\u001cuN\u001c;fqR\u001cE.Y:tY>\fG-\u001a:\u0002-\r|g\u000e^3yi\u000ec\u0017m]:m_\u0006$WM](oYf\f1\u0003\u001d:pm&$W\rZ\"mCN\u001cHj\\1eKJ$\"a\u0010:\t\u000bMl\u0001\u0019\u0001;\u0002\u0019\rd\u0017m]:M_\u0006$WM]:\u0011\u0007\u001dzS\u0007")
public class ClassLoaderWeaveResourceResolver
implements WeaveResourceResolver {
    private final Seq<Function0<ClassLoader>> classloaders;

    public static ClassLoaderWeaveResourceResolver providedClassLoader(Seq<ClassLoader> seq) {
        return ClassLoaderWeaveResourceResolver$.MODULE$.providedClassLoader(seq);
    }

    public static ClassLoaderWeaveResourceResolver contextClassloaderOnly() {
        return ClassLoaderWeaveResourceResolver$.MODULE$.contextClassloaderOnly();
    }

    public static ClassLoaderWeaveResourceResolver noContextClassloader() {
        return ClassLoaderWeaveResourceResolver$.MODULE$.noContextClassloader();
    }

    public static ClassLoaderWeaveResourceResolver apply() {
        return ClassLoaderWeaveResourceResolver$.MODULE$.apply();
    }

    @Override
    public Option<WeaveResource> resolve(NameIdentifier name) {
        String path = NameIdentifierHelper$.MODULE$.toWeaveFilePath(name, "/");
        return this.resolvePath(path);
    }

    @Override
    public Option<WeaveResource> resolvePath(String path) {
        String weaveFilePath = path.startsWith("/") ? path.substring(1) : path;
        Enumeration<Object> resources = Collections.emptyEnumeration();
        Iterator classLoadersIt = this.classloaders.toIterator();
        while (classLoadersIt.hasNext() && !resources.hasMoreElements()) {
            ClassLoader classLoader = (ClassLoader)((Function0)classLoadersIt.next()).apply();
            resources = classLoader.getResources(weaveFilePath);
        }
        if (resources.hasMoreElements()) {
            Some<WeaveResource> some;
            URL element = (URL)resources.nextElement();
            try (BufferedSource source = Source$.MODULE$.fromInputStream(element.openStream(), "UTF-8");){
                some = new Some<WeaveResource>(WeaveResource$.MODULE$.apply(element.toExternalForm(), source.mkString()));
            }
            return some;
        }
        return None$.MODULE$;
    }

    @Override
    public Seq<WeaveResource> resolveAll(NameIdentifier name) {
        String path = NameIdentifierHelper$.MODULE$.toWeaveFilePath(name, "/");
        return this.lookupResources(path);
    }

    public Seq<WeaveResource> lookupResources(String path) {
        String weaveFilePath = path.startsWith("/") ? path.substring(1) : path;
        Enumeration<Object> resources = Collections.emptyEnumeration();
        Iterator classLoadersIt = this.classloaders.toIterator();
        ArrayBuffer result2 = (ArrayBuffer)ArrayBuffer$.MODULE$.apply(Nil$.MODULE$);
        while (classLoadersIt.hasNext()) {
            ClassLoader classLoader = (ClassLoader)((Function0)classLoadersIt.next()).apply();
            resources = classLoader.getResources(weaveFilePath);
            result2.$plus$plus$eq((TraversableOnce)JavaConverters$.MODULE$.enumerationAsScalaIteratorConverter(resources).asScala().map((Function1<URL, WeaveResource> & Serializable & scala.Serializable)resource -> {
                DefaultWeaveResource defaultWeaveResource;
                try (BufferedSource source = Source$.MODULE$.fromInputStream(resource.openStream(), "UTF-8");){
                    defaultWeaveResource = WeaveResource$.MODULE$.apply(resource.toExternalForm(), source.mkString());
                }
                return defaultWeaveResource;
            }));
        }
        return result2;
    }

    public ClassLoaderWeaveResourceResolver(Seq<Function0<ClassLoader>> classloaders) {
        this.classloaders = classloaders;
        WeaveResourceResolver.$init$(this);
    }
}

