package org.mule.weave.v2.module.flatfile.values

import org.mule.weave.v2.parser.location.InputLocation

class FlatLocation(inputName: String, path: String = "") extends InputLocation {
  override def name: String = inputName

  override def locationString: String = "$" + inputName + path

  def child(subPath: String): FlatLocation = {
    new FlatLocation(inputName, path + "." + subPath)
  }

  def child(index: Int): FlatLocation = {
    new FlatLocation(inputName, path + "[" + index + "]")
  }
}