%dw 2.0
input in0 application/xml
output text/plain  schemaPath="xml-to-copybook-depending-on-without-subject/cd-cpb.ffd", segmentIdent="CLIENTSDETAILS001", missingValues="nulls", notTruncateDependingOnSubjectNotPresent=true
---
[{
	MSGPROTOCOL: in0.ClientsDetails.MsgProtocol,
	MSGPROTOCOLVERSIONNUM: in0.ClientsDetails.MsgProtocolVersionNum,
	MSGTYPECDE: in0.ClientsDetails.MsgTypeCde,
	MSGCLIENTOPERID: in0.ClientsDetails.MsgClientOperId,
	MSGSENDERAPPLID: in0.ClientsDetails.MsgSenderApplId,
	MSGNAME: in0.ClientsDetails.MsgName,
	MSGVERSIONNUM: in0.ClientsDetails.MsgVersionNum,
	KEYS: {
       KEYCNT: if  (in0.ClientsDetails.Keys.KeyCnt != '')  in0.ClientsDetails.Keys.KeyCnt as Number  else 0,
		KEY: in0.ClientsDetails.Keys.*Key map ((key,indexOfKey) -> {
			LEGALENTITYID: key.LegalEntityId,
			((LEGENTIDSRCCDE: if (key.LegEntIdSrcCde != '')  (key.LegEntIdSrcCde as Number)  else 0) if key.LegEntIdSrcCde?),
			LEGENTTYPECDE: key.LegEntTypeCde  ,
			((BASELEGALENTITYID:  if (key.BaseLegalEntityId != '')  (key.BaseLegalEntityId as Number) else 0) if key.BaseLegalEntityId?)
		})
	},
	CLIENTSDETAILSDATA: {
		(LEGALENTITYCNT:  if (in0.ClientsDetails.ClientsDetailsData.LegalEntityCnt != '')  (in0.ClientsDetails.ClientsDetailsData.LegalEntityCnt as Number) else 0),
		((LEGALENTITY: in0.ClientsDetails.ClientsDetailsData.*LegalEntity map ((legalEntity,indexOfLegalEntity) -> {
			LEGALENTITYID: legalEntity.LegalEntityId,
			((LEGENTIDSRCCDE:  if (legalEntity.LegEntIdSrcCde != '')  (legalEntity.LegEntIdSrcCde as Number) else 0) if legalEntity.LegEntIdSrcCde?),
			LEGENTTYPECDE: legalEntity.LegEntTypeCde,
			((BASELEGALENTITYID:  if (legalEntity.BaseLegalEntityId != '')  (legalEntity.BaseLegalEntityId  as Number) else 0) if legalEntity.BaseLegalEntityId?),
			((CLTLIFECYCLECDE:  if (legalEntity.CltLifecycleCde != '')  (legalEntity.CltLifecycleCde as Number) else 0) if legalEntity.CltLifecycleCde?),
			((PERSON: {
					TAXPAYERIDNUM: legalEntity.Person.TaxpayerIdNum,
					((PERSONALNAMCNT:  if (legalEntity.Person.PersonalNamCnt != '')  (legalEntity.Person.PersonalNamCnt as Number) else 0) if legalEntity.Person.PersonalNamCnt?),
					PERSONALNAM: legalEntity.Person.*PersonalNam map ((personalNam,indexOfPersonalNam) -> {
						PERSONLASTNAM: personalNam.PersonLastNam,
						PERSONFIRSTNAM: personalNam.PersonFirstNam
					}),
					BIRTHDATEDTE: legalEntity.Person.BirthdateDte
				}) if legalEntity.Person?) ,
				((EMAILCNT:  if (legalEntity.EMailCnt != '')  (legalEntity.EMailCnt as Number) else 0) if legalEntity.EMailCnt?),
				((EMAIL: legalEntity.*EMail map ((eMail,indexOfEMail) -> {
					EMAILNAM: eMail.EMailNam
				})) if legalEntity.EMail?) ,
				((ADDRESSCNT:  if (legalEntity.AddressCnt != '')  (legalEntity.AddressCnt as Number) else 0) if legalEntity.AddressCnt?),
				((ADDRESS: legalEntity.*Address map ((address,indexOfAddress) -> {
					ZIPCDE: address.ZipCde
				})) if legalEntity.Address?) ,
				((CLIENTIDENTITYCNT:  if (legalEntity.ClientIdentityCnt != '')  (legalEntity.ClientIdentityCnt as Number) else 0) if legalEntity.ClientIdentityCnt?),
				((CLIENTIDENTITY: legalEntity.*ClientIdentity map ((clientIdentity,indexOfClientIdentity) -> {
					NMUNIQUEID: clientIdentity.NmUniqueId,
					LOGINUSAGETYPECDE: clientIdentity.LoginUsageTypeCde
				})) if legalEntity.ClientIdentity?)
		})
	) if in0.ClientsDetails.ClientsDetailsData.LegalEntity?) }
}]