%dw 2.0
input in0 application/xml
output text/plain  schemaPath="xml-dependingon-to-fixed/ccb.ffd", segmentIdent="ANNIVERSARYINSERTED001"
---
[
  {
    MSGPROTOCOL: in0.AnniversaryInserted.MsgProtocol as String,
    MSGPROTOCOLVERSIONNUM: in0.AnniversaryInserted.MsgProtocolVersionNum as String,
    MSGTYPECDE: in0.AnniversaryInserted.MsgTypeCde as String,
    MSGCLIENTOPERID: in0.AnniversaryInserted.MsgClientOperId as String,
    MSGSENDERAPPLID: in0.AnniversaryInserted.MsgSenderApplId as String,
    MSGNAME: in0.AnniversaryInserted.MsgName as String,
    MSGVERSIONNUM: in0.AnniversaryInserted.MsgVersionNum as String,
    MARKETTIMINGBODY: {
      PRODCONTRACTNUM: in0.AnniversaryInserted.MarketTimingBody.ProdContractNum as String default "",
      BUSINESSTRANNUM: in0.AnniversaryInserted.MarketTimingBody.BusinessTranNum as String default "",
      FIRSTRULEVIOLATIONDTE: in0.AnniversaryInserted.MarketTimingBody.FirstRuleViolationDte replace "-" with "" default "",
      BUSINESSTRANEFFDTE: in0.AnniversaryInserted.MarketTimingBody.BusinessTranEffDte replace "-" with "" default "",
      BUSINESSTRANEFFTME: in0.AnniversaryInserted.MarketTimingBody.BusinessTranEffTme as String replace ":" with "" default "",
      RETURNCODE: in0.AnniversaryInserted.MarketTimingBody.ReturnCode as String default "",
      COMPLNCEXCEPTCDE: in0.AnniversaryInserted.MarketTimingBody.ComplncExceptCde as Number,
      CMPLNCEXCEPTTXT: in0.AnniversaryInserted.MarketTimingBody.CmplncExceptTxt as String default "",
      CNTRACTRESTRCDE: in0.AnniversaryInserted.MarketTimingBody.CntrActRestrCde as String default "",
      RESTRICTIONDTE: in0.AnniversaryInserted.MarketTimingBody.RestrictionDte as String default "",
      EXCEPTIONARRAYCOUNT: in0.AnniversaryInserted.MarketTimingBody.ExceptionArrayCount as Number default 0,
      EXCEPTIONARRAY: in0.AnniversaryInserted.MarketTimingBody.*ExceptionArray map (item, pos) -> {
        EXCEPTIONSHORTNAME: item.ExceptionShortName,
        EXCEPTIONNAME: item.ExceptionName,
        EXCEPTIONCURRENTCOUNT: item.ExceptionCurrentCount as Number default 0,
        EXCEPTIONTHRESHOLD: if (item.ExceptionThreshold == null) null else item.ExceptionThreshold as Number
      }
    }
  }
]