%dw 2.0
input in0 application/xml
ns ns0 http://www.biogenidec.com/eip/3pl/jdnet
output text/plain  schemaPath="xml-to-fixed-repeating/shikirisho.ffd", structureIdent="BatchOrders"
---
{
  Batch: in0.ns0#salesOrders.*ns0#salesOrder map (salesOrder, indexOfSalesOrder) -> {
    START: {
      RecordSegment: "S",
      DataIdentifier: salesOrder.ns0#startRecord.ns0#dataIdentifier as String,
      SenderGroupCode: salesOrder.ns0#startRecord.ns0#senderGroupCode as Null,
      SenderCode: salesOrder.ns0#startRecord.ns0#senderCode as String,
      ReceiverGroupCode: salesOrder.ns0#startRecord.ns0#receiverGroupCode as Null,
      ReceiverCode: salesOrder.ns0#startRecord.ns0#receiverCode as String,
      SubFileSeqNum: salesOrder.ns0#startRecord.ns0#subFileSeqNo as Number,
      CreationDate: salesOrder.ns0#startRecord.ns0#creationDate as String,
      CreationMonth: salesOrder.ns0#startRecord.ns0#creationMonth as String,
      LastDataSegment: salesOrder.ns0#startRecord.ns0#lastDataSegment,
      PhysicalRecordLength: salesOrder.ns0#startRecord.ns0#physicalRecordLength as Number,
      LogicalRecordLength: salesOrder.ns0#startRecord.ns0#logicalRecordLength as Number,
      SentFlag: salesOrder.ns0#startRecord.ns0#sentFlag,
      MultDestinationDilveryFlag: salesOrder.ns0#startRecord.ns0#multiDestinationDeliveryFlag,
      SenderIndustryCode: salesOrder.ns0#startRecord.ns0#senderIndustryCode as Number,
      ReceiverIndustryCode: salesOrder.ns0#startRecord.ns0#receiverIndustryCode as Number
    },
    DATA: salesOrder.*ns0#dataRecord map (dataRecord, indexOfDataRecord) -> {
      RecordSegment: "D",
      DataIdentifier: dataRecord.ns0#dataIdentifier as String,
      ManufacturerCode: dataRecord.ns0#wholesalerCode as String,
      ManufacturerSubCode: dataRecord.ns0#wholesalerSubCode as Number,
      WholesalerDepoCode: dataRecord.ns0#wholesalerDepoCode as String,
      JDProductCode: dataRecord.ns0#jdProductCode as Number,
      Quantity: dataRecord.ns0#orderedQuantity as Number,
      CustomerPOIssueDate: dataRecord.ns0#customerPOIssuedDate as String,
      CustomerPONumber: dataRecord.ns0#customerPO,
      JANCode: dataRecord.ns0#janCode as Number,
      UserDefined: dataRecord.ns0#userDefined
    },
    END: {
      RecordSegment: "E",
      DataIdentifier: salesOrder.ns0#endRecord.ns0#dataIdentifier as String,
      NumberOfRecords: salesOrder.ns0#endRecord.ns0#numberOfRecords as Number,
      NumberOfDataRecords: salesOrder.ns0#endRecord.ns0#numberOfDataRecords as Number
    }
  }
}