package org.mule.weave.v2.guava.cache.service.builder

import com.google.common.cache.Cache
import com.google.common.cache.CacheBuilder
import org.mule.weave.v2.cache.service.builder.{ CacheBuilder => DWCacheBuilder }
import org.mule.weave.v2.cache.service.{ Cache => DWCache }
import org.mule.weave.v2.guava.cache.service.GuavaCache

import java.time.Duration

class GuavaCacheBuilder extends DWCacheBuilder {

  private lazy val builder = CacheBuilder.newBuilder()

  override def maximumSize(size: Long): DWCacheBuilder = {
    builder.maximumSize(size)
    this
  }

  override def weakKeys(): DWCacheBuilder = {
    builder.weakKeys()
    this
  }

  override def weakValues(): DWCacheBuilder = {
    builder.weakValues()
    this
  }

  override def expireAfterWrite(duration: Duration): DWCacheBuilder = {
    builder.expireAfterWrite(duration)
    this
  }

  override def build[K, V](): DWCache[K, V] = {
    val value = builder.build()
    new GuavaCache[K, V](value.asInstanceOf[Cache[K, V]], None)
  }

  override def build[K, V](provider: K => V): DWCache[K, V] = {
    val value = builder.build()
    new GuavaCache[K, V](value.asInstanceOf[Cache[K, V]], Some(provider))
  }
}
