/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.v2.module.http.functions.utils;

import java.util.List;
import java.util.Set;
import org.mule.weave.v2.module.http.HttpHeader$;
import org.mule.weave.v2.module.http.service.HttpClientConfiguration;
import org.mule.weave.v2.module.http.service.HttpClientQueryParams;
import org.mule.weave.v2.module.http.service.HttpClientRequest;
import org.mule.weave.v2.module.http.service.HttpClientResponse;
import org.mule.weave.v2.module.http.service.TlsConfiguration;
import scala.Predef$;
import scala.collection.GenSetLike;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;

public final class HttpClientLoggingUtil$ {
    public static HttpClientLoggingUtil$ MODULE$;

    static {
        new HttpClientLoggingUtil$();
    }

    public StringBuilder appendClientConfiguration(StringBuilder buffer, HttpClientConfiguration clientConfiguration) {
        buffer.append(new java.lang.StringBuilder(26).append("connectionTimeout: ").append(clientConfiguration.getConnectionTimeout()).append(" (ms), ").toString());
        buffer.append(new java.lang.StringBuilder(21).append("compressionHeader: ").append(clientConfiguration.isCompressionHeader()).append(", ").toString());
        buffer.append(new java.lang.StringBuilder(14).append("decompress: ").append(clientConfiguration.isDecompress()).append(", ").toString());
        this.appendTlsConfiguration(buffer, clientConfiguration.getTlsConfiguration());
        return buffer;
    }

    private void appendTlsConfiguration(StringBuilder buffer, TlsConfiguration tlsConfiguration) {
        buffer.append("tls: {");
        buffer.append(new java.lang.StringBuilder(10).append("insecure: ").append(tlsConfiguration.isInsecure()).toString());
        buffer.append("}");
    }

    public StringBuilder appendRequest(StringBuilder buffer, HttpClientRequest httpClientRequest) {
        this.appendUrl(buffer, httpClientRequest);
        String contentType = this.resolveContentType(httpClientRequest);
        Object object = new StringOps(Predef$.MODULE$.augmentString(contentType)).nonEmpty() ? buffer.append(new java.lang.StringBuilder(16).append(", Content-Type: ").append(contentType).toString()) : BoxedUnit.UNIT;
        buffer.append(new java.lang.StringBuilder(15).append(", with-body: ").append(httpClientRequest.getBody() != null).append(", ").toString());
        this.appendRequestConfiguration(buffer, httpClientRequest);
        return buffer;
    }

    private void appendUrl(StringBuilder buffer, HttpClientRequest httpClientRequest) {
        buffer.append(new java.lang.StringBuilder(8).append("url: (").append(httpClientRequest.getMethod()).append(") ").append(httpClientRequest.getUrl()).toString());
        this.appendQueryParams(buffer, httpClientRequest);
    }

    private void appendQueryParams(StringBuilder buffer, HttpClientRequest httpClientRequest) {
        if (httpClientRequest.getQueryParams() != null) {
            HttpClientQueryParams queryParams = httpClientRequest.getQueryParams();
            Set<String> queryParamsNames = queryParams.namesIgnoreCase();
            if (!queryParamsNames.isEmpty()) {
                buffer.append('?');
                Iterator iterator = ((GenSetLike)JavaConverters$.MODULE$.asScalaSetConverter(queryParamsNames).asScala()).iterator();
                while (iterator.hasNext()) {
                    String queryParamName = (String)iterator.next();
                    java.util.Iterator<String> valuesIterator = queryParams.allValuesIgnoreCase(queryParamName).iterator();
                    while (valuesIterator.hasNext()) {
                        String value = valuesIterator.next();
                        buffer.append(new java.lang.StringBuilder(1).append(queryParamName).append("=").append(value).toString());
                        Object object = valuesIterator.hasNext() ? buffer.append('&') : BoxedUnit.UNIT;
                    }
                    Object object = iterator.hasNext() ? buffer.append(',') : BoxedUnit.UNIT;
                }
                return;
            }
            return;
        }
    }

    private String resolveContentType(HttpClientRequest httpClientRequest) {
        List<String> contentTypes;
        StringBuilder buffer = new StringBuilder();
        if (httpClientRequest.getHeaders() != null && !(contentTypes = httpClientRequest.getHeaders().allValuesIgnoreCase(HttpHeader$.MODULE$.CONTENT_TYPE_HEADER())).isEmpty()) {
            Iterator iterator = ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(contentTypes).asScala()).iterator();
            while (iterator.hasNext()) {
                buffer.append((String)iterator.next());
                Object object = iterator.hasNext() ? buffer.append(',') : BoxedUnit.UNIT;
            }
        }
        return buffer.toString();
    }

    private void appendRequestConfiguration(StringBuilder buffer, HttpClientRequest httpClientRequest) {
        buffer.append("config: {");
        buffer.append(new java.lang.StringBuilder(19).append("followRedirects: ").append(httpClientRequest.isFollowRedirects()).append(", ").toString());
        buffer.append(new java.lang.StringBuilder(23).append("requestTimeout: ").append(httpClientRequest.getRequestTimeout()).append(" (ms), ").toString());
        buffer.append(new java.lang.StringBuilder(18).append("readTimeout: ").append(httpClientRequest.getReadTimeout()).append(" (ms)").toString());
        buffer.append("}");
    }

    public StringBuilder appendResponse(StringBuilder buffer, HttpClientResponse httpResponse) {
        buffer.append(new java.lang.StringBuilder(8).append("status: ").append(httpResponse.getStatus()).toString());
        httpResponse.getStatusText().ifPresent(statusText -> buffer.append(new java.lang.StringBuilder(3).append(" (").append((String)statusText).append(")").toString()));
        Object object = httpResponse.getContentType().isPresent() ? buffer.append(new java.lang.StringBuilder(16).append(", Content-Type: ").append((Object)httpResponse.getContentType().get()).toString()) : BoxedUnit.UNIT;
        buffer.append(new java.lang.StringBuilder(13).append(", with-body: ").append(httpResponse.getBody().isPresent()).toString());
        return buffer;
    }

    private HttpClientLoggingUtil$() {
        MODULE$ = this;
    }
}

