/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.v2.module.http.undertow;

import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.HeaderMap;
import io.undertow.util.HeaderValues;
import io.undertow.util.Headers;
import io.undertow.util.HttpString;
import io.undertow.util.Protocols;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Map;
import org.mule.weave.v2.module.http.service.HttpServerRequest;
import org.mule.weave.v2.module.http.service.HttpServerResponse;
import org.mule.weave.v2.module.http.undertow.InputStreamSender;
import org.mule.weave.v2.module.http.undertow.InputStreamSender$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001%3A!\u0001\u0002\u0001#\t)RK\u001c3feR|woU3sm\u0016\u0014\b*\u00198eY\u0016\u0014(BA\u0002\u0005\u0003!)h\u000eZ3si><(BA\u0003\u0007\u0003\u0011AG\u000f\u001e9\u000b\u0005\u001dA\u0011AB7pIVdWM\u0003\u0002\n\u0015\u0005\u0011aO\r\u0006\u0003\u00171\tQa^3bm\u0016T!!\u0004\b\u0002\t5,H.\u001a\u0006\u0002\u001f\u0005\u0019qN]4\u0004\u0001M\u0019\u0001A\u0005\u000e\u0011\u0005MAR\"\u0001\u000b\u000b\u0005U1\u0012\u0001\u00027b]\u001eT\u0011aF\u0001\u0005U\u00064\u0018-\u0003\u0002\u001a)\t1qJ\u00196fGR\u0004\"aG\u0011\u000e\u0003qQ!!\b\u0010\u0002\rM,'O^3s\u0015\t\u0019qDC\u0001!\u0003\tIw.\u0003\u0002#9\tY\u0001\n\u001e;q\u0011\u0006tG\r\\3s\u0011!!\u0003A!A!\u0002\u0013)\u0013\u0001C2bY2\u0014\u0017mY6\u0011\t\u0019J3&M\u0007\u0002O)\t\u0001&A\u0003tG\u0006d\u0017-\u0003\u0002+O\tIa)\u001e8di&|g.\r\t\u0003Y=j\u0011!\f\u0006\u0003]\u0011\tqa]3sm&\u001cW-\u0003\u00021[\t\t\u0002\n\u001e;q'\u0016\u0014h/\u001a:SKF,Xm\u001d;\u0011\u00051\u0012\u0014BA\u001a.\u0005IAE\u000f\u001e9TKJ4XM\u001d*fgB|gn]3\t\u000bU\u0002A\u0011\u0001\u001c\u0002\rqJg.\u001b;?)\t9\u0014\b\u0005\u00029\u00015\t!\u0001C\u0003%i\u0001\u0007Q\u0005C\u0003<\u0001\u0011\u0005C(A\u0007iC:$G.\u001a*fcV,7\u000f\u001e\u000b\u0003{\u0001\u0003\"A\n \n\u0005}:#\u0001B+oSRDQ!\u0011\u001eA\u0002\t\u000b\u0001\"\u001a=dQ\u0006tw-\u001a\t\u00037\rK!\u0001\u0012\u000f\u0003%!#H\u000f]*feZ,'/\u0012=dQ\u0006tw-\u001a\u0005\u0006\r\u0002!IaR\u0001\rEVLG\u000e\u001a*fcV,7\u000f\u001e\u000b\u0003W!CQ!Q#A\u0002\t\u0003")
public class UndertowServerHandler
implements HttpHandler {
    private final Function1<HttpServerRequest, HttpServerResponse> callback;

    public void handleRequest(HttpServerExchange exchange) {
        block5: {
            if (exchange.isInIoThread()) {
                HeaderValues upgrade = exchange.getRequestHeaders().get(Headers.UPGRADE);
                Object object = upgrade != null && upgrade.contains((Object)"h2c") ? exchange.setProtocol(Protocols.HTTP_1_1) : BoxedUnit.UNIT;
                exchange.dispatch((HttpHandler)this);
            } else {
                exchange.startBlocking();
                HttpServerRequest request = this.buildRequest(exchange);
                try {
                    HttpServerResponse response = (HttpServerResponse)this.callback.apply((Object)request);
                    exchange.setStatusCode(response.statusCode());
                    response.headers().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                        Tuple2 tuple2 = x0$1;
                        if (tuple2 == null) {
                            throw new MatchError((Object)tuple2);
                        }
                        String key = (String)tuple2._1();
                        String value = (String)tuple2._2();
                        HeaderMap headerMap = exchange.getResponseHeaders().add(new HttpString(key), value);
                        return headerMap;
                    });
                    if (response.body() != null) {
                        new InputStreamSender(response.body(), exchange, response.closeCallBack(), InputStreamSender$.MODULE$.$lessinit$greater$default$4(), InputStreamSender$.MODULE$.$lessinit$greater$default$5(), InputStreamSender$.MODULE$.$lessinit$greater$default$6(), InputStreamSender$.MODULE$.$lessinit$greater$default$7()).send();
                        break block5;
                    }
                    exchange.endExchange();
                }
                catch (Error e) {
                    System.err.println("[ERROR] Unexpected error occurred.");
                    e.printStackTrace();
                    exchange.endExchange();
                }
            }
        }
    }

    private HttpServerRequest buildRequest(HttpServerExchange exchange) {
        InputStream body = exchange.getInputStream();
        HeaderMap requestMultiMap = exchange.getRequestHeaders();
        ArrayBuffer headers = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        requestMultiMap.forEach(headerValue -> {
            HttpString headerName = headerValue.getHeaderName();
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])headerValue.toArray())).foreach((Function1 & Serializable & scala.Serializable)value -> headers.$plus$eq((Object)new Tuple2((Object)headerName.toString(), value)));
        });
        Map queryParametersMultiMap = exchange.getQueryParameters();
        ArrayBuffer queryParams = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        queryParametersMultiMap.forEach((name, queue) -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps(queue.toArray())).foreach((Function1 & Serializable & scala.Serializable)value -> queryParams.$plus$eq((Object)new Tuple2(name, (Object)value.toString()))));
        String relativePath = exchange.getRelativePath();
        return new HttpServerRequest(body, relativePath, exchange.getRequestMethod().toString(), (Seq<Tuple2<String, String>>)headers, (Seq<Tuple2<String, String>>)queryParams);
    }

    public UndertowServerHandler(Function1<HttpServerRequest, HttpServerResponse> callback) {
        this.callback = callback;
    }
}

