package org.mule.weave.v2.module.commons.java.value

import org.mule.weave.v2.model.EvaluationContext
import org.mule.weave.v2.model.values.BooleanValue

class JavaBooleanValue(val v: Boolean, javaValue: Any, val locationString: () => String) extends BooleanValue with JavaValue[Boolean] {
  override def evaluate(implicit ctx: EvaluationContext): Boolean = v

  override def underlying()(implicit ctx: EvaluationContext): Any = javaValue

}

object JavaBooleanValue {
  def apply(v: Boolean, locationString: () => String): JavaBooleanValue = new JavaBooleanValue(v, v, locationString)

  def apply(v: Boolean, underlying: Any, locationString: () => String): JavaBooleanValue = new JavaBooleanValue(v, underlying, locationString)
}
