package org.mule.weave.v2.module.commons.java.writer.converter

import org.mule.weave.v2.model.EvaluationContext
import org.mule.weave.v2.model.structure.schema.Schema

import java.sql.Clob
import javax.sql.rowset.serial.SerialClob

class ClobDataConverter extends DataConverter[Clob] {
  override def convert(source: Any, schema: Option[Schema])(implicit ctx: EvaluationContext): Option[Clob] = {
    val stringConverter = new StringDataConverter
    stringConverter.convert(source, schema).map((st: String) => new SerialClob(st.toCharArray))
  }
}
