package org.mule.weave.v2.module.commons.java.writer.converter

import org.mule.weave.v2.model.EvaluationContext
import org.mule.weave.v2.model.structure.schema.Schema
import org.mule.weave.v2.model.values.math.Number

class LongDataConverter extends DataConverter[Long] {
  override def convert(source: Any, schema: Option[Schema])(implicit ctx: EvaluationContext): Option[Long] = {
    source match {
      case l: Long                  => Option(l)
      case i: Int                   => Option(i.toLong)
      case d: Double                => Option(d.toLong)
      case d: Float                 => Option(d.toLong)
      case s: Short                 => Option(s.toLong)
      case n: Number                => Option(n.toLong)
      case bd: java.math.BigDecimal => Option(bd.longValue())
      case bi: java.math.BigInteger => Option(bi.longValue())
      case str: String              => Option(str.toLong)
      case _                        => None
    }
  }
}
