package org.mule.weave.v2.module.pojo.function

import org.mule.weave.v2.model.EvaluationContext
import org.mule.weave.v2.model.ServiceRegistration
import org.mule.weave.v2.model.types.FunctionType
import org.mule.weave.v2.model.values.FunctionValue
import org.mule.weave.v2.model.values.Value
import org.mule.weave.v2.module.commons.java.writer.entry.SimpleEntry
import org.mule.weave.v2.module.pojo.JavaDataFormat
import org.mule.weave.v2.module.pojo.reader.ReflectionJavaValueConverter
import org.mule.weave.v2.module.pojo.writer.FunctionWriterService
import org.mule.weave.v2.module.pojo.writer.JavaWriter
import org.mule.weave.v2.module.pojo.writer.converter.JavaDataConverter

import java.util
import java.util.Collections

class WeaveFunctionWrapper(fn: FunctionValue)(implicit ctx: EvaluationContext) extends java.util.function.Function[util.List[Any], Any] with AutoCloseable {

  override def apply(list: util.List[Any]): Any = {
    import scala.collection.JavaConverters._
    val theArguments: util.List[_] =
      if (list == null) {
        Collections.emptyList()
      } else {
        list
      }

    val args: Seq[Value[_]] = theArguments.asScala.map(arg => {
      ReflectionJavaValueConverter.convert(arg, () => "Java Argument")
    })
    val value = fn.call(args.toArray)(EvaluationContext(ctx.serviceManager))
    val writer = JavaDataFormat.defaultSettingsWriter(None)
    writer.writeValue(value)
    writer.result
  }
  override def close(): Unit = {
    val service = ctx.serviceManager.lookupCustomService(classOf[FunctionWriterService]).get
    if (service.functionsBeforeClose.decrementAndGet() == 0) {
      ctx.close()
    }
  }
}

class FunctionWriterServiceImpl extends FunctionWriterService {

  def write(theValue: Value[_], writer: JavaWriter)(implicit ctx: EvaluationContext): Unit = {
    ctx.newAsyncExecution()
    functionsBeforeClose.incrementAndGet()

    val schemaOption = theValue.schema
    val fn = FunctionType.coerce(theValue)
    val javaFn = new WeaveFunctionWrapper(fn)
    writer.write(new SimpleEntry(javaFn, theValue, schemaOption)(JavaDataConverter))
  }
}

class FunctionWriterServiceRegistration extends ServiceRegistration[FunctionWriterService] {
  override def service: Class[FunctionWriterService] = classOf[FunctionWriterService]

  override def implementation: FunctionWriterService = {
    new FunctionWriterServiceImpl()
  }
}