package org.mule.weave.v2.module.pojo.reader

import org.mule.weave.v2.model.EvaluationContext
import org.mule.weave.v2.model.structure.schema.Schema
import org.mule.weave.v2.model.values.StringValue
import org.mule.weave.v2.module.commons.java.value.JavaSchema
import org.mule.weave.v2.module.commons.java.value.JavaValue
import org.mule.weave.v2.module.pojo.writer.JavaTypes

class JavaEnumValue(v: Enum[_], clazz: Class[_], val locationString: () => String) extends StringValue with JavaValue[String] {

  override def schema(implicit ctx: EvaluationContext): Option[Schema] = {
    Some(JavaSchema(underlying().getClass, JavaTypes.enumeration_propertySeq))
  }

  override def underlying()(implicit ctx: EvaluationContext): Any = v

  override def evaluate(implicit ctx: EvaluationContext): String = v.name()
}

object JavaEnumValue {
  def apply(v: Enum[_], loc: () => String) = new JavaEnumValue(v, v.getClass, loc)
}
