/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.v2.module.pojo.writer.converter;

import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoField;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.mule.weave.v2.model.EvaluationContext;
import org.mule.weave.v2.model.structure.schema.Schema;
import org.mule.weave.v2.module.pojo.writer.converter.DataConverter;
import scala.Function0;
import scala.Option;
import scala.Option$;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\u00114A!\u0001\u0002\u0001'\t)2)\u00197f]\u0012\f'\u000fR1uC\u000e{gN^3si\u0016\u0014(BA\u0002\u0005\u0003%\u0019wN\u001c<feR,'O\u0003\u0002\u0006\r\u00051qO]5uKJT!a\u0002\u0005\u0002\tA|'n\u001c\u0006\u0003\u0013)\ta!\\8ek2,'BA\u0006\r\u0003\t1(G\u0003\u0002\u000e\u001d\u0005)q/Z1wK*\u0011q\u0002E\u0001\u0005[VdWMC\u0001\u0012\u0003\ry'oZ\u0002\u0001'\r\u0001AC\u0007\t\u0003+ai\u0011A\u0006\u0006\u0002/\u0005)1oY1mC&\u0011\u0011D\u0006\u0002\u0007\u0003:L(+\u001a4\u0011\u0007mab$D\u0001\u0003\u0013\ti\"AA\u0007ECR\f7i\u001c8wKJ$XM\u001d\t\u0003?\u0011j\u0011\u0001\t\u0006\u0003C\t\nA!\u001e;jY*\t1%\u0001\u0003kCZ\f\u0017BA\u0013!\u0005!\u0019\u0015\r\\3oI\u0006\u0014\b\"B\u0014\u0001\t\u0003A\u0013A\u0002\u001fj]&$h\bF\u0001*!\tY\u0002\u0001C\u0003,\u0001\u0011\u0005C&A\u0004d_:4XM\u001d;\u0015\u00075Jd\b\u0006\u0002/cA\u0019Qc\f\u0010\n\u0005A2\"AB(qi&|g\u000eC\u00033U\u0001\u000f1'A\u0002dib\u0004\"\u0001N\u001c\u000e\u0003UR!A\u000e\u0006\u0002\u000b5|G-\u001a7\n\u0005a*$!E#wC2,\u0018\r^5p]\u000e{g\u000e^3yi\")!H\u000ba\u0001w\u000511o\\;sG\u0016\u0004\"!\u0006\u001f\n\u0005u2\"aA!os\")qH\u000ba\u0001\u0001\u000611o\u00195f[\u0006\u00042!F\u0018B!\t\u0011e)D\u0001D\u0015\tyDI\u0003\u0002Fk\u0005I1\u000f\u001e:vGR,(/Z\u0005\u0003\u000f\u000e\u0013aaU2iK6\f\u0007\"B%\u0001\t\u0003Q\u0015AC1t\u0007\u0006dWM\u001c3beR\u0011ad\u0013\u0005\u0006\u0019\"\u0003\r!T\u0001\u0005i&lW\r\u0005\u0002O!6\tqJ\u0003\u0002ME%\u0011\u0011k\u0014\u0002\u000e5>tW\r\u001a#bi\u0016$\u0016.\\3\t\u000bM\u0003A\u0011\u0001+\u0002\u0017\u001d,G\u000fV5nKj{g.\u001a\u000b\u0003+b\u0003\"a\b,\n\u0005]\u0003#\u0001\u0003+j[\u0016TvN\\3\t\u000b1\u0013\u0006\u0019A'\t\u000bi\u0003A\u0011A.\u0002-\u0019\fG\u000e\u001c2bG.\u001cFO]5oO\u000e{WM]2j_:$\"!\u0014/\t\u000buK\u0006\u0019\u00010\u0002\u0007M$(\u000f\u0005\u0002`E6\t\u0001M\u0003\u0002bE\u0005!A.\u00198h\u0013\t\u0019\u0007M\u0001\u0004TiJLgn\u001a")
public class CalendarDataConverter
implements DataConverter<Calendar> {
    @Override
    public Option<String> format(Map<String, Object> arguments) {
        return DataConverter.format$(this, arguments);
    }

    @Override
    public Option<String> separator(Map<String, Object> arguments) {
        return DataConverter.separator$(this, arguments);
    }

    @Override
    public Option<String> encoding(Map<String, Object> arguments) {
        return DataConverter.encoding$(this, arguments);
    }

    @Override
    public Option<Calendar> convert(Object source, Option<Schema> schema, EvaluationContext ctx) {
        Calendar calendar;
        Object object = source;
        if (object instanceof LocalDateTime) {
            LocalDateTime localDateTime = (LocalDateTime)object;
            Calendar instance = Calendar.getInstance();
            instance.set(localDateTime.getYear(), localDateTime.getMonthValue() - 1, localDateTime.getDayOfMonth(), localDateTime.getHour(), localDateTime.getMinute(), localDateTime.getSecond());
            instance.set(14, localDateTime.get(ChronoField.MILLI_OF_SECOND));
            calendar = instance;
        } else if (object instanceof ZonedDateTime) {
            ZonedDateTime zonedDateTime = (ZonedDateTime)object;
            calendar = this.asCalendar(zonedDateTime);
        } else if (object instanceof LocalTime) {
            LocalTime localTime = (LocalTime)object;
            Calendar instance = Calendar.getInstance();
            instance.set(11, localTime.getHour());
            instance.set(12, localTime.getMinute());
            instance.set(13, localTime.getSecond());
            instance.set(14, localTime.get(ChronoField.MILLI_OF_SECOND));
            calendar = instance;
        } else if (object instanceof OffsetTime) {
            OffsetTime offsetTime = (OffsetTime)object;
            Calendar instance = Calendar.getInstance(TimeZone.getTimeZone(offsetTime.getOffset().getId()));
            instance.set(11, offsetTime.getHour());
            instance.set(12, offsetTime.getMinute());
            instance.set(13, offsetTime.getSecond());
            instance.set(14, offsetTime.get(ChronoField.MILLI_OF_SECOND));
            calendar = instance;
        } else if (object instanceof LocalDate) {
            LocalDate localDate = (LocalDate)object;
            Calendar instance = Calendar.getInstance();
            instance.set(2, localDate.getMonthValue() - 1);
            instance.set(5, localDate.getDayOfMonth());
            instance.set(1, localDate.getYear());
            instance.set(11, 0);
            instance.set(12, 0);
            instance.set(13, 0);
            instance.set(14, 0);
            calendar = instance;
        } else if (object instanceof Long) {
            long l = BoxesRunTime.unboxToLong((Object)object);
            Calendar instance = Calendar.getInstance();
            instance.setTime(new Date(l));
            calendar = instance;
        } else if (object instanceof String) {
            String string = (String)object;
            ZonedDateTime zonedDateTime = this.fallbackStringCoercion(string);
            calendar = this.asCalendar(zonedDateTime);
        } else {
            Calendar calendar2;
            calendar = object instanceof Calendar ? (calendar2 = (Calendar)object) : null;
        }
        Calendar calendar3 = calendar;
        return Option$.MODULE$.apply((Object)calendar3);
    }

    /*
     * WARNING - void declaration
     */
    public Calendar asCalendar(ZonedDateTime time) {
        void var2_2;
        Calendar instance = Calendar.getInstance(this.getTimeZone(time));
        instance.set(time.getYear(), time.getMonthValue() - 1, time.getDayOfMonth(), time.getHour(), time.getMinute(), time.getSecond());
        instance.set(14, time.get(ChronoField.MILLI_OF_SECOND));
        return var2_2;
    }

    public TimeZone getTimeZone(ZonedDateTime time) {
        String string;
        String string2 = time.getZone().getId();
        TimeZone timeZone = string2 != null && (string = string2).matches("[+-][0-9]{2}:[0-9]{2}") ? TimeZone.getTimeZone(new StringBuilder(3).append("GMT").append(time.getZone().getId()).toString()) : TimeZone.getTimeZone(time.getZone().getId());
        return timeZone;
    }

    public ZonedDateTime fallbackStringCoercion(String str) {
        return (ZonedDateTime)Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> ZonedDateTime.parse(str)).orElse((Function0 & Serializable & scala.Serializable)() -> Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> LocalDateTime.parse(str).atZone(ZoneOffset.UTC))).get();
    }

    public CalendarDataConverter() {
        DataConverter.$init$(this);
    }
}

