%dw 2.0

/**
* Invokes a static java function over the specified class name.
*
* The parameters are :
*
* - className: The name of the class
* - methodName: The name of the static method to invoke
* - paramTypes: An array of the class names of that method to invoke
* - args: The argument values
*/
fun invoke (className: String, methodName: String, paramTypes: Array<String>, args: Array<Any>) = native("java::JavaInvokeFunction")

/**
* Retrieves the value of the field with the specified name
*/
fun field (className: String, fieldName: String) = native("java::JavaFieldRefFunction")

