package org.mule.weave.v2.module.javaplain

import org.mule.weave.v2.model.EvaluationContext
import org.mule.weave.v2.module.DataFormat
import org.mule.weave.v2.module.commons.java.writer.JavaWriterSettings
import org.mule.weave.v2.module.javaplain.reader.JavaPlainReader
import org.mule.weave.v2.module.javaplain.writer.JavaPlainWriter
import org.mule.weave.v2.module.option.EmptySettings
import org.mule.weave.v2.module.option.Settings
import org.mule.weave.v2.module.reader.Reader
import org.mule.weave.v2.module.reader.SourceProvider
import org.mule.weave.v2.module.writer.Writer
import org.mule.weave.v2.parser.module.MimeType

class JavaPlainDataFormat extends DataFormat[Settings, JavaWriterSettings] {
  override def name(): String = "java"

  override val defaultMimeType: MimeType = new MimeType("application", "java")

  override val acceptedMimeTypes: Seq[MimeType] = Seq(defaultMimeType)

  override def reader(source: SourceProvider)(implicit ctx: EvaluationContext): Reader = new JavaPlainReader(source.underling)

  override def writer(target: Option[Any], outputMimeType: MimeType)(implicit ctx: EvaluationContext): JavaPlainWriter =
    new JavaPlainWriter(createWriterSettings())

  override protected def writerSettings(): JavaWriterSettings = new JavaWriterSettings()

  override protected def readerSettings(): Settings = EmptySettings

  override def fileExtensions: Seq[String] = Seq()
}

object JavaPlainDataFormat extends JavaPlainDataFormat
