package org.mule.weave.v2.module.javaplain.reader

import org.mule.weave.v2.model.EvaluationContext
import org.mule.weave.v2.model.values.Value
import org.mule.weave.v2.module.commons.java.value.JavaMapObjectValue
import org.mule.weave.v2.module.commons.java.value.JavaValueConverter
import org.mule.weave.v2.module.javaplain.exception.UnsupportedJavaValueException

object JavaPlainValueConverter extends JavaValueConverter {
  override def doConvertValue(value: Any, loc: () => String)(implicit ctx: EvaluationContext): Value[_] = {
    value match {
      case map: java.util.Map[Any, Any] => new JavaMapObjectValue(map, loc, this)
      case _                            => throw UnsupportedJavaValueException(loc(), value.getClass)
    }
  }
}
