/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.extension.api.component.structure;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.mule.weave.extension.api.component.structure.WeaveDescriptorFile;
import org.mule.weave.extension.api.component.structure.WeaveModuleStructure;
import org.mule.weave.extension.api.component.structure.WeaveProjectStructure;
import org.mule.weave.extension.api.component.structure.WeaveRootKind;
import org.mule.weave.extension.api.component.structure.WeaveRootStructure;
import org.mule.weave.extension.api.component.structure.WeaveTargetFolder;
import org.mule.weave.extension.api.component.structure.WeaveTargetKind;

public class WeaveProjectStructureBuilder {
    private final List<ModuleStructureBuilder> modules = new ArrayList<ModuleStructureBuilder>();

    public ModuleStructureBuilder addModule() {
        ModuleStructureBuilder moduleStructureBuilder = new ModuleStructureBuilder();
        this.modules.add(moduleStructureBuilder);
        return moduleStructureBuilder;
    }

    public WeaveProjectStructure build() {
        return new WeaveProjectStructure((WeaveModuleStructure[])this.modules.stream().map(ModuleStructureBuilder::build).toArray(WeaveModuleStructure[]::new));
    }

    public static class ModuleStructureBuilder {
        private String name;
        private final List<RootStructureBuilder> roots = new ArrayList<RootStructureBuilder>();
        private final List<WeaveTargetFolderBuilder> targets = new ArrayList<WeaveTargetFolderBuilder>();
        private final List<WeaveDescriptorFile> descriptors = new ArrayList<WeaveDescriptorFile>();

        public ModuleStructureBuilder withName(String name) {
            this.name = name;
            return this;
        }

        public ModuleStructureBuilder addDescriptor(String kind, File descriptor) {
            this.descriptors.add(new WeaveDescriptorFile(kind, descriptor));
            return this;
        }

        public RootStructureBuilder addRoot() {
            RootStructureBuilder e = new RootStructureBuilder();
            this.roots.add(e);
            return e;
        }

        public WeaveTargetFolderBuilder addTarget() {
            WeaveTargetFolderBuilder e = new WeaveTargetFolderBuilder();
            this.targets.add(e);
            return e;
        }

        public WeaveModuleStructure build() {
            if (this.name == null) {
                throw new RuntimeException("Missing name field");
            }
            return new WeaveModuleStructure(this.name, (WeaveRootStructure[])this.roots.stream().map(RootStructureBuilder::build).toArray(WeaveRootStructure[]::new), (WeaveTargetFolder[])this.targets.stream().map(WeaveTargetFolderBuilder::build).toArray(WeaveTargetFolder[]::new), (WeaveDescriptorFile[])this.descriptors.toArray(WeaveDescriptorFile[]::new));
        }
    }

    public static class WeaveTargetFolderBuilder {
        private WeaveTargetKind kind = WeaveTargetKind.RESOURCES;
        private final List<File> files = new ArrayList<File>();

        public WeaveTargetFolderBuilder withKind(WeaveTargetKind kind) {
            this.kind = kind;
            return this;
        }

        public WeaveTargetFolderBuilder addTargetDir(File dir) {
            this.files.add(dir);
            return this;
        }

        public WeaveTargetFolder build() {
            return new WeaveTargetFolder(this.kind, (File[])this.files.toArray(File[]::new));
        }
    }

    public static class RootStructureBuilder {
        private WeaveRootKind kind = WeaveRootKind.MAIN;
        private final List<File> sources = new ArrayList<File>();
        private final List<File> resources = new ArrayList<File>();
        private File defaultSourceFolder;

        public RootStructureBuilder withKind(WeaveRootKind kind) {
            this.kind = kind;
            return this;
        }

        public RootStructureBuilder addSource(File source) {
            if (this.defaultSourceFolder == null) {
                this.defaultSourceFolder = source;
            }
            this.sources.add(source);
            return this;
        }

        public RootStructureBuilder addResource(File source) {
            if (this.defaultSourceFolder == null) {
                this.defaultSourceFolder = source;
            }
            this.resources.add(source);
            return this;
        }

        public RootStructureBuilder withDefaultSourceFolder(File source) {
            this.defaultSourceFolder = source;
            return this;
        }

        public WeaveRootStructure build() {
            return new WeaveRootStructure(this.kind, (File[])this.sources.toArray(File[]::new), (File[])this.resources.toArray(File[]::new), this.defaultSourceFolder);
        }

        public void addSources(List<File> srcFolders) {
            for (File srcFolder : srcFolders) {
                this.addSource(srcFolder);
            }
        }

        public void addResources(List<File> resourceFolders) {
            for (File resourceFolder : resourceFolders) {
                this.addResource(resourceFolder);
            }
        }
    }
}

