package org.mule.weave.extension.api.component.structure;

import java.io.File;

public class WeaveRootStructure {
    private final WeaveRootKind kind;
    private final File[] sources;
    private final File[] resources;
    private final File defaultSourceFolder;

    public WeaveRootStructure(WeaveRootKind kind, File[] sources, File[] resources, File defaultSourceFolder) {
        this.kind = kind;
        this.sources = sources;
        this.resources = resources;
        this.defaultSourceFolder = defaultSourceFolder;
    }

    public WeaveRootKind kind() {
        return kind;
    }

    public File[] sources() {
        return sources;
    }

    public File[] resources() {
        return resources;
    }

    public File defaultSourceFolder() {
        return defaultSourceFolder;
    }
}
