package org.mule.weave.extension.api.extension.command;

import org.eclipse.lsp4j.ExecuteCommandParams;

/**
 * A Command to be executed on the LSP.
 */
public interface WeaveCommand {

    /**
     * @return The id of the underlying command
     */
    String commandId();

    /**
     * @return The name of the command
     */
    String name();

    /**
     * This message is going to be presented to the user as information of what the command is running
     *
     * @param params The command parameters.
     * @return A description of the current command is doing.
     */
    String description(ExecuteCommandParams params);

    /**
     * Executes the given command with the specified parameters
     *
     * @param params The command parameters
     * @return The result of the executed command.
     */
    Object execute(ExecuteCommandParams params);

}
