package org.mule.weave.extension.api.extension.indexer;

import java.util.List;

/**
 * A Partition represents a set of values of a given indexer ID
 * @param <K> The key of the indexed entries
 * @param <V> The value type of the indexed values
 */
public interface IndexPartition<K, V> {

    /**
     * Return the list of all the values for the given key
     * @param key The key to use to search
     * @return The list of values
     */
    List<V> entriesFor(K key);

    /**
     * Return the list of all the keys
     * @return The list of keys
     */
    List<K> getKeys();

}
