package org.mule.weave.extension.api.extension.indexer;

import java.util.Objects;

/**
 * The ID to be used to represent the Indexer. This is going to be used to create its own Region of values
 * @param <K> The Indexer key.
 * @param <V> The Indexer value.
 */
public class IndexerID<K, V> {
    private Class<? extends IndexerExtension<K, V>> owner;

    public IndexerID(Class<? extends IndexerExtension<K, V>> name) {
        this.owner = name;
    }

    public Class<? extends IndexerExtension<K, V>> getOwner() {
        return owner;
    }

    @Override
    public boolean equals(Object o) {
        if (o == null || getClass() != o.getClass()) return false;
        IndexerID<?, ?> indexerID = (IndexerID<?, ?>) o;
        return Objects.equals(owner, indexerID.owner);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(owner);
    }

    public static <K, V> IndexerID<K, V> create(Class<? extends IndexerExtension<K, V>> name) {
        return new IndexerID<K, V>(name);
    }
}
