package org.mule.weave.extension.api.extension.validation;

/**
 * A validator that given a {@link DocumentNode} reports error/warning constraint violations.
 * It defines the validation phase and a filter depending on the URI if it should be triggered or not.
 * This component allow custom experiences.
 */
public interface WeaveValidator {

    ValidationTypeLevel validationLevel();

    boolean appliesTo(String uri);

    void validate(DocumentNode documentNode, MessageValidationCollector collector, MessageBuilderFactory messageBuilderFactory);
}
