package org.mule.weave.extension.api.filesystem;

import org.mule.weave.v2.api.tooling.location.ResourceIdentifier;

/**
 * Represents a file, could be a file in memory, inside a jar etc.
 */
public interface VirtualFile {

    /**
     * The url of this file.
     * I.E file://a/b.dwl or virtual:/foo/bar.dwl for in memory files¬
     *
     * @return The URL String
     */
    String url();

    /**
     * @return the {@link ResourceIdentifier}.
     */
    ResourceIdentifier resourceIdentifier();
}
