package org.mule.weave.extension.api.lifecycle;

public interface LanguageServerLifecycle {
    /**
     * The init is being called when the LSP is initializing.
     * At this stage the connection to the client has not yet been established and other component or services are not yet ready to be used.
     * It is safe to register for events, but not to use other components at this moment.
     * Each component needs to init its values at this moment.
     */
    default void initialize() {
    }

    /**
     * At this staged the LSP has been already initialized.
     */
    default void initialized() {
    }

    /**
     * Called when the Language Server is being shutdown
     */
    default void shutdown() {
    }
}
