package org.mule.weave.extension.api.lsp.utils;

import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.mule.weave.v2.api.tooling.location.Location;

public class LSPConverters {

    private LSPConverters() {}

    public static final Position toPosition(org.mule.weave.v2.api.tooling.location.Position dwPosition) {
        var position = new Position();
        var column = (dwPosition.getColumn() <= 0) ? 0 : dwPosition.getColumn() - 1;
        var line = (dwPosition.getLine() <= 0) ? 0 : dwPosition.getLine() - 1;
        position.setCharacter(column);
        position.setLine(line);
        return position;
    }

    public static final Range toRange(Location location) {
        return new Range(toPosition(location.getStartPosition()), toPosition(location.getEndPosition()));
    }

}
