package org.mule.weave.extension.api.services.mapping;

import org.mule.weave.extension.api.services.WeaveService;

import java.util.ArrayList;

/**
 * This service should be injected and provides the capability of generating graphical model
 * for a mapping.
 */
public interface MappingService extends WeaveService {
    /**
     * Given a URI of a DataWeave mapping document it creates a mapping editor for it that
     * enables retrieval and interaction with the Expression model.
     *
     * The mapping editor returned does not keep track of script changes, the model is generated
     * once.
     *
     * Script changes need to be tracked from outside and a new open has to be called to generate
     * an updated model.
     *
     * @param uri URI of the document that contains the DW mapping
     * @param inputBindings list of names of the inputs for the mapping
     * @return returns a MappingEditor with methods for interacting with the Expression model of the mapping
     * @throws Exception if document cannot be opened from URI
     */
    MappingEditor open(String uri, ArrayList<String> inputBindings) throws Exception;
}