package org.mule.weave.lsp.actions

import org.eclipse.lsp4j.CodeAction
import org.eclipse.lsp4j.CodeActionParams
import org.mule.weave.extension.api.extension.action.WeaveCodeActionProvider
import org.mule.weave.extension.api.metadata.ContextMetadata
import org.mule.weave.lsp.commands.InsertDocumentationCommand
import org.mule.weave.lsp.services.DataWeaveToolingService
import org.mule.weave.v2.parser.ast.AstNode
import org.mule.weave.v2.parser.ast.header.directives.FunctionDirectiveNode
import org.mule.weave.v2.parser.ast.variables.NameIdentifier

import java.util.Optional.ofNullable

class InsertDocumentationAction(toolingService: DataWeaveToolingService) extends WeaveCodeActionProvider {
  
  override def handles(params: CodeActionParams, context: ContextMetadata): Boolean = {
    val documentToolingService = toolingService.openDocument(params.getTextDocument.getUri, ofNullable(context))
    val maybeFunctionNode: Option[AstNode] = documentToolingService.nodeAt(params.getRange.getStart.getLine, params.getRange.getStart.getCharacter, Some(classOf[FunctionDirectiveNode])).map(_.astNode)
    val cursorOnNameIdentifier: Option[AstNode] = documentToolingService.nodeAt(params.getRange.getStart.getLine, params.getRange.getStart.getCharacter, Some(classOf[NameIdentifier])).map(_.astNode)
    //We only allow this action to be available on a function directive name
    maybeFunctionNode.exists(_.isInstanceOf[FunctionDirectiveNode]) &&
      cursorOnNameIdentifier.contains(maybeFunctionNode.get.asInstanceOf[FunctionDirectiveNode].nameIdentifier) &&
      maybeFunctionNode.exists(astNode => !astNode.hasWeaveDoc)
  }

  override def actions(params: CodeActionParams, context: ContextMetadata): Array[CodeAction] = {
    val documentToolingService = toolingService.openDocument(params.getTextDocument.getUri, ofNullable(context))
    val maybeNode = documentToolingService.nodeAt(params.getRange.getStart.getLine, params.getRange.getStart.getCharacter, Some(classOf[FunctionDirectiveNode])).map(_.astNode)
    val codeAction = new CodeAction(InsertDocumentationCommand.LABEL)
    val astNode = maybeNode.get
    codeAction.setCommand(InsertDocumentationCommand.createCommand(params.getTextDocument.getUri, astNode))
    Array(codeAction)
  }
}
