package org.mule.weave.lsp.project.events

import org.mule.weave.extension.api.component.dependency.DependencyArtifact
import org.mule.weave.lsp.utils.InternalEvent
import org.mule.weave.lsp.utils.InternalEventHandler
import org.mule.weave.lsp.utils.InternalEventType

class DependencyArtifactResolvedEvent(artifacts: Array[DependencyArtifact]) extends InternalEvent {

  override type T = OnDependencyArtifactResolved

  override def getType: InternalEventType[OnDependencyArtifactResolved] = {
    DependencyArtifactResolvedEvent.ARTIFACT_RESOLVED
  }

  override def dispatch(handler: OnDependencyArtifactResolved): Unit = {
    handler.onArtifactsResolved(artifacts)
  }
}

trait OnDependencyArtifactResolved extends InternalEventHandler {
  def onArtifactsResolved(artifacts: Array[DependencyArtifact]): Unit
}


object DependencyArtifactResolvedEvent {
  val ARTIFACT_RESOLVED = InternalEventType[OnDependencyArtifactResolved]("ARTIFACT_RESOLVED")
}
