package org.mule.weave.lsp.project.events

import org.mule.weave.extension.api.project.ProjectMetadata
import org.mule.weave.lsp.utils.InternalEvent
import org.mule.weave.lsp.utils.InternalEventHandler
import org.mule.weave.lsp.utils.InternalEventType

class ProjectStartedEvent(projectMetadata: ProjectMetadata) extends InternalEvent {

  override type T = OnProjectStarted

  override def getType: InternalEventType[OnProjectStarted] = {
    ProjectStartedEvent.PROJECT_STARTED
  }

  override def dispatch(handler: OnProjectStarted): Unit = {
    handler.onProjectStarted(projectMetadata)
  }
}

trait OnProjectStarted extends InternalEventHandler {
  def onProjectStarted(projectMetadata: ProjectMetadata): Unit
}


object ProjectStartedEvent {
  val PROJECT_STARTED: InternalEventType[OnProjectStarted] = InternalEventType[OnProjectStarted]("PROJECT_STARTED")
}
