package org.mule.weave.lsp.services

import org.eclipse.lsp4j.ConfigurationParams
import org.eclipse.lsp4j.MessageActionItem
import org.eclipse.lsp4j.WorkspaceFolder
import org.eclipse.lsp4j.services.LanguageClient
import org.mule.dx.platform.api.protocol.ClientAware
import org.mule.weave.lsp.extension.protocol.DataWeaveProtocolClient
import org.mule.weave.lsp.extension.protocol.LaunchConfiguration

import java.util
import java.util.concurrent.CompletableFuture

/**
 * Handles everything that is releated to configuration
 */
class ConfigurationService(dataWeaveProtocolClient: DataWeaveProtocolClient) extends ClientAware[LanguageClient] {
  private var languageClient: LanguageClient = _

  def workspaceFolders(): CompletableFuture[util.List[WorkspaceFolder]] = {
    if (languageClient == null) {
      return CompletableFuture.completedFuture(new util.ArrayList[WorkspaceFolder]())
    }
    languageClient.workspaceFolders()
  }

  def configuration(configurationParams: ConfigurationParams): CompletableFuture[util.List[AnyRef]] = {
    if (languageClient == null) {
      return CompletableFuture.completedFuture(new util.ArrayList[AnyRef]())
    }
    languageClient.configuration(configurationParams)
  }

  def runConfiguration(config: LaunchConfiguration): Unit = {
    dataWeaveProtocolClient.runConfiguration(config)
  }

  override def connect(client: LanguageClient): Unit = languageClient = client
}
