package org.mule.weave.lsp.services.events

import org.mule.weave.lsp.services.events.DocumentSavedEvent.DOCUMENT_SAVED
import org.mule.weave.lsp.utils.InternalEvent
import org.mule.weave.lsp.utils.InternalEventHandler
import org.mule.weave.lsp.utils.InternalEventType
import org.mule.weave.v2.editor.VirtualFile

class DocumentSavedEvent(vf: VirtualFile) extends InternalEvent {
  override type T = OnDocumentSaved

  override def getType: InternalEventType[OnDocumentSaved] = DOCUMENT_SAVED

  override def dispatch(handler: OnDocumentSaved): Unit = {
    handler.onDocumentSaved(vf)
  }
}

trait OnDocumentSaved extends InternalEventHandler {
  def onDocumentSaved(vf: VirtualFile): Unit
}

object DocumentSavedEvent {
  val DOCUMENT_SAVED = InternalEventType[OnDocumentSaved]("DOCUMENT_SAVED")
}