package org.mule.weave.lsp.utils

import org.mule.weave.extension.api.metadata.InputMetadata
import org.mule.weave.v2.editor.ImplicitInput
import org.mule.weave.v2.ts.KeyValuePairType
import org.mule.weave.v2.ts.ObjectType
import org.mule.weave.v2.ts.WeaveType

import javax.annotation.Nullable
import scala.collection.mutable.ArrayBuffer

object WeaveTypeUtils {
  /**
   * @param type1 only keys present here will be used
   * @param type2 the values of these entries will override the ones from type1
   */
  def mergeObjectTypes(type1: WeaveType, type2: WeaveType): WeaveType = {
    if (!(type1.isInstanceOf[ObjectType] && type2.isInstanceOf[ObjectType])) {
      return type1
    }
    val object1 = type1.asInstanceOf[ObjectType]
    val object2 = type2.asInstanceOf[ObjectType]
    val mapFromObject2 = object2.properties.map(x => x.key -> x.value).toMap
    val mergedKvp = new ArrayBuffer[KeyValuePairType]()
    object1.properties.map(kvp => {
      val valueFromObject2 = mapFromObject2.get(kvp.key)
      if (valueFromObject2.isDefined) {
        mergedKvp += KeyValuePairType(kvp.key, valueFromObject2.get)
      } else {
        mergedKvp += kvp
      }
    })
    ObjectType(mergedKvp, object1.close)
  }

  def toImplicitInput(@Nullable inputMetadata: InputMetadata): ImplicitInput = {
    var bindings: Map[String, WeaveType] = Map.empty
    if (inputMetadata != null) {
      inputMetadata.getInputs.entrySet().stream().forEach(entry => {
        if (!entry.getValue.isInstanceOf[WeaveType]) {
          throw new IllegalArgumentException(s"Unexpected `inputMetadata` instance at key `${entry.getKey}`, please, contact the extension owner. Actual: ${entry.getValue.getClass.getName}")
        }
        bindings = bindings + (entry.getKey -> entry.getValue.asInstanceOf[WeaveType])
      })
    }
    ImplicitInput(bindings)
  }
}
