package org.mule.weave.lsp.vfs.events

import org.mule.weave.lsp.utils.InternalEvent
import org.mule.weave.lsp.utils.InternalEventHandler
import org.mule.weave.lsp.utils.InternalEventType
import org.mule.weave.lsp.vfs.ArtifactVirtualFileSystem
import org.mule.weave.lsp.vfs.events.LibrariesAddedEvent.LIBRARIES_ADDED

class LibrariesAddedEvent(libraries: Array[ArtifactVirtualFileSystem]) extends InternalEvent {
  override type T = OnLibrariesAdded

  override def getType: InternalEventType[OnLibrariesAdded] = {
    LIBRARIES_ADDED
  }

  override def dispatch(handler: OnLibrariesAdded): Unit = {
    handler.onLibrariesAdded(libraries)
  }
}

object LibrariesAddedEvent {
  val LIBRARIES_ADDED: InternalEventType[OnLibrariesAdded] = InternalEventType[OnLibrariesAdded]("LIBRARY_ADDED")
}

trait OnLibrariesAdded extends InternalEventHandler {
  def onLibrariesAdded(vfs: Array[ArtifactVirtualFileSystem])
}
