package org.mule.weave.lsp.vfs.events

import org.mule.weave.lsp.utils.InternalEvent
import org.mule.weave.lsp.utils.InternalEventHandler
import org.mule.weave.lsp.utils.InternalEventType
import org.mule.weave.lsp.vfs.events.ProjectVirtualFileCreatedEvent.VIRTUAL_FILE_CREATED
import org.mule.weave.v2.editor.VirtualFile

class ProjectVirtualFileCreatedEvent(vf: VirtualFile) extends InternalEvent {

  override type T = OnProjectVirtualFileCreatedEvent
  
  override def getType: InternalEventType[OnProjectVirtualFileCreatedEvent] = VIRTUAL_FILE_CREATED

  override def dispatch(handler: OnProjectVirtualFileCreatedEvent): Unit = {
    handler.onVirtualFileCreated(vf)
  }
}


object ProjectVirtualFileCreatedEvent {
  val VIRTUAL_FILE_CREATED: InternalEventType[OnProjectVirtualFileCreatedEvent] = InternalEventType[OnProjectVirtualFileCreatedEvent]("VIRTUAL_FILE_CREATED")
}

trait OnProjectVirtualFileCreatedEvent extends InternalEventHandler {
  def onVirtualFileCreated(vf: VirtualFile)
}