/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.lsp.agent;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.apache.commons.io.FilenameUtils;
import org.mule.weave.lsp.agent.AgentClasspathResolver;
import org.mule.weave.lsp.agent.FolderBasedAgentClasspathResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001da\u0001\u0002\n\u0014\u0001yAQ!\u000b\u0001\u0005\u0002)Bq\u0001\f\u0001C\u0002\u0013%Q\u0006\u0003\u00045\u0001\u0001\u0006IA\f\u0005\bk\u0001\u0011\r\u0011\"\u00037\u0011\u0019y\u0004\u0001)A\u0005o!9\u0001\t\u0001b\u0001\n\u0013\t\u0005B\u0002%\u0001A\u0003%!\tC\u0004J\u0001\t\u0007I\u0011B!\t\r)\u0003\u0001\u0015!\u0003C\u0011\u001dY\u0005A1A\u0005\n1Ca!\u0018\u0001!\u0002\u0013i\u0005b\u00020\u0001\u0005\u0004%I!\u0011\u0005\u0007?\u0002\u0001\u000b\u0011\u0002\"\t\u0011\u0001\u0004\u0001R1A\u0005\u0002\u0005DQ!\u001a\u0001\u0005\n\u0019DQ\u0001\u001b\u0001\u0005\n%DQ!\u001f\u0001\u0005Bi\u00141EU3t_V\u00148-\u001a\"bg\u0016$\u0017iZ3oi\u000ec\u0017m]:qCRD'+Z:pYZ,'O\u0003\u0002\u0015+\u0005)\u0011mZ3oi*\u0011acF\u0001\u0004YN\u0004(B\u0001\r\u001a\u0003\u00159X-\u0019<f\u0015\tQ2$\u0001\u0003nk2,'\"\u0001\u000f\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001yR\u0005\u0005\u0002!G5\t\u0011EC\u0001#\u0003\u0015\u00198-\u00197b\u0013\t!\u0013E\u0001\u0004B]f\u0014VM\u001a\t\u0003M\u001dj\u0011aE\u0005\u0003QM\u0011a#Q4f]R\u001cE.Y:ta\u0006$\bNU3t_24XM]\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003-\u0002\"A\n\u0001\u0002\r1|wmZ3s+\u0005q\u0003CA\u00183\u001b\u0005\u0001$BA\u0019\u001c\u0003\u0015\u0019HN\u001a\u001bk\u0013\t\u0019\u0004G\u0001\u0004M_\u001e<WM]\u0001\bY><w-\u001a:!\u0003\u001d!V\nU0E\u0013J+\u0012a\u000e\t\u0003quj\u0011!\u000f\u0006\u0003um\n!![8\u000b\u0003q\nAA[1wC&\u0011a(\u000f\u0002\u0005\r&dW-\u0001\u0005U\u001bB{F)\u0013*!\u00031\tu)\u0012(U?\u001a{E\nR#S+\u0005\u0011\u0005CA\"G\u001b\u0005!%BA#<\u0003\u0011a\u0017M\\4\n\u0005\u001d#%AB*ue&tw-A\u0007B\u000f\u0016sEk\u0018$P\u0019\u0012+%\u000bI\u0001\u0013\t\u0016\u001bF+\u0013(B)&{ej\u0018$P\u0019\u0012+%+A\nE\u000bN#\u0016JT!U\u0013>suLR(M\t\u0016\u0013\u0006%A\u0005S\u000bN{UKU\"F'V\tQ\nE\u0002O#Nk\u0011a\u0014\u0006\u0003!\u0006\n!bY8mY\u0016\u001cG/[8o\u0013\t\u0011vJA\u0002TKF\u0004\"\u0001V.\u000f\u0005UK\u0006C\u0001,\"\u001b\u00059&B\u0001-\u001e\u0003\u0019a$o\\8u}%\u0011!,I\u0001\u0007!J,G-\u001a4\n\u0005\u001dc&B\u0001.\"\u0003)\u0011ViU(V%\u000e+5\u000bI\u0001\u000e\u0015\u0006\u0013v,\u0012-U\u000b:\u001b\u0016j\u0014(\u0002\u001d)\u000b%kX#Y)\u0016s5+S(OA\u0005iQ.Y=cKJ+7o\u001c7wKJ,\u0012A\u0019\t\u0004A\r,\u0013B\u00013\"\u0005\u0019y\u0005\u000f^5p]\u0006\u00192M]3bi\u0016d\u0015NY:ESJ,7\r^8ssR\tq\rE\u0002!G^\nqaY8qs*\u000b'\u000fF\u0002k[>\u0004\"\u0001I6\n\u00051\f#\u0001B+oSRDQA\u001c\tA\u0002M\u000b\u0001B]3t_V\u00148-\u001a\u0005\u0006aB\u0001\r!]\u0001\u0010i\u0006\u0014x-\u001a;ESJ,7\r^8ssB\u0011!o^\u0007\u0002g*\u0011A/^\u0001\u0005M&dWM\u0003\u0002ww\u0005\u0019a.[8\n\u0005a\u001c(\u0001\u0002)bi\"\fAC]3t_24Xm\u00117bgN\u0004\u0018\r\u001e5KCJ\u001cH#A>\u0011\tq\f\u0019a\u0015\b\u0003{~t!A\u0016@\n\u0003\tJ1!!\u0001\"\u0003\u001d\u0001\u0018mY6bO\u0016L1AUA\u0003\u0015\r\t\t!\t")
public class ResourceBasedAgentClasspathResolver
implements AgentClasspathResolver {
    private Option<AgentClasspathResolver> maybeResolver;
    private final Logger logger = LoggerFactory.getLogger(ResourceBasedAgentClasspathResolver.class);
    private final File TMP_DIR = new File(System.getProperty("java.io.tmpdir"));
    private final String AGENT_FOLDER;
    private final String DESTINATION_FOLDER;
    private final Seq<String> RESOURCES = (Seq)new .colon.colon((Object)new StringBuilder(17).append(this.AGENT_FOLDER()).append("/agent-server.zip").toString(), (List)new .colon.colon((Object)new StringBuilder(14).append(this.AGENT_FOLDER()).append("/agent-api.zip").toString(), (List)Nil$.MODULE$));
    private final String JAR_EXTENSION;
    private volatile boolean bitmap$0;

    private Logger logger() {
        return this.logger;
    }

    private File TMP_DIR() {
        return this.TMP_DIR;
    }

    private String AGENT_FOLDER() {
        return this.AGENT_FOLDER;
    }

    private String DESTINATION_FOLDER() {
        return this.DESTINATION_FOLDER;
    }

    private Seq<String> RESOURCES() {
        return this.RESOURCES;
    }

    private String JAR_EXTENSION() {
        return this.JAR_EXTENSION;
    }

    private Option<AgentClasspathResolver> maybeResolver$lzycompute() {
        ResourceBasedAgentClasspathResolver resourceBasedAgentClasspathResolver = this;
        synchronized (resourceBasedAgentClasspathResolver) {
            if (!this.bitmap$0) {
                Option<File> maybeLibsDirectory = this.createLibsDirectory();
                this.maybeResolver = maybeLibsDirectory.map((Function1 & Serializable & scala.Serializable)dir -> new FolderBasedAgentClasspathResolver((File)dir));
                this.bitmap$0 = true;
            }
        }
        return this.maybeResolver;
    }

    public Option<AgentClasspathResolver> maybeResolver() {
        if (!this.bitmap$0) {
            return this.maybeResolver$lzycompute();
        }
        return this.maybeResolver;
    }

    private Option<File> createLibsDirectory() {
        URL url = this.getClass().getClassLoader().getResource(this.AGENT_FOLDER());
        if (url != null) {
            if (!this.TMP_DIR().exists()) {
                throw new RuntimeException(new StringBuilder(106).append("The specified temporary ").append(this.TMP_DIR().getAbsolutePath()).append(" directory does not exits. Please create the directory or provide a different one.").toString());
            }
            Path targetDirectory = Files.createTempDirectory(this.DESTINATION_FOLDER(), new FileAttribute[0]);
            this.RESOURCES().foreach((Function1 & Serializable & scala.Serializable)resource -> {
                this.copyJar(resource, targetDirectory);
                return BoxedUnit.UNIT;
            });
            return new Some((Object)targetDirectory.toFile());
        }
        return None$.MODULE$;
    }

    private void copyJar(String resource, Path targetDirectory) {
        InputStream is = this.getClass().getClassLoader().getResourceAsStream(resource);
        if (is != null) {
            try {
                String baseName = FilenameUtils.getBaseName((String)resource);
                File destination = targetDirectory.resolve(new StringBuilder(0).append(baseName).append(this.JAR_EXTENSION()).toString()).toFile();
                destination.createNewFile();
                destination.deleteOnExit();
                try (FileOutputStream out = new FileOutputStream(destination);){
                    byte[] buffer = new byte[1024];
                    package$.MODULE$.Stream().continually((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> is.read(buffer)).takeWhile((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$1 -> x$1 != -1).foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$2 -> out.write(buffer, 0, x$2));
                }
            }
            finally {
                is.close();
            }
            return;
        }
    }

    @Override
    public Seq<String> resolveClasspathJars() {
        Seq<String> jars;
        block0: {
            Seq<String> seq = jars = this.maybeResolver().isDefined() ? ((AgentClasspathResolver)this.maybeResolver().get()).resolveClasspathJars() : (Seq<String>)Nil$.MODULE$;
            if (!jars.isEmpty()) break block0;
            this.logger().error("Could not resolve agent classpath jars");
        }
        return jars;
    }

    public ResourceBasedAgentClasspathResolver() {
        this.AGENT_FOLDER = "agent-server-libs";
        this.DESTINATION_FOLDER = "data-weave-agent";
        this.JAR_EXTENSION = ".jar";
    }
}

