/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.lsp.services;

import java.io.File;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.CodeActionParams;
import org.eclipse.lsp4j.CodeLens;
import org.eclipse.lsp4j.CodeLensParams;
import org.eclipse.lsp4j.Command;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.CompletionItemKind;
import org.eclipse.lsp4j.CompletionList;
import org.eclipse.lsp4j.CompletionParams;
import org.eclipse.lsp4j.DefinitionParams;
import org.eclipse.lsp4j.DidChangeTextDocumentParams;
import org.eclipse.lsp4j.DidCloseTextDocumentParams;
import org.eclipse.lsp4j.DidOpenTextDocumentParams;
import org.eclipse.lsp4j.DidSaveTextDocumentParams;
import org.eclipse.lsp4j.DocumentFormattingParams;
import org.eclipse.lsp4j.DocumentRangeFormattingParams;
import org.eclipse.lsp4j.DocumentSymbol;
import org.eclipse.lsp4j.DocumentSymbolParams;
import org.eclipse.lsp4j.FoldingRange;
import org.eclipse.lsp4j.FoldingRangeRequestParams;
import org.eclipse.lsp4j.Hover;
import org.eclipse.lsp4j.HoverParams;
import org.eclipse.lsp4j.InsertTextFormat;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.LocationLink;
import org.eclipse.lsp4j.MarkupContent;
import org.eclipse.lsp4j.ParameterInformation;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.ReferenceParams;
import org.eclipse.lsp4j.RenameParams;
import org.eclipse.lsp4j.SignatureHelp;
import org.eclipse.lsp4j.SignatureHelpParams;
import org.eclipse.lsp4j.SignatureInformation;
import org.eclipse.lsp4j.SymbolKind;
import org.eclipse.lsp4j.TextDocumentContentChangeEvent;
import org.eclipse.lsp4j.TextDocumentIdentifier;
import org.eclipse.lsp4j.TextDocumentItem;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4j.VersionedTextDocumentIdentifier;
import org.eclipse.lsp4j.WorkspaceEdit;
import org.eclipse.lsp4j.jsonrpc.ResponseErrorException;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.lsp4j.jsonrpc.messages.ResponseError;
import org.eclipse.lsp4j.jsonrpc.messages.ResponseErrorCode;
import org.mule.weave.extension.api.WeaveLanguageServerBuilder;
import org.mule.weave.extension.api.filesystem.VirtualFile;
import org.mule.weave.lsp.actions.CodeActionsManagerService;
import org.mule.weave.lsp.commands.Commands$;
import org.mule.weave.lsp.commands.CreateUnitTest$;
import org.mule.weave.lsp.commands.InsertDocumentationCommand$;
import org.mule.weave.lsp.commands.LSPWeaveTextDocument;
import org.mule.weave.lsp.extension.protocol.LaunchConfiguration$;
import org.mule.weave.lsp.extension.protocol.SampleInput;
import org.mule.weave.lsp.extension.services.DidFocusChangeParams;
import org.mule.weave.lsp.extension.services.WeaveTextDocumentService;
import org.mule.weave.lsp.i18n.UserMessages$;
import org.mule.weave.lsp.project.ProjectKind;
import org.mule.weave.lsp.project.components.ProjectStructureHelper$;
import org.mule.weave.lsp.project.components.Scenario;
import org.mule.weave.lsp.project.components.Scenario$;
import org.mule.weave.lsp.services.DataWeaveToolingService;
import org.mule.weave.lsp.services.TextDocumentTranslatorService;
import org.mule.weave.lsp.services.WeaveScenarioManagerService;
import org.mule.weave.lsp.services.events.DocumentChangedEvent;
import org.mule.weave.lsp.services.events.DocumentClosedEvent;
import org.mule.weave.lsp.services.events.DocumentFocusChangedEvent;
import org.mule.weave.lsp.services.events.DocumentOpenedEvent;
import org.mule.weave.lsp.services.events.DocumentSavedEvent;
import org.mule.weave.lsp.utils.LSPConverters$;
import org.mule.weave.lsp.utils.URLUtils$;
import org.mule.weave.lsp.utils.WeaveASTQueryUtils$;
import org.mule.weave.lsp.vfs.ProjectFileSystemService;
import org.mule.weave.lsp.vfs.VirtualFileAdapter$;
import org.mule.weave.v2.completion.Suggestion;
import org.mule.weave.v2.completion.SuggestionResult;
import org.mule.weave.v2.completion.SuggestionType$;
import org.mule.weave.v2.editor.AstNodeResult;
import org.mule.weave.v2.editor.Link;
import org.mule.weave.v2.editor.RegionKind$;
import org.mule.weave.v2.editor.SymbolInformation;
import org.mule.weave.v2.editor.SymbolKind$;
import org.mule.weave.v2.editor.VirtualFileSystem;
import org.mule.weave.v2.editor.WeaveDocumentToolingService;
import org.mule.weave.v2.editor.WeaveTextDocument;
import org.mule.weave.v2.formatting.FormattingOptions;
import org.mule.weave.v2.parser.ast.AstNode;
import org.mule.weave.v2.parser.ast.AstNodeHelper$;
import org.mule.weave.v2.parser.ast.functions.OverloadedFunctionNode;
import org.mule.weave.v2.parser.ast.header.directives.FunctionDirectiveNode;
import org.mule.weave.v2.parser.ast.header.directives.InputDirective;
import org.mule.weave.v2.parser.ast.module.ModuleNode;
import org.mule.weave.v2.parser.ast.structure.DocumentNode;
import org.mule.weave.v2.parser.ast.variables.NameIdentifier;
import org.mule.weave.v2.parser.ast.variables.NameIdentifier$;
import org.mule.weave.v2.scope.Reference;
import org.mule.weave.v2.sdk.WeaveResourceResolver;
import org.mule.weave.v2.signature.FunctionSignatureResult;
import org.mule.weave.v2.utils.WeaveTypeEmitterConfig;
import org.mule.weave.v2.utils.WeaveTypeEmitterConfig$;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;

@ScalaSignature(bytes="\u0006\u0001\u0011}b\u0001B\u00193\u0001uB\u0001\"\u0014\u0001\u0003\u0002\u0003\u0006IA\u0014\u0005\t)\u0002\u0011\t\u0011)A\u0005+\")Q\f\u0001C\u0001=\"91\r\u0001b\u0001\n\u0013!\u0007BB6\u0001A\u0003%Q\rC\u0004m\u0001\t\u0007I\u0011B7\t\rE\u0004\u0001\u0015!\u0003o\u0011\u001d\u0011\bA1A\u0005\nMDaA\u001f\u0001!\u0002\u0013!\bbB>\u0001\u0005\u0004%I\u0001 \u0005\b\u0003\u0003\u0001\u0001\u0015!\u0003~\u0011!9\bA1A\u0005\n\u0005\r\u0001\u0002CA\u000b\u0001\u0001\u0006I!!\u0002\t\u0013\u0005]\u0001A1A\u0005\n\u0005e\u0001\u0002CA\u0014\u0001\u0001\u0006I!a\u0007\t\u0013\u0005%\u0002A1A\u0005\n\u0005-\u0002\u0002CA.\u0001\u0001\u0006I!!\f\t\u000f\u0005u\u0003\u0001\"\u0011\u0002`!9\u0011\u0011\u0011\u0001\u0005B\u0005\r\u0005bBAH\u0001\u0011\u0005\u0013\u0011\u0013\u0005\b\u00037\u0003A\u0011IAO\u0011\u001d\t9\u000b\u0001C!\u0003SCq!a-\u0001\t\u0003\n)\fC\u0004\u0002l\u0002!I!!<\t\u000f\u0005m\b\u0001\"\u0011\u0002~\"9!q\u0002\u0001\u0005\n\tE\u0001b\u0002B%\u0001\u0011%!1\n\u0005\b\u0005[\u0002A\u0011\tB8\u0011\u001d\u0011y\t\u0001C\u0005\u0005#CqA!4\u0001\t\u0013\u0011y\rC\u0004\u0003X\u0002!IA!7\t\u000f\tu\u0007\u0001\"\u0003\u0003`\"9!\u0011\u001e\u0001\u0005\n\t-\bb\u0002By\u0001\u0011%!1\u001f\u0005\b\u0005s\u0004A\u0011\tB~\u0011\u001d\u0019\u0019\u0001\u0001C!\u0007\u000bAqa!\u0007\u0001\t\u0003\u001aY\u0002C\u0004\u00048\u0001!\te!\u000f\t\u000f\r}\u0002\u0001\"\u0011\u0004B!911\u000b\u0001\u0005\u0002\rU\u0003bBB4\u0001\u0011\u00053\u0011\u000e\u0005\b\u0007\u000b\u0003A\u0011IBD\u0011\u001d\u0019I\f\u0001C\u0005\u0007wCqaa1\u0001\t\u0003\u001a)\rC\u0004\u0004d\u0002!\te!:\t\u000f\rm\b\u0001\"\u0011\u0004~\"9Aq\u0002\u0001\u0005B\u0011E\u0001b\u0002C\u0014\u0001\u0011%A\u0011\u0006\u0002\u0019\t\u0006$\u0018mV3bm\u0016$unY;nK:$8+\u001a:wS\u000e,'BA\u001a5\u0003!\u0019XM\u001d<jG\u0016\u001c(BA\u001b7\u0003\ra7\u000f\u001d\u0006\u0003oa\nQa^3bm\u0016T!!\u000f\u001e\u0002\t5,H.\u001a\u0006\u0002w\u0005\u0019qN]4\u0004\u0001M\u0019\u0001A\u0010$\u0011\u0005}\"U\"\u0001!\u000b\u0005\u0005\u0013\u0015\u0001\u00027b]\u001eT\u0011aQ\u0001\u0005U\u00064\u0018-\u0003\u0002F\u0001\n1qJ\u00196fGR\u0004\"aR&\u000e\u0003!S!aM%\u000b\u0005)#\u0014!C3yi\u0016t7/[8o\u0013\ta\u0005J\u0001\rXK\u00064X\rV3yi\u0012{7-^7f]R\u001cVM\u001d<jG\u0016\f1\u0002\u001d:pU\u0016\u001cGoS5oIB\u0011qJU\u0007\u0002!*\u0011\u0011\u000bN\u0001\baJ|'.Z2u\u0013\t\u0019\u0006KA\u0006Qe>TWm\u0019;LS:$\u0017\u0001C3yK\u000e,Ho\u001c:\u0011\u0005Y[V\"A,\u000b\u0005aK\u0016AC2p]\u000e,(O]3oi*\u0011!LQ\u0001\u0005kRLG.\u0003\u0002]/\nAQ\t_3dkR|'/\u0001\u0004=S:LGO\u0010\u000b\u0004?\u0006\u0014\u0007C\u00011\u0001\u001b\u0005\u0011\u0004\"B'\u0004\u0001\u0004q\u0005\"\u0002+\u0004\u0001\u0004)\u0016A\u00027pO\u001e,'/F\u0001f!\t1\u0017.D\u0001h\u0015\tA'(A\u0003tY\u001a$$.\u0003\u0002kO\n1Aj\\4hKJ\fq\u0001\\8hO\u0016\u0014\b%A\bu_>d\u0017N\\4TKJ4\u0018nY3t+\u0005q\u0007C\u00011p\u0013\t\u0001(GA\fECR\fw+Z1wKR{w\u000e\\5oON+'O^5dK\u0006\u0001Bo\\8mS:<7+\u001a:wS\u000e,7\u000fI\u0001\naJ|'.Z2u\rN+\u0012\u0001\u001e\t\u0003kbl\u0011A\u001e\u0006\u0003oR\n1A\u001e4t\u0013\tIhO\u0001\rQe>TWm\u0019;GS2,7+_:uK6\u001cVM\u001d<jG\u0016\f!\u0002\u001d:pU\u0016\u001cGOR*!\u0003A\u00198-\u001a8be&|7oU3sm&\u001cW-F\u0001~!\t\u0001g0\u0003\u0002\u0000e\tYr+Z1wKN\u001bWM\\1sS>l\u0015M\\1hKJ\u001cVM\u001d<jG\u0016\f\u0011c]2f]\u0006\u0014\u0018n\\:TKJ4\u0018nY3!+\t\t)\u0001\u0005\u0003\u0002\b\u0005EQBAA\u0005\u0015\u0011\tY!!\u0004\u0002\r\u0015$\u0017\u000e^8s\u0015\r\tyAN\u0001\u0003mJJA!a\u0005\u0002\n\t\tb+\u001b:uk\u0006dg)\u001b7f'f\u001cH/Z7\u0002\tY47\u000fI\u0001\u001aG>$W-Q2uS>t7/T1oC\u001e,'oU3sm&\u001cW-\u0006\u0002\u0002\u001cA!\u0011QDA\u0012\u001b\t\tyBC\u0002\u0002\"Q\nq!Y2uS>t7/\u0003\u0003\u0002&\u0005}!!G\"pI\u0016\f5\r^5p]Nl\u0015M\\1hKJ\u001cVM\u001d<jG\u0016\f!dY8eK\u0006\u001bG/[8og6\u000bg.Y4feN+'O^5dK\u0002\na\u0003^3yi\u0012{7-^7f]R$&/\u00198tY\u0006$xN]\u000b\u0003\u0003[\u0001B!a\f\u0002V9!\u0011\u0011GA(\u001d\u0011\t\u0019$!\u0013\u000f\t\u0005U\u0012q\t\b\u0005\u0003o\t)E\u0004\u0003\u0002:\u0005\rc\u0002BA\u001e\u0003\u0003j!!!\u0010\u000b\u0007\u0005}B(\u0001\u0004=e>|GOP\u0005\u0002w%\u0011\u0011HO\u0005\u0003oaJ!A\u0013\u001c\n\t\u0005-\u0013QJ\u0001\u0004CBL'B\u0001&7\u0013\u0011\t\t&a\u0015\u00025]+\u0017M^3MC:<W/Y4f'\u0016\u0014h/\u001a:Ck&dG-\u001a:\u000b\t\u0005-\u0013QJ\u0005\u0005\u0003/\nIF\u0001\fUKb$Hi\\2v[\u0016tG\u000f\u0016:b]Nd\u0017\r^8s\u0015\u0011\t\t&a\u0015\u0002/Q,\u0007\u0010\u001e#pGVlWM\u001c;Ue\u0006t7\u000f\\1u_J\u0004\u0013a\u00023jI>\u0003XM\u001c\u000b\u0005\u0003C\ni\u0007\u0005\u0003\u0002d\u0005%TBAA3\u0015\t\t9'A\u0003tG\u0006d\u0017-\u0003\u0003\u0002l\u0005\u0015$\u0001B+oSRDq!a\u001c\u0013\u0001\u0004\t\t(A\u0005pa\u0016t\u0007+\u0019:b[B!\u00111OA?\u001b\t\t)H\u0003\u0003\u0002x\u0005e\u0014!\u00027taRR'bAA>u\u00059Qm\u00197jaN,\u0017\u0002BA@\u0003k\u0012\u0011\u0004R5e\u001fB,g\u000eV3yi\u0012{7-^7f]R\u0004\u0016M]1ng\u0006IA-\u001b3DQ\u0006tw-\u001a\u000b\u0005\u0003C\n)\tC\u0004\u0002\bN\u0001\r!!#\u0002\rA\f'/Y7t!\u0011\t\u0019(a#\n\t\u00055\u0015Q\u000f\u0002\u001c\t&$7\t[1oO\u0016$V\r\u001f;E_\u000e,X.\u001a8u!\u0006\u0014\u0018-\\:\u0002\u0011\u0011LGm\u00117pg\u0016$B!!\u0019\u0002\u0014\"9\u0011q\u0011\u000bA\u0002\u0005U\u0005\u0003BA:\u0003/KA!!'\u0002v\tQB)\u001b3DY>\u001cX\rV3yi\u0012{7-^7f]R\u0004\u0016M]1ng\u00069A-\u001b3TCZ,G\u0003BA1\u0003?Cq!a\"\u0016\u0001\u0004\t\t\u000b\u0005\u0003\u0002t\u0005\r\u0016\u0002BAS\u0003k\u0012\u0011\u0004R5e'\u00064X\rV3yi\u0012{7-^7f]R\u0004\u0016M]1ng\u0006qA-\u001b3G_\u000e,8o\u00115b]\u001e,G\u0003BA1\u0003WCq!a\"\u0017\u0001\u0004\ti\u000bE\u0002H\u0003_K1!!-I\u0005Q!\u0015\u000e\u001a$pGV\u001c8\t[1oO\u0016\u0004\u0016M]1ng\u0006Q1m\\7qY\u0016$\u0018n\u001c8\u0015\t\u0005]\u0016\u0011\u001d\t\u0006-\u0006e\u0016QX\u0005\u0004\u0003w;&!E\"p[BdW\r^1cY\u00164U\u000f^;sKBA\u0011qXAe\u0003\u001b\fY.\u0004\u0002\u0002B*!\u00111YAc\u0003!iWm]:bO\u0016\u001c(\u0002BAd\u0003k\nqA[:p]J\u00048-\u0003\u0003\u0002L\u0006\u0005'AB#ji\",'\u000f\u0005\u0004\u0002P\u0006E\u0017Q[\u0007\u00023&\u0019\u00111[-\u0003\t1K7\u000f\u001e\t\u0005\u0003g\n9.\u0003\u0003\u0002Z\u0006U$AD\"p[BdW\r^5p]&#X-\u001c\t\u0005\u0003g\ni.\u0003\u0003\u0002`\u0006U$AD\"p[BdW\r^5p]2K7\u000f\u001e\u0005\b\u0003G<\u0002\u0019AAs\u0003!\u0001xn]5uS>t\u0007\u0003BA:\u0003OLA!!;\u0002v\t\u00012i\\7qY\u0016$\u0018n\u001c8QCJ\fWn]\u0001&O\u0016$8+^4hKN$\u0018n\u001c8t\u0003:$7I]3bi\u0016\u001cu.\u001c9mKRLwN\u001c'jgR$b!!0\u0002p\u0006e\bbBAy1\u0001\u0007\u00111_\u0001\u000fi>|G.\u001b8h'\u0016\u0014h/[2f!\u0011\t9!!>\n\t\u0005]\u0018\u0011\u0002\u0002\u001c/\u0016\fg/\u001a#pGVlWM\u001c;U_>d\u0017N\\4TKJ4\u0018nY3\t\u000f\u0005\r\b\u00041\u0001\u0002f\u0006i1/[4oCR,(/\u001a%fYB$B!a@\u0003\bA)a+!/\u0003\u0002A!\u00111\u000fB\u0002\u0013\u0011\u0011)!!\u001e\u0003\u001bMKwM\\1ukJ,\u0007*\u001a7q\u0011\u001d\t9)\u0007a\u0001\u0005\u0013\u0001B!a\u001d\u0003\f%!!QBA;\u0005M\u0019\u0016n\u001a8biV\u0014X\rS3maB\u000b'/Y7t\u0003I9W\r^%oaV$H)\u001b:fGRLg/Z:\u0015\t\tM!q\u0007\t\u0007\u0005+\u0011YBa\b\u000e\u0005\t]!\u0002\u0002B\r\u0003K\n!bY8mY\u0016\u001cG/[8o\u0013\u0011\u0011iBa\u0006\u0003\u0007M+\u0017\u000f\u0005\u0003\u0003\"\tMRB\u0001B\u0012\u0015\u0011\u0011)Ca\n\u0002\u0015\u0011L'/Z2uSZ,7O\u0003\u0003\u0003*\t-\u0012A\u00025fC\u0012,'O\u0003\u0003\u0003.\t=\u0012aA1ti*!!\u0011GA\u0007\u0003\u0019\u0001\u0018M]:fe&!!Q\u0007B\u0012\u00059Ie\u000e];u\t&\u0014Xm\u0019;jm\u0016DqA!\u000f\u001b\u0001\u0004\u0011Y$\u0001\u0007nCf\u0014W-Q:u\u001d>$W\r\u0005\u0004\u0002d\tu\"\u0011I\u0005\u0005\u0005\u007f\t)G\u0001\u0004PaRLwN\u001c\t\u0005\u0005\u0007\u0012)%\u0004\u0002\u0003,%!!q\tB\u0016\u0005\u001d\t5\u000f\u001e(pI\u0016\fQc\u0019:fCR,W*\u00199qS:<G+Z:u\u0019\u0016t7\u000f\u0006\u0003\u0003N\te\u0003CBAh\u0005\u001f\u0012\u0019&C\u0002\u0003Re\u0013\u0011\"\u0011:sCfd\u0015n\u001d;\u0011\t\u0005M$QK\u0005\u0005\u0005/\n)H\u0001\u0005D_\u0012,G*\u001a8t\u0011\u001d\u0011Yf\u0007a\u0001\u0005;\n1!\u001e:m!\u0011\u0011yFa\u001a\u000f\t\t\u0005$1\r\t\u0005\u0003w\t)'\u0003\u0003\u0003f\u0005\u0015\u0014A\u0002)sK\u0012,g-\u0003\u0003\u0003j\t-$AB*ue&twM\u0003\u0003\u0003f\u0005\u0015\u0014\u0001C2pI\u0016dUM\\:\u0015\t\tE$q\u0011\t\u0006-\u0006e&1\u000f\u0019\u0005\u0005k\u0012Y\b\u0005\u0004\u0002P\u0006E'q\u000f\t\u0005\u0005s\u0012Y\b\u0004\u0001\u0005\u0017\tuD$!A\u0001\u0002\u000b\u0005!q\u0010\u0002\u0004?\u0012\n\u0014\u0003\u0002BA\u0005'\u0002B!a\u0019\u0003\u0004&!!QQA3\u0005\u001dqu\u000e\u001e5j]\u001eDq!a\"\u001d\u0001\u0004\u0011I\t\u0005\u0003\u0002t\t-\u0015\u0002\u0002BG\u0003k\u0012abQ8eK2+gn\u001d)be\u0006l7/\u0001\ttC6\u0004H.\u001a#bi\u0006dUM\\:fgRQ!Q\nBJ\u0005K\u0013)L!3\t\u000f\tUU\u00041\u0001\u0003\u0018\u0006iQ.Y=cKN\u001bWM\\1sS>\u0004b!a\u0019\u0003>\te\u0005\u0003\u0002BN\u0005Ck!A!(\u000b\u0007\t}\u0005+\u0001\u0006d_6\u0004xN\\3oiNLAAa)\u0003\u001e\nA1kY3oCJLw\u000eC\u0004\u0003(v\u0001\rA!+\u0002\u001d9\fW.Z%eK:$\u0018NZ5feB!!1\u0016BY\u001b\t\u0011iK\u0003\u0003\u00030\n-\u0012!\u0003<be&\f'\r\\3t\u0013\u0011\u0011\u0019L!,\u0003\u001d9\u000bW.Z%eK:$\u0018NZ5fe\"9!qW\u000fA\u0002\te\u0016aD5oaV$H)\u001b:fGRLg/Z:\u0011\r\tm&Q\u0019B\u0010\u001d\u0011\u0011iL!1\u000f\t\u0005m\"qX\u0005\u0003\u0003OJAAa1\u0002f\u00059\u0001/Y2lC\u001e,\u0017\u0002\u0002B\u000f\u0005\u000fTAAa1\u0002f!9!1Z\u000fA\u0002\tu\u0013aA;sS\u0006iAm\\2Ti\u0006\u0014HOU1oO\u0016$\"A!5\u0011\t\u0005M$1[\u0005\u0005\u0005+\f)HA\u0003SC:<W-\u0001\bsk:l\u0015\r\u001d9j]\u001edUM\\:\u0015\t\tM#1\u001c\u0005\b\u0005O{\u0002\u0019\u0001BU\u00035Ig\u000e];u\r&dWMT1nKR!!\u0011\u001dBs!\ry$1]\u0005\u0004\u0005S\u0002\u0005b\u0002BtA\u0001\u0007!qD\u0001\u0003S\u0012\fa#\u00193e\t>\u001cW/\\3oi\u0006$\u0018n\u001c8MK:\u001cXm\u001d\u000b\u0007\u0005\u001b\u0012iOa<\t\u000f\t5\u0012\u00051\u0001\u0003B!9!1Z\u0011A\u0002\tu\u0013!E1eIVs\u0017\u000e\u001e+fgRdUM\\:fgR1!Q\nB{\u0005oDqA!\f#\u0001\u0004\u0011\t\u0005C\u0004\u0003L\n\u0002\rA!\u0018\u0002\u001fI,7o\u001c7wK\u000e{G-\u001a'f]N$BA!@\u0003\u0000B)a+!/\u0003T!91\u0011A\u0012A\u0002\tM\u0013AC;oe\u0016\u001cx\u000e\u001c<fI\u0006aam\u001c7eS:<'+\u00198hKR!1qAB\t!\u00151\u0016\u0011XB\u0005!\u0019\ty-!5\u0004\fA!\u00111OB\u0007\u0013\u0011\u0019y!!\u001e\u0003\u0019\u0019{G\u000eZ5oOJ\u000bgnZ3\t\u000f\u0005\u001dE\u00051\u0001\u0004\u0014A!\u00111OB\u000b\u0013\u0011\u00199\"!\u001e\u00033\u0019{G\u000eZ5oOJ\u000bgnZ3SKF,Xm\u001d;QCJ\fWn]\u0001\u000bG>$W-Q2uS>tG\u0003BB\u000f\u0007_\u0001RAVA]\u0007?\u0001b!a4\u0002R\u000e\u0005\u0002\u0003CA`\u0003\u0013\u001c\u0019c!\u000b\u0011\t\u0005M4QE\u0005\u0005\u0007O\t)HA\u0004D_6l\u0017M\u001c3\u0011\t\u0005M41F\u0005\u0005\u0007[\t)H\u0001\u0006D_\u0012,\u0017i\u0019;j_:Dq!a\"&\u0001\u0004\u0019\t\u0004\u0005\u0003\u0002t\rM\u0012\u0002BB\u001b\u0003k\u0012\u0001cQ8eK\u0006\u001bG/[8o!\u0006\u0014\u0018-\\:\u0002+I,7o\u001c7wK\u000e{W\u000e\u001d7fi&|g.\u0013;f[R!11HB\u001f!\u00151\u0016\u0011XAk\u0011\u001d\u0019\tA\na\u0001\u0003+\fQ\u0001[8wKJ$Baa\u0011\u0004LA)a+!/\u0004FA!\u00111OB$\u0013\u0011\u0019I%!\u001e\u0003\u000b!{g/\u001a:\t\u000f\u0005\u001du\u00051\u0001\u0004NA!\u00111OB(\u0013\u0011\u0019\t&!\u001e\u0003\u0017!{g/\u001a:QCJ\fWn]\u0001\ri>\u001c\u00160\u001c2pY.Kg\u000e\u001a\u000b\u0005\u0007/\u001ai\u0006\u0005\u0003\u0002t\re\u0013\u0002BB.\u0003k\u0012!bU=nE>d7*\u001b8e\u0011\u001d\u0019y\u0006\u000ba\u0001\u0007C\nAa[5oIB!\u00111MB2\u0013\u0011\u0019)'!\u001a\u0003\u0007%sG/\u0001\be_\u000e,X.\u001a8u'fl'm\u001c7\u0015\t\r-4Q\u0010\t\u0006-\u0006e6Q\u000e\t\u0007\u0003\u001f\f\tna\u001c\u0011\u0011\u0005}\u0016\u0011ZB9\u0007o\u0002B!a\u001d\u0004t%!1QOA;\u0005E\u0019\u00160\u001c2pY&sgm\u001c:nCRLwN\u001c\t\u0005\u0003g\u001aI(\u0003\u0003\u0004|\u0005U$A\u0004#pGVlWM\u001c;Ts6\u0014w\u000e\u001c\u0005\b\u0003\u000fK\u0003\u0019AB@!\u0011\t\u0019h!!\n\t\r\r\u0015Q\u000f\u0002\u0015\t>\u001cW/\\3oiNKXNY8m!\u0006\u0014\u0018-\\:\u0002\u0015\u0011,g-\u001b8ji&|g\u000e\u0006\u0003\u0004\n\u000eE\u0006#\u0002,\u0002:\u000e-\u0005\u0003CA`\u0003\u0013\u001ciia(1\t\r=51\u0013\t\u0007\u0003\u001f\f\tn!%\u0011\t\te41\u0013\u0003\f\u0007+S\u0013\u0011!A\u0001\u0006\u0003\u00199JA\u0002`II\nBA!!\u0004\u001aB!\u00111OBN\u0013\u0011\u0019i*!\u001e\u0003\u00111{7-\u0019;j_:\u0004Da!)\u0004&B1\u0011qZAi\u0007G\u0003BA!\u001f\u0004&\u0012Y1q\u0015\u0016\u0002\u0002\u0003\u0005)\u0011ABU\u0005\ryFeM\t\u0005\u0005\u0003\u001bY\u000b\u0005\u0003\u0002t\r5\u0016\u0002BBX\u0003k\u0012A\u0002T8dCRLwN\u001c'j].Dq!a\"+\u0001\u0004\u0019\u0019\f\u0005\u0003\u0002t\rU\u0016\u0002BB\\\u0003k\u0012\u0001\u0003R3gS:LG/[8o!\u0006\u0014\u0018-\\:\u0002\u0015I,7o\u001c7wKV\u0013H\u000e\u0006\u0003\u0004>\u000e}\u0006CBA2\u0005{\u0011i\u0006C\u0004\u0004B.\u0002\rA!+\u0002\u00155|G-\u001e7f\u001d\u0006lW-\u0001\u0006g_Jl\u0017\r\u001e;j]\u001e$Baa2\u0004\\B)a+!/\u0004JB\"11ZBh!\u0019\ty-!5\u0004NB!!\u0011PBh\t-\u0019\t\u000eLA\u0001\u0002\u0003\u0015\taa5\u0003\u0007}#C'\u0005\u0003\u0003\u0002\u000eU\u0007\u0003BA:\u0007/LAa!7\u0002v\tAA+\u001a=u\u000b\u0012LG\u000fC\u0004\u0002\b2\u0002\ra!8\u0011\t\u0005M4q\\\u0005\u0005\u0007C\f)H\u0001\rE_\u000e,X.\u001a8u\r>\u0014X.\u0019;uS:<\u0007+\u0019:b[N\fqB]1oO\u00164uN]7biRLgn\u001a\u000b\u0005\u0007O\u001c\u0019\u0010E\u0003W\u0003s\u001bI\u000f\r\u0003\u0004l\u000e=\bCBAh\u0003#\u001ci\u000f\u0005\u0003\u0003z\r=HaCBy[\u0005\u0005\t\u0011!B\u0001\u0007'\u00141a\u0018\u00136\u0011\u001d\t9)\fa\u0001\u0007k\u0004B!a\u001d\u0004x&!1\u0011`A;\u0005u!unY;nK:$(+\u00198hK\u001a{'/\\1ui&tw\rU1sC6\u001c\u0018A\u0002:f]\u0006lW\r\u0006\u0003\u0004\u0000\u0012\u001d\u0001#\u0002,\u0002:\u0012\u0005\u0001\u0003BA:\t\u0007IA\u0001\"\u0002\u0002v\tiqk\u001c:lgB\f7-Z#eSRDq!a\"/\u0001\u0004!I\u0001\u0005\u0003\u0002t\u0011-\u0011\u0002\u0002C\u0007\u0003k\u0012ABU3oC6,\u0007+\u0019:b[N\f!B]3gKJ,gnY3t)\u0011!\u0019\u0002b\b\u0011\u000bY\u000bI\f\"\u00061\t\u0011]A1\u0004\t\u0007\u0003\u001f\f\t\u000e\"\u0007\u0011\t\teD1\u0004\u0003\f\t;y\u0013\u0011!A\u0001\u0006\u0003\u00199JA\u0002`IYBq!a\"0\u0001\u0004!\t\u0003\u0005\u0003\u0002t\u0011\r\u0012\u0002\u0002C\u0013\u0003k\u0012qBU3gKJ,gnY3QCJ\fWn]\u0001\u0012O\u0016$8i\\7qY\u0016$\u0018n\u001c8UsB,G\u0003\u0002C\u0016\tc\u0001B!a\u001d\u0005.%!AqFA;\u0005I\u0019u.\u001c9mKRLwN\\%uK6\\\u0015N\u001c3\t\u000f\u0011M\u0002\u00071\u0001\u00056\u0005\u00191/^4\u0011\t\u0011]B1H\u0007\u0003\tsQA!a-\u0002\u000e%!AQ\bC\u001d\u0005)\u0019VoZ4fgRLwN\u001c")
public class DataWeaveDocumentService
implements WeaveTextDocumentService {
    private final ProjectKind projectKind;
    private final Executor executor;
    private final Logger logger;
    private final DataWeaveToolingService toolingServices;
    private final ProjectFileSystemService projectFS;
    private final WeaveScenarioManagerService scenariosService;
    private final VirtualFileSystem vfs;
    private final CodeActionsManagerService codeActionsManagerService;
    private final WeaveLanguageServerBuilder.TextDocumentTranslator textDocumentTranslator;

    private Logger logger() {
        return this.logger;
    }

    private DataWeaveToolingService toolingServices() {
        return this.toolingServices;
    }

    private ProjectFileSystemService projectFS() {
        return this.projectFS;
    }

    private WeaveScenarioManagerService scenariosService() {
        return this.scenariosService;
    }

    private VirtualFileSystem vfs() {
        return this.vfs;
    }

    private CodeActionsManagerService codeActionsManagerService() {
        return this.codeActionsManagerService;
    }

    private WeaveLanguageServerBuilder.TextDocumentTranslator textDocumentTranslator() {
        return this.textDocumentTranslator;
    }

    public void didOpen(DidOpenTextDocumentParams openParam) {
        TextDocumentItem textDocument = openParam.getTextDocument();
        String uri = textDocument.getUri();
        Option<org.mule.weave.v2.editor.VirtualFile> maybeVirtualFile = this.projectFS().update(uri, openParam.getTextDocument().getText());
        Option<org.mule.weave.v2.editor.VirtualFile> option = maybeVirtualFile;
        if (option instanceof Some) {
            Some some = (Some)option;
            org.mule.weave.v2.editor.VirtualFile value = (org.mule.weave.v2.editor.VirtualFile)some.value();
            this.projectKind.eventBus().fire(new DocumentOpenedEvent(value));
            return;
        }
        if (None$.MODULE$.equals(option)) {
            org.mule.weave.v2.editor.VirtualFile virtualFile = this.vfs().file(uri);
            if (virtualFile != null) {
                this.projectKind.eventBus().fire(new DocumentOpenedEvent(virtualFile));
                return;
            }
            return;
        }
        throw new MatchError(option);
    }

    public void didChange(DidChangeTextDocumentParams params) {
        VersionedTextDocumentIdentifier textDocument = params.getTextDocument();
        String uri = textDocument.getUri();
        Option<org.mule.weave.v2.editor.VirtualFile> maybeVirtualFile = this.projectFS().update(uri, ((TextDocumentContentChangeEvent)params.getContentChanges().get(0)).getText());
        Option<org.mule.weave.v2.editor.VirtualFile> option = maybeVirtualFile;
        if (option instanceof Some) {
            Some some = (Some)option;
            org.mule.weave.v2.editor.VirtualFile value = (org.mule.weave.v2.editor.VirtualFile)some.value();
            this.projectKind.eventBus().fire(new DocumentChangedEvent(value));
            return;
        }
        if (None$.MODULE$.equals(option)) {
            return;
        }
        throw new MatchError(option);
    }

    public void didClose(DidCloseTextDocumentParams params) {
        Option<org.mule.weave.v2.editor.VirtualFile> maybeVirtualFile;
        String uri = params.getTextDocument().getUri();
        this.toolingServices().closeDocument(uri);
        Option<org.mule.weave.v2.editor.VirtualFile> option = maybeVirtualFile = this.projectFS().closed(uri);
        if (option instanceof Some) {
            Some some = (Some)option;
            org.mule.weave.v2.editor.VirtualFile value = (org.mule.weave.v2.editor.VirtualFile)some.value();
            this.projectKind.eventBus().fire(new DocumentClosedEvent(value));
            return;
        }
        if (None$.MODULE$.equals(option)) {
            org.mule.weave.v2.editor.VirtualFile virtualFile = this.vfs().file(uri);
            if (virtualFile != null) {
                this.projectKind.eventBus().fire(new DocumentClosedEvent(virtualFile));
                return;
            }
            return;
        }
        throw new MatchError(option);
    }

    public void didSave(DidSaveTextDocumentParams params) {
        String uri = params.getTextDocument().getUri();
        Option<org.mule.weave.v2.editor.VirtualFile> maybeVirtualFile = this.projectFS().saved(params.getTextDocument().getUri());
        Option<org.mule.weave.v2.editor.VirtualFile> option = maybeVirtualFile;
        if (option instanceof Some) {
            Some some = (Some)option;
            org.mule.weave.v2.editor.VirtualFile value = (org.mule.weave.v2.editor.VirtualFile)some.value();
            this.projectKind.eventBus().fire(new DocumentSavedEvent(value));
            return;
        }
        if (None$.MODULE$.equals(option)) {
            org.mule.weave.v2.editor.VirtualFile virtualFile = this.vfs().file(uri);
            if (virtualFile != null) {
                this.projectKind.eventBus().fire(new DocumentSavedEvent(virtualFile));
                return;
            }
            return;
        }
        throw new MatchError(option);
    }

    @Override
    public void didFocusChange(DidFocusChangeParams params) {
        String uri = params.textDocumentIdentifier().getUri();
        Option maybeVirtualFile = Option$.MODULE$.apply((Object)this.projectFS().file(uri));
        Option option = maybeVirtualFile;
        if (option instanceof Some) {
            Some some = (Some)option;
            org.mule.weave.v2.editor.VirtualFile value = (org.mule.weave.v2.editor.VirtualFile)some.value();
            this.projectKind.eventBus().fire(new DocumentFocusChangedEvent(value));
            return;
        }
        if (None$.MODULE$.equals(option)) {
            org.mule.weave.v2.editor.VirtualFile virtualFile = this.vfs().file(uri);
            if (virtualFile != null) {
                this.projectKind.eventBus().fire(new DocumentFocusChangedEvent(virtualFile));
                return;
            }
            return;
        }
        throw new MatchError((Object)option);
    }

    public CompletableFuture<Either<java.util.List<CompletionItem>, CompletionList>> completion(CompletionParams position) {
        return CompletableFuture.supplyAsync(() -> {
            WeaveDocumentToolingService toolingService = this.toolingServices().openDocument(position.getTextDocument().getUri());
            return this.getSuggestionsAndCreateCompletionList(toolingService, position);
        }, this.executor);
    }

    private Either<java.util.List<CompletionItem>, CompletionList> getSuggestionsAndCreateCompletionList(WeaveDocumentToolingService toolingService, CompletionParams position) {
        int offset = toolingService.offsetOf(position.getPosition().getLine(), position.getPosition().getCharacter());
        SuggestionResult suggestionResult = toolingService.completion(offset);
        ArrayList result = new ArrayList();
        IntRef i = IntRef.create((int)0);
        Suggestion[] suggestions = suggestionResult.suggestions();
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])suggestions)).foreach((Function1 & Serializable & scala.Serializable)sug -> {
            DataWeaveDocumentService.$anonfun$getSuggestionsAndCreateCompletionList$1(this, i, suggestionResult, toolingService, result, sug);
            return BoxedUnit.UNIT;
        });
        return Either.forRight((Object)new CompletionList(false, result));
    }

    public CompletableFuture<SignatureHelp> signatureHelp(SignatureHelpParams params) {
        return CompletableFuture.supplyAsync(() -> {
            Position position;
            int offset;
            WeaveDocumentToolingService toolingService = this.toolingServices().openDocument(params.getTextDocument().getUri());
            Option maybeResult = toolingService.signatureInfo(offset = toolingService.offsetOf((position = params.getPosition()).getLine(), position.getCharacter()));
            Option option = maybeResult;
            if (option instanceof Some) {
                Some some = (Some)option;
                FunctionSignatureResult signatureResult = (FunctionSignatureResult)some.value();
                SignatureInformation[] signatures = (SignatureInformation[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])signatureResult.signatures())).map((Function1 & Serializable & scala.Serializable)s -> {
                    ParameterInformation[] informations = (ParameterInformation[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])s.parameters())).map((Function1 & Serializable & scala.Serializable)p -> new ParameterInformation(new StringBuilder(2).append(p.name()).append(": ").append(p.wtype().toString()).toString(), ""), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ParameterInformation.class)));
                    MarkupContent documentation = (MarkupContent)s.docAsMarkdown().map((Function1 & Serializable & scala.Serializable)d -> new MarkupContent("markdown", d)).orNull(Predef$.MODULE$.$conforms());
                    String arguments = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])informations)).map((Function1 & Serializable & scala.Serializable)i -> (String)i.getLabel().getLeft(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).mkString(",");
                    return new SignatureInformation(new StringBuilder(2).append(signatureResult.name()).append("(").append(arguments).append(")").toString(), documentation, Arrays.asList((Object[])informations));
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(SignatureInformation.class)));
                int i = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])signatureResult.signatures())).indexWhere((Function1 & Serializable & scala.Serializable)s -> BoxesRunTime.boxToBoolean((boolean)s.active()));
                return new SignatureHelp(Arrays.asList((Object[])signatures), Predef$.MODULE$.int2Integer(i), Predef$.MODULE$.int2Integer(signatureResult.currentArgIndex()));
            }
            if (None$.MODULE$.equals(option)) {
                return new SignatureHelp();
            }
            throw new MatchError((Object)option);
        });
    }

    private Seq<InputDirective> getInputDirectives(Option<AstNode> maybeAstNode) {
        return (Seq)maybeAstNode.collect((PartialFunction)new scala.Serializable(null){
            public static final long serialVersionUID = 0L;

            public final <A1 extends AstNode, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof DocumentNode) {
                    DocumentNode documentNode = (DocumentNode)A1;
                    return (B1)documentNode;
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(AstNode x1) {
                AstNode astNode = x1;
                return astNode instanceof DocumentNode;
            }
        }).map((Function1 & Serializable & scala.Serializable)documentNode -> (Seq)AstNodeHelper$.MODULE$.getInputs(documentNode).filter((Function1 & Serializable & scala.Serializable)inputDirective -> BoxesRunTime.boxToBoolean((boolean)DataWeaveDocumentService.$anonfun$getInputDirectives$3(inputDirective)))).getOrElse((Function0 & Serializable & scala.Serializable)() -> (Seq)Nil$.MODULE$);
    }

    private ArrayList<CodeLens> createMappingTestLens(String url) {
        Object object;
        ArrayList<CodeLens> lenses = new ArrayList<CodeLens>();
        Option<File> maybeFile = ProjectStructureHelper$.MODULE$.defaultTestSourceFolder(this.projectKind.structure());
        if (maybeFile.isDefined()) {
            Command command = new Command("Create Integration Mapping", Commands$.MODULE$.DW_CREATE_TEST_MAPPING(), Arrays.asList(URLUtils$.MODULE$.toLSPUrl((File)maybeFile.get()), url));
            object = BoxesRunTime.boxToBoolean((boolean)lenses.add(new CodeLens(this.docStartRange(), command, null)));
        } else {
            object = BoxedUnit.UNIT;
        }
        return lenses;
    }

    public CompletableFuture<java.util.List<? extends CodeLens>> codeLens(CodeLensParams params) {
        return CompletableFuture.supplyAsync(() -> DataWeaveDocumentService.$anonfun$codeLens$1(this, params));
    }

    private ArrayList<CodeLens> sampleDataLenses(Option<Scenario> maybeScenario, NameIdentifier nameIdentifier, Seq<InputDirective> inputDirectives, String uri) {
        Object object;
        ArrayList<CodeLens> lenses = new ArrayList<CodeLens>();
        if (maybeScenario.isEmpty()) {
            Object object2;
            if (inputDirectives.isEmpty()) {
                Command command = new Command(UserMessages$.MODULE$.defineSampleData(), Commands$.MODULE$.DW_CREATE_SCENARIO(), Arrays.asList(nameIdentifier.name(), uri, Scenario$.MODULE$.PLAYGROUND_SCENARIO()));
                object2 = BoxesRunTime.boxToBoolean((boolean)lenses.add(new CodeLens(this.docStartRange(), command, null)));
            } else {
                object2 = BoxedUnit.UNIT;
            }
            inputDirectives.foreach((Function1 & Serializable & scala.Serializable)id -> BoxesRunTime.boxToBoolean((boolean)DataWeaveDocumentService.$anonfun$sampleDataLenses$1(this, nameIdentifier, uri, lenses, id)));
            object = BoxedUnit.UNIT;
        } else {
            SampleInput[] scenarioInputs = ((Scenario)maybeScenario.get()).inputs();
            Map inputs = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])scenarioInputs)).groupBy((Function1 & Serializable & scala.Serializable)x$2 -> x$2.name());
            if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])scenarioInputs)).isEmpty() && inputDirectives.isEmpty()) {
                Command command = new Command(UserMessages$.MODULE$.defineSampleData(), Commands$.MODULE$.DW_CREATE_SCENARIO(), Arrays.asList(nameIdentifier.name(), uri, ((Scenario)maybeScenario.get()).name()));
                object = BoxesRunTime.boxToBoolean((boolean)lenses.add(new CodeLens(this.docStartRange(), command, null)));
            } else {
                inputDirectives.foreach((Function1 & Serializable & scala.Serializable)id -> {
                    if (!inputs.contains((Object)id.variable().name())) {
                        Command command = new Command(UserMessages$.MODULE$.defineSampleData(), Commands$.MODULE$.DW_CREATE_INPUT_SAMPLE(), Arrays.asList(nameIdentifier.name(), ((Scenario)maybeScenario.get()).name(), uri, id.variable().name(), this.inputFileName((InputDirective)id)));
                        return BoxesRunTime.boxToBoolean((boolean)lenses.add(new CodeLens(LSPConverters$.MODULE$.toRange(id.location()), command, null)));
                    }
                    return BoxedUnit.UNIT;
                });
                object = BoxedUnit.UNIT;
            }
        }
        return lenses;
    }

    private Range docStartRange() {
        Position docStart = new Position(0, 0);
        return new Range(docStart, docStart);
    }

    private CodeLens runMappingLens(NameIdentifier nameIdentifier) {
        Command runMappingCommand = new Command("Run Mapping", Commands$.MODULE$.DW_LAUNCH_MAPPING(), Arrays.asList(URLUtils$.MODULE$.toLSPUrl(Path.of(this.projectKind.project().getLocation()).toFile()), nameIdentifier.name(), LaunchConfiguration$.MODULE$.DATA_WEAVE_CONFIG_TYPE_NAME(), "false"));
        return new CodeLens(this.docStartRange(), runMappingCommand, null);
    }

    private String inputFileName(InputDirective id) {
        String extension = (String)id.mime().map((Function1 & Serializable & scala.Serializable)mime -> {
            String string = mime.mime();
            if ("application/json".equals(string)) {
                return ".json";
            }
            if ("application/java".equals(string)) {
                return ".dwl";
            }
            if ("application/xml".equals(string)) {
                return ".xml";
            }
            if ("application/yaml".equals(string)) {
                return ".yaml";
            }
            if ("application/x-ndjson".equals(string)) {
                return ".ndjson";
            }
            if ("application/octet-stream".equals(string)) {
                return ".bin";
            }
            if ("application/x-java-properties".equals(string)) {
                return ".properties";
            }
            if ("multipart/form-data".equals(string)) {
                return ".multipart";
            }
            if ("multipart/x-www-form-urlencoded".equals(string)) {
                return ".urlencoded";
            }
            if ("application/csv".equals(string) ? true : "text/csv".equals(string)) {
                return ".csv";
            }
            if ("text/plain".equals(string)) {
                return ".txt";
            }
            return new StringBuilder(1).append(".").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])string.split("/"))).last()).toString();
        }).orElse((Function0 & Serializable & scala.Serializable)() -> id.dataFormat().map((Function1 & Serializable & scala.Serializable)id -> {
            String string = id.id();
            if ("text".equals(string)) {
                return ".txt";
            }
            if ("java".equals(string)) {
                return ".dwl";
            }
            if ("excel".equals(string)) {
                return ".xlsx";
            }
            if ("binary".equals(string)) {
                return ".bin";
            }
            return new StringBuilder(1).append(".").append(string).toString();
        })).getOrElse((Function0 & Serializable & scala.Serializable)() -> ".json");
        return new StringBuilder(0).append(id.variable().name()).append(extension).toString();
    }

    private ArrayList<CodeLens> addDocumentationLenses(AstNode ast, String uri) {
        ArrayList<CodeLens> result = new ArrayList<CodeLens>();
        Seq functionNodes = AstNodeHelper$.MODULE$.collectChildrenWith(ast, FunctionDirectiveNode.class);
        ((IterableLike)functionNodes.filter((Function1 & Serializable & scala.Serializable)fd -> BoxesRunTime.boxToBoolean((boolean)DataWeaveDocumentService.$anonfun$addDocumentationLenses$1(fd)))).foreach((Function1 & Serializable & scala.Serializable)astNode -> BoxesRunTime.boxToBoolean((boolean)DataWeaveDocumentService.$anonfun$addDocumentationLenses$2(uri, result, astNode)));
        return result;
    }

    private ArrayList<CodeLens> addUnitTestLenses(AstNode ast, String uri) {
        ArrayList<CodeLens> result;
        block0: {
            result = new ArrayList<CodeLens>();
            AstNode astNode2 = ast;
            if (!(astNode2 instanceof ModuleNode)) break block0;
            ModuleNode moduleNode = (ModuleNode)astNode2;
            Seq topLevelFunctions = AstNodeHelper$.MODULE$.collectDirectChildrenWith((AstNode)moduleNode, FunctionDirectiveNode.class);
            topLevelFunctions.foreach((Function1 & Serializable & scala.Serializable)astNode -> BoxesRunTime.boxToBoolean((boolean)DataWeaveDocumentService.$anonfun$addUnitTestLenses$1(uri, result, astNode)));
        }
        return result;
    }

    public CompletableFuture<CodeLens> resolveCodeLens(CodeLens unresolved) {
        return CompletableFuture.completedFuture(unresolved);
    }

    public CompletableFuture<java.util.List<FoldingRange>> foldingRange(FoldingRangeRequestParams params) {
        return CompletableFuture.supplyAsync(() -> {
            WeaveDocumentToolingService service = this.toolingServices().openDocument(params.getTextDocument().getUri());
            FoldingRange[] regions = (FoldingRange[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])service.foldingRegions())).map((Function1 & Serializable & scala.Serializable)fr -> {
                FoldingRange range = new FoldingRange(fr.location().startPosition().line() - 1, fr.location().endPosition().line() - 1);
                int n = fr.kind();
                String kind = RegionKind$.MODULE$.COMMENTS() == n ? "comment" : "region";
                range.setKind(kind);
                return range;
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(FoldingRange.class)));
            return Arrays.asList((Object[])regions);
        });
    }

    public CompletableFuture<java.util.List<Either<Command, CodeAction>>> codeAction(CodeActionParams params) {
        String uri = params.getTextDocument().getUri();
        org.mule.weave.v2.editor.VirtualFile vf = this.vfs().file(uri);
        if (vf == null) {
            ResponseError error = new ResponseError(ResponseErrorCode.InvalidRequest, new StringBuilder(110).append("Invalid request codeAction(").append(params.getTextDocument().getUri()).append("), virtual file not registered as opened yet didOpen should have been called first.").toString(), null);
            return CompletableFuture.failedFuture((Throwable)new ResponseErrorException(error));
        }
        Optional contextMetadata = this.projectKind.metadataProvider().metadata((VirtualFile)VirtualFileAdapter$.MODULE$.apply(vf));
        return CompletableFuture.supplyAsync(() -> {
            Seq<CodeAction> actions = this.codeActionsManagerService().codeActionsFor(params, contextMetadata);
            ArrayList result = new ArrayList();
            actions.foreach((Function1 & Serializable & scala.Serializable)a -> BoxesRunTime.boxToBoolean((boolean)result.add(Either.forRight((Object)a))));
            return result;
        });
    }

    public CompletableFuture<CompletionItem> resolveCompletionItem(CompletionItem unresolved) {
        return CompletableFuture.completedFuture(unresolved);
    }

    public CompletableFuture<Hover> hover(HoverParams params) {
        return CompletableFuture.supplyAsync(() -> {
            WeaveDocumentToolingService toolingService = this.toolingServices().openDocument(params.getTextDocument().getUri());
            Position position = params.getPosition();
            int offset = toolingService.offsetOf(position.getLine(), position.getCharacter());
            return (Hover)toolingService.hoverResult(offset).map((Function1 & Serializable & scala.Serializable)hm -> {
                Hover hoverResult = new Hover();
                boolean x$1 = false;
                boolean x$2 = true;
                boolean x$3 = false;
                Seq x$4 = (Seq)new .colon.colon((Object)"Documentation", (List)Nil$.MODULE$);
                boolean x$5 = true;
                boolean x$6 = WeaveTypeEmitterConfig$.MODULE$.apply$default$3();
                boolean x$7 = WeaveTypeEmitterConfig$.MODULE$.apply$default$4();
                boolean x$8 = WeaveTypeEmitterConfig$.MODULE$.apply$default$5();
                boolean x$9 = WeaveTypeEmitterConfig$.MODULE$.apply$default$7();
                boolean x$10 = WeaveTypeEmitterConfig$.MODULE$.apply$default$9();
                boolean x$11 = WeaveTypeEmitterConfig$.MODULE$.apply$default$10();
                boolean x$12 = WeaveTypeEmitterConfig$.MODULE$.apply$default$11();
                boolean x$13 = WeaveTypeEmitterConfig$.MODULE$.apply$default$12();
                boolean x$14 = WeaveTypeEmitterConfig$.MODULE$.apply$default$14();
                boolean x$15 = WeaveTypeEmitterConfig$.MODULE$.apply$default$15();
                Option x$16 = WeaveTypeEmitterConfig$.MODULE$.apply$default$16();
                WeaveTypeEmitterConfig typeEmitterConfig = new WeaveTypeEmitterConfig(x$1, x$2, x$6, x$7, x$8, x$3, x$9, x$5, x$10, x$11, x$12, x$13, x$4, x$14, x$15, x$16);
                String expressionType = (String)Option$.MODULE$.apply((Object)hm.resultType()).map((Function1 & Serializable & scala.Serializable)wt -> new StringBuilder(9).append("Type: `").append(wt.toString(typeEmitterConfig)).append("`\n").toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "");
                String documentation = new StringBuilder(1).append(expressionType).append("\n").append(hm.markdownDocs().getOrElse((Function0 & Serializable & scala.Serializable)() -> "")).toString();
                hoverResult.setContents(new MarkupContent("markdown", documentation));
                hoverResult.setRange(LSPConverters$.MODULE$.toRange(hm.weaveLocation()));
                return hoverResult;
            }).orElse((Function0 & Serializable & scala.Serializable)() -> Option$.MODULE$.apply((Object)toolingService.typeOf(offset)).map((Function1 & Serializable & scala.Serializable)wt -> {
                Hover hoverResult;
                block0: {
                    hoverResult = new Hover();
                    boolean x$17 = false;
                    boolean x$18 = true;
                    boolean x$19 = false;
                    boolean x$20 = true;
                    boolean x$21 = WeaveTypeEmitterConfig$.MODULE$.apply$default$3();
                    boolean x$22 = WeaveTypeEmitterConfig$.MODULE$.apply$default$4();
                    boolean x$23 = WeaveTypeEmitterConfig$.MODULE$.apply$default$5();
                    boolean x$24 = WeaveTypeEmitterConfig$.MODULE$.apply$default$7();
                    boolean x$25 = WeaveTypeEmitterConfig$.MODULE$.apply$default$9();
                    boolean x$26 = WeaveTypeEmitterConfig$.MODULE$.apply$default$10();
                    boolean x$27 = WeaveTypeEmitterConfig$.MODULE$.apply$default$11();
                    boolean x$28 = WeaveTypeEmitterConfig$.MODULE$.apply$default$12();
                    Seq x$29 = WeaveTypeEmitterConfig$.MODULE$.apply$default$13();
                    boolean x$30 = WeaveTypeEmitterConfig$.MODULE$.apply$default$14();
                    boolean x$31 = WeaveTypeEmitterConfig$.MODULE$.apply$default$15();
                    Option x$32 = WeaveTypeEmitterConfig$.MODULE$.apply$default$16();
                    WeaveTypeEmitterConfig typeEmitterConfig = new WeaveTypeEmitterConfig(x$17, x$18, x$21, x$22, x$23, x$19, x$24, x$20, x$25, x$26, x$27, x$28, x$29, x$30, x$31, x$32);
                    String expressionType = new StringBuilder(8).append("Type: `").append(wt.toString(typeEmitterConfig)).append("`").toString();
                    hoverResult.setContents(new MarkupContent("markdown", expressionType));
                    if (wt.location().startPosition().index() < 0) break block0;
                    hoverResult.setRange(LSPConverters$.MODULE$.toRange(wt.location()));
                }
                return hoverResult;
            })).orNull(Predef$.MODULE$.$conforms());
        }, this.executor);
    }

    public SymbolKind toSymbolKind(int kind) {
        int n = kind;
        if (SymbolKind$.MODULE$.Array() == n) {
            return SymbolKind.Array;
        }
        if (SymbolKind$.MODULE$.Boolean() == n) {
            return SymbolKind.Boolean;
        }
        if (SymbolKind$.MODULE$.Class() == n) {
            return SymbolKind.Class;
        }
        if (SymbolKind$.MODULE$.Constant() == n) {
            return SymbolKind.Constant;
        }
        if (SymbolKind$.MODULE$.Field() == n) {
            return SymbolKind.Field;
        }
        if (SymbolKind$.MODULE$.Module() == n) {
            return SymbolKind.Module;
        }
        if (SymbolKind$.MODULE$.Property() == n) {
            return SymbolKind.Property;
        }
        if (SymbolKind$.MODULE$.Namespace() == n) {
            return SymbolKind.Namespace;
        }
        if (SymbolKind$.MODULE$.String() == n) {
            return SymbolKind.String;
        }
        if (SymbolKind$.MODULE$.Variable() == n) {
            return SymbolKind.Variable;
        }
        if (SymbolKind$.MODULE$.Constructor() == n) {
            return SymbolKind.Constructor;
        }
        if (SymbolKind$.MODULE$.Enum() == n) {
            return SymbolKind.Enum;
        }
        if (SymbolKind$.MODULE$.Method() == n) {
            return SymbolKind.Method;
        }
        if (SymbolKind$.MODULE$.Function() == n) {
            return SymbolKind.Function;
        }
        if (SymbolKind$.MODULE$.File() == n) {
            return SymbolKind.File;
        }
        if (SymbolKind$.MODULE$.Package() == n) {
            return SymbolKind.Package;
        }
        if (SymbolKind$.MODULE$.Interface() == n) {
            return SymbolKind.Interface;
        }
        return SymbolKind.Property;
    }

    public CompletableFuture<java.util.List<Either<org.eclipse.lsp4j.SymbolInformation, DocumentSymbol>>> documentSymbol(DocumentSymbolParams params) {
        return CompletableFuture.supplyAsync(() -> {
            TextDocumentIdentifier document = params.getTextDocument();
            WeaveDocumentToolingService toolingService = this.toolingServices().openDocument(document.getUri());
            ArrayList result = new ArrayList();
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])toolingService.documentSymbol())).foreach((Function1 & Serializable & scala.Serializable)e -> BoxesRunTime.boxToBoolean((boolean)DataWeaveDocumentService.$anonfun$documentSymbol$2(this, result, e)));
            return result;
        }, this.executor);
    }

    public CompletableFuture<Either<java.util.List<? extends Location>, java.util.List<? extends LocationLink>>> definition(DefinitionParams params) {
        return CompletableFuture.supplyAsync(() -> {
            WeaveDocumentToolingService toolingService = this.toolingServices().openDocument(params.getTextDocument().getUri());
            int offset = toolingService.offsetOf(params.getPosition().getLine(), params.getPosition().getCharacter());
            ArrayList result = new ArrayList();
            Link[] definitions = toolingService.definitions(offset);
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])definitions)).foreach((Function1 & Serializable & scala.Serializable)ll -> BoxesRunTime.boxToBoolean((boolean)DataWeaveDocumentService.$anonfun$definition$2(this, params, result, ll)));
            return Either.forRight(result);
        }, this.executor);
    }

    private Option<String> resolveUrl(NameIdentifier moduleName) {
        WeaveResourceResolver resourceResolver = this.vfs().asResourceResolver();
        Option maybeUrl = resourceResolver.resolve(moduleName).map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.url());
        return maybeUrl;
    }

    public CompletableFuture<java.util.List<? extends TextEdit>> formatting(DocumentFormattingParams params) {
        return CompletableFuture.supplyAsync(() -> {
            WeaveDocumentToolingService toolingService = this.toolingServices().openDocument(params.getTextDocument().getUri());
            LSPWeaveTextDocument textDocument = new LSPWeaveTextDocument(toolingService);
            toolingService.formatDocument((WeaveTextDocument)textDocument, new FormattingOptions(params.getOptions().getTabSize(), params.getOptions().isInsertSpaces()));
            return textDocument.edits();
        }, this.executor);
    }

    public CompletableFuture<java.util.List<? extends TextEdit>> rangeFormatting(DocumentRangeFormattingParams params) {
        return CompletableFuture.supplyAsync(() -> {
            WeaveDocumentToolingService toolingService = this.toolingServices().openDocument(params.getTextDocument().getUri());
            LSPWeaveTextDocument textDocument = new LSPWeaveTextDocument(toolingService);
            Range range = params.getRange();
            int startOffset = toolingService.offsetOf(range.getStart().getLine(), range.getStart().getCharacter());
            int endOffset = toolingService.offsetOf(range.getEnd().getLine(), range.getEnd().getCharacter());
            toolingService.format(startOffset, endOffset, (WeaveTextDocument)textDocument, new FormattingOptions(params.getOptions().getTabSize(), params.getOptions().isInsertSpaces()));
            return textDocument.edits();
        }, this.executor);
    }

    public CompletableFuture<WorkspaceEdit> rename(RenameParams params) {
        return CompletableFuture.supplyAsync(() -> {
            WeaveDocumentToolingService toolingService = this.toolingServices().openDocument(params.getTextDocument().getUri());
            int offset = toolingService.offsetOf(params.getPosition().getLine(), params.getPosition().getCharacter());
            Reference[] ref2 = toolingService.rename(offset, params.getNewName());
            WorkspaceEdit edit = new WorkspaceEdit();
            NameIdentifier localNameIdentifier = toolingService.file().getNameIdentifier();
            Map renamesByDocument = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])ref2)).groupBy((Function1 & Serializable & scala.Serializable)ref -> (NameIdentifier)ref.moduleSource().getOrElse((Function0 & Serializable & scala.Serializable)() -> localNameIdentifier));
            renamesByDocument.foreach((Function1 & Serializable & scala.Serializable)references -> {
                Option<String> option = this.resolveUrl((NameIdentifier)references._1());
                if (option instanceof Some) {
                    Some some = (Some)option;
                    String url = (String)some.value();
                    return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])references._2())).map((Function1 & Serializable & scala.Serializable)reference -> {
                        Location location = this.textDocumentTranslator().translate(url, LSPConverters$.MODULE$.toRange(reference.referencedNode().location()));
                        ArrayList<TextEdit> changes = (ArrayList<TextEdit>)edit.getChanges().get(location.getUri());
                        if (changes == null) {
                            changes = new ArrayList<TextEdit>();
                        }
                        changes.add(new TextEdit(location.getRange(), params.getNewName()));
                        return edit.getChanges().put(location.getUri(), changes);
                    }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(java.util.List.class)));
                }
                if (None$.MODULE$.equals(option)) {
                    return BoxedUnit.UNIT;
                }
                throw new MatchError(option);
            });
            return edit;
        }, this.executor);
    }

    public CompletableFuture<java.util.List<? extends Location>> references(ReferenceParams params) {
        return CompletableFuture.supplyAsync(() -> {
            WeaveDocumentToolingService toolingService = this.toolingServices().openDocument(params.getTextDocument().getUri());
            int offset = toolingService.offsetOf(params.getPosition().getLine(), params.getPosition().getCharacter());
            Reference[] referencesResult = toolingService.references(offset);
            return JavaConverters$.MODULE$.seqAsJavaList((Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])referencesResult)).map((Function1 & Serializable & scala.Serializable)r -> {
                String url = r.isLocalReference() ? params.getTextDocument().getUri() : (String)this.resolveUrl((NameIdentifier)r.moduleSource().get()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "");
                Range range = LSPConverters$.MODULE$.toRange(r.referencedNode().location());
                return this.textDocumentTranslator().translate(url, range);
            }, Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit())));
        }, this.executor);
    }

    private CompletionItemKind getCompletionType(Suggestion sug) {
        int n = sug.itemType();
        if (SuggestionType$.MODULE$.Class() == n) {
            return CompletionItemKind.Class;
        }
        if (SuggestionType$.MODULE$.Constructor() == n) {
            return CompletionItemKind.Constructor;
        }
        if (SuggestionType$.MODULE$.Field() == n) {
            return CompletionItemKind.Field;
        }
        if (SuggestionType$.MODULE$.Enum() == n) {
            return CompletionItemKind.Enum;
        }
        if (SuggestionType$.MODULE$.Function() == n) {
            return CompletionItemKind.Function;
        }
        if (SuggestionType$.MODULE$.Keyword() == n) {
            return CompletionItemKind.Keyword;
        }
        if (SuggestionType$.MODULE$.Module() == n) {
            return CompletionItemKind.Module;
        }
        if (SuggestionType$.MODULE$.Method() == n) {
            return CompletionItemKind.Method;
        }
        if (SuggestionType$.MODULE$.Property() == n) {
            return CompletionItemKind.Property;
        }
        if (SuggestionType$.MODULE$.Variable() == n) {
            return CompletionItemKind.Variable;
        }
        return CompletionItemKind.Property;
    }

    public static final /* synthetic */ void $anonfun$getSuggestionsAndCreateCompletionList$1(DataWeaveDocumentService $this, IntRef i$1, SuggestionResult suggestionResult$1, WeaveDocumentToolingService toolingService$1, ArrayList result$1, Suggestion sug) {
        String index = Integer.toString(i$1.elem);
        String prefix = new StringOps(Predef$.MODULE$.augmentString("0")).$times(suggestionResult$1.suggestions().length - index.length());
        CompletionItem item = new CompletionItem(sug.name());
        item.setDetail((String)sug.wtype().map((Function1 & Serializable & scala.Serializable)wt -> {
            boolean x$1 = false;
            boolean x$2 = true;
            boolean x$3 = true;
            boolean x$4 = false;
            boolean x$5 = false;
            boolean x$6 = WeaveTypeEmitterConfig$.MODULE$.apply$default$5();
            boolean x$7 = WeaveTypeEmitterConfig$.MODULE$.apply$default$7();
            boolean x$8 = WeaveTypeEmitterConfig$.MODULE$.apply$default$8();
            boolean x$9 = WeaveTypeEmitterConfig$.MODULE$.apply$default$9();
            boolean x$10 = WeaveTypeEmitterConfig$.MODULE$.apply$default$10();
            boolean x$11 = WeaveTypeEmitterConfig$.MODULE$.apply$default$11();
            boolean x$12 = WeaveTypeEmitterConfig$.MODULE$.apply$default$12();
            Seq x$13 = WeaveTypeEmitterConfig$.MODULE$.apply$default$13();
            boolean x$14 = WeaveTypeEmitterConfig$.MODULE$.apply$default$14();
            boolean x$15 = WeaveTypeEmitterConfig$.MODULE$.apply$default$15();
            Option x$16 = WeaveTypeEmitterConfig$.MODULE$.apply$default$16();
            WeaveTypeEmitterConfig emitterConfig = new WeaveTypeEmitterConfig(x$1, x$3, x$4, x$2, x$6, x$5, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16);
            return wt.toString(emitterConfig);
        }).orNull(Predef$.MODULE$.$conforms()));
        item.setSortText(new StringBuilder(0).append(prefix).append(index).toString());
        item.setDocumentation(new MarkupContent("markdown", (String)sug.markdownDocumentation().getOrElse((Function0 & Serializable & scala.Serializable)() -> "")));
        int startIndex = suggestionResult$1.replacementStart();
        int endIndex = suggestionResult$1.replacementEnd();
        org.mule.weave.v2.parser.location.Position startPosition = toolingService$1.file().asResource().positionOf(startIndex);
        org.mule.weave.v2.parser.location.Position endPosition = toolingService$1.file().asResource().positionOf(endIndex);
        TextEdit edit = new TextEdit(new Range(LSPConverters$.MODULE$.toPosition(startPosition), LSPConverters$.MODULE$.toPosition(endPosition)), sug.template().toVSCodeString());
        item.setTextEdit(Either.forLeft((Object)edit));
        item.setFilterText(sug.template().toVSCodeString());
        item.setInsertTextFormat(InsertTextFormat.Snippet);
        item.setKind($this.getCompletionType(sug));
        result$1.add(item);
        ++i$1.elem;
    }

    public static final /* synthetic */ boolean $anonfun$getInputDirectives$3(InputDirective inputDirective) {
        return !NameIdentifier$.MODULE$.INSERTED_FAKE_VARIABLE().equals((Object)inputDirective.variable()) && AstNodeHelper$.MODULE$.notInjectedNode((AstNode)inputDirective);
    }

    public static final /* synthetic */ AstNode $anonfun$codeLens$2(AstNodeResult x$1) {
        return x$1.astNode();
    }

    public static final /* synthetic */ boolean $anonfun$codeLens$3(DataWeaveDocumentService $this, ArrayList result$2, String uri$1, AstNode ast) {
        result$2.addAll($this.addDocumentationLenses(ast, uri$1));
        return result$2.addAll($this.addUnitTestLenses(ast, uri$1));
    }

    /*
     * Unable to fully structure code
     */
    public static final /* synthetic */ java.util.List $anonfun$codeLens$1(DataWeaveDocumentService $this, CodeLensParams params$2) {
        block4: {
            block6: {
                block5: {
                    uri = params$2.getTextDocument().getUri();
                    result = new ArrayList<CodeLens>();
                    documentToolingService = $this.toolingServices().openDocument(params$2.getTextDocument().getUri());
                    nameIdentifier = documentToolingService.file().getNameIdentifier();
                    maybeAstNode = documentToolingService.ast().map((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$codeLens$2(org.mule.weave.v2.editor.AstNodeResult ), (Lorg/mule/weave/v2/editor/AstNodeResult;)Lorg/mule/weave/v2/parser/ast/AstNode;)());
                    maybeString = WeaveASTQueryUtils$.MODULE$.fileKind((Option<AstNode>)maybeAstNode);
                    if (documentToolingService.file().readOnly()) break block4;
                    var9_8 = false;
                    var10_9 = null;
                    var11_10 = maybeString;
                    if (!(var11_10 instanceof Some)) break block5;
                    var9_8 = true;
                    var10_9 = (Some)var11_10;
                    var12_11 = (String)var10_9.value();
                    v0 = WeaveASTQueryUtils$.MODULE$.MODULE();
                    var13_12 = var12_11;
                    if (v0 != null ? v0.equals(var13_12) == false : var13_12 != null) break block5;
                    BoxesRunTime.boxToBoolean((boolean)result.addAll($this.createMappingTestLens(documentToolingService.file().url())));
                    break block6;
                }
                if (!var9_8) ** GOTO lbl-1000
                var14_13 = (String)var10_9.value();
                v1 = WeaveASTQueryUtils$.MODULE$.MAPPING();
                var15_14 = var14_13;
                if (!(v1 != null ? v1.equals(var15_14) == false : var15_14 != null)) {
                    maybeScenario = $this.scenariosService().activeScenario(nameIdentifier);
                    inputDirectives = $this.getInputDirectives((Option<AstNode>)maybeAstNode);
                    result.addAll($this.sampleDataLenses(maybeScenario, nameIdentifier, inputDirectives, uri));
                    BoxesRunTime.boxToBoolean((boolean)result.add($this.runMappingLens(nameIdentifier)));
                } else if (var9_8) {
                    var18_17 = (String)var10_9.value();
                    v2 = WeaveASTQueryUtils$.MODULE$.BAT();
                    var19_18 = var18_17;
                    if (!(v2 != null ? v2.equals(var19_18) == false : var19_18 != null)) {
                        command = new Command("Run BAT Test", Commands$.MODULE$.DW_LAUNCH_MAPPING(), Arrays.asList(new Object[]{URLUtils$.MODULE$.toLSPUrl(Path.of($this.projectKind.project().getLocation()).toFile()), nameIdentifier.name(), LaunchConfiguration$.MODULE$.BAT_CONFIG_TYPE_NAME(), "false"}));
                        BoxesRunTime.boxToBoolean((boolean)result.add(new CodeLens($this.docStartRange(), command, null)));
                    }
                }
            }
            maybeAstNode.foreach((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$codeLens$3$adapted(org.mule.weave.lsp.services.DataWeaveDocumentService java.util.ArrayList java.lang.String org.mule.weave.v2.parser.ast.AstNode ), (Lorg/mule/weave/v2/parser/ast/AstNode;)Ljava/lang/Object;)((DataWeaveDocumentService)$this, result, (String)uri));
        }
        return result;
    }

    public static final /* synthetic */ boolean $anonfun$sampleDataLenses$1(DataWeaveDocumentService $this, NameIdentifier nameIdentifier$1, String uri$2, ArrayList lenses$1, InputDirective id) {
        Command command = new Command(UserMessages$.MODULE$.defineSampleData(), Commands$.MODULE$.DW_CREATE_INPUT_SAMPLE(), Arrays.asList(nameIdentifier$1.name(), Scenario$.MODULE$.PLAYGROUND_SCENARIO(), uri$2, id.variable().name(), $this.inputFileName(id)));
        return lenses$1.add(new CodeLens(LSPConverters$.MODULE$.toRange(id.location()), command, null));
    }

    public static final /* synthetic */ boolean $anonfun$addDocumentationLenses$1(FunctionDirectiveNode fd) {
        return fd.weaveDoc().isEmpty() && !(fd.literal() instanceof OverloadedFunctionNode);
    }

    public static final /* synthetic */ boolean $anonfun$addDocumentationLenses$2(String uri$3, ArrayList result$3, FunctionDirectiveNode astNode) {
        Command command = InsertDocumentationCommand$.MODULE$.createCommand(uri$3, (AstNode)astNode);
        Range range = new Range(LSPConverters$.MODULE$.toPosition(astNode.location().startPosition()), LSPConverters$.MODULE$.toPosition(astNode.location().startPosition()));
        return result$3.add(new CodeLens(range, command, null));
    }

    public static final /* synthetic */ boolean $anonfun$addUnitTestLenses$1(String uri$4, ArrayList result$4, FunctionDirectiveNode astNode) {
        Command command = CreateUnitTest$.MODULE$.createCommand(uri$4, (AstNode)astNode);
        Range range = new Range(LSPConverters$.MODULE$.toPosition(astNode.location().startPosition()), LSPConverters$.MODULE$.toPosition(astNode.location().startPosition()));
        return result$4.add(new CodeLens(range, command, null));
    }

    public static final /* synthetic */ boolean $anonfun$documentSymbol$2(DataWeaveDocumentService $this, ArrayList result$6, SymbolInformation e) {
        DocumentSymbol symbol = new DocumentSymbol();
        symbol.setName(e.name());
        symbol.setSelectionRange(LSPConverters$.MODULE$.toRange(e.location()));
        symbol.setRange(LSPConverters$.MODULE$.toRange(e.location()));
        symbol.setKind($this.toSymbolKind(e.kind()));
        return result$6.add(Either.forRight((Object)symbol));
    }

    public static final /* synthetic */ boolean $anonfun$definition$4(Link ll$1, SampleInput sampleInput) {
        return sampleInput.name().equals(ll$1.linkLocation().name());
    }

    public static final /* synthetic */ void $anonfun$definition$5(LocationLink link$1, SampleInput sampleInput) {
        Position position = new Position(0, 0);
        link$1.setTargetRange(new Range(position, position));
        link$1.setTargetSelectionRange(new Range(position, position));
        link$1.setTargetUri(sampleInput.uri());
    }

    public static final /* synthetic */ void $anonfun$definition$3(Link ll$1, LocationLink link$1, Scenario activeScenario) {
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])activeScenario.inputs())).find((Function1 & Serializable & scala.Serializable)sampleInput -> BoxesRunTime.boxToBoolean((boolean)DataWeaveDocumentService.$anonfun$definition$4(ll$1, sampleInput))).foreach((Function1 & Serializable & scala.Serializable)sampleInput -> {
            DataWeaveDocumentService.$anonfun$definition$5(link$1, sampleInput);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$definition$2(DataWeaveDocumentService $this, DefinitionParams params$7, ArrayList result$7, Link ll) {
        LocationLink link = new LocationLink();
        link.setOriginSelectionRange(LSPConverters$.MODULE$.toRange(ll.linkLocation().location()));
        Reference reference = ll.reference();
        link.setTargetRange(LSPConverters$.MODULE$.toRange(reference.referencedNode().location()));
        link.setTargetSelectionRange(LSPConverters$.MODULE$.toRange(reference.referencedNode().location()));
        if (reference.isLocalReference()) {
            link.setTargetUri(params$7.getTextDocument().getUri());
            $this.scenariosService().activeScenario($this.vfs().file(params$7.getTextDocument().getUri()).getNameIdentifier()).foreach((Function1 & Serializable & scala.Serializable)activeScenario -> {
                DataWeaveDocumentService.$anonfun$definition$3(ll, link, activeScenario);
                return BoxedUnit.UNIT;
            });
        } else {
            NameIdentifier moduleName = (NameIdentifier)reference.moduleSource().get();
            Option<String> maybeUrl = $this.resolveUrl(moduleName);
            Option<String> option = maybeUrl;
            if (option instanceof Some) {
                Some some = (Some)option;
                String url = (String)some.value();
                link.setTargetUri(url);
            } else if (None$.MODULE$.equals(option)) {
                $this.logger().warn(new StringBuilder(23).append("Resource not found for ").append(moduleName).toString());
            } else {
                throw new MatchError(option);
            }
        }
        return result$7.add(link);
    }

    public DataWeaveDocumentService(ProjectKind projectKind, Executor executor) {
        this.projectKind = projectKind;
        this.executor = executor;
        this.logger = LoggerFactory.getLogger(DataWeaveDocumentService.class);
        this.toolingServices = projectKind.toolingService(DataWeaveToolingService.class);
        this.projectFS = projectKind.toolingService(ProjectFileSystemService.class);
        this.scenariosService = projectKind.toolingService(WeaveScenarioManagerService.class);
        this.vfs = projectKind.vfs();
        this.codeActionsManagerService = projectKind.toolingService(CodeActionsManagerService.class);
        this.textDocumentTranslator = projectKind.toolingService(TextDocumentTranslatorService.class);
    }

    public static final /* synthetic */ Object $anonfun$codeLens$3$adapted(DataWeaveDocumentService $this, ArrayList result$2, String uri$1, AstNode ast) {
        return BoxesRunTime.boxToBoolean((boolean)DataWeaveDocumentService.$anonfun$codeLens$3($this, result$2, uri$1, ast));
    }
}

