/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.lsp.services;

import java.io.File;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.DiagnosticSeverity;
import org.eclipse.lsp4j.PublishDiagnosticsParams;
import org.mule.weave.extension.api.extension.validation.DocumentNode;
import org.mule.weave.extension.api.extension.validation.MessageBuilderFactory;
import org.mule.weave.extension.api.extension.validation.MessageValidationCollector;
import org.mule.weave.extension.api.extension.validation.ValidationTypeLevel;
import org.mule.weave.extension.api.extension.validation.WeaveValidator;
import org.mule.weave.extension.api.filesystem.VirtualFile;
import org.mule.weave.extension.api.metadata.ContextMetadata;
import org.mule.weave.extension.api.metadata.InputMetadata;
import org.mule.weave.extension.api.project.ProjectMetadata;
import org.mule.weave.lsp.indexer.events.IndexingFinishedEvent$;
import org.mule.weave.lsp.indexer.events.IndexingType$;
import org.mule.weave.lsp.indexer.events.OnIndexingFinished;
import org.mule.weave.lsp.project.ProjectKind;
import org.mule.weave.lsp.project.Settings$;
import org.mule.weave.lsp.project.components.SampleDataComponent;
import org.mule.weave.lsp.project.events.OnProjectStarted;
import org.mule.weave.lsp.project.events.OnSettingsChanged;
import org.mule.weave.lsp.project.events.ProjectStartedEvent$;
import org.mule.weave.lsp.project.events.SettingsChangedEvent$;
import org.mule.weave.lsp.services.DataWeaveToolingService$;
import org.mule.weave.lsp.services.DiagnosticsPublisherService;
import org.mule.weave.lsp.services.MessageValidationCollectorAdapter;
import org.mule.weave.lsp.services.ToolingService;
import org.mule.weave.lsp.services.WeaveToolingServiceFactory;
import org.mule.weave.lsp.utils.InternalEventBus;
import org.mule.weave.lsp.utils.LSPConverters$;
import org.mule.weave.lsp.utils.URLUtils$;
import org.mule.weave.lsp.utils.VFUtils$;
import org.mule.weave.lsp.utils.WeaveTypeUtils$;
import org.mule.weave.lsp.vfs.VirtualFileAdapter$;
import org.mule.weave.lsp.vfs.events.OnProjectVirtualFileChangedEvent;
import org.mule.weave.lsp.vfs.events.OnProjectVirtualFileCreatedEvent;
import org.mule.weave.lsp.vfs.events.OnProjectVirtualFileDeletedEvent;
import org.mule.weave.lsp.vfs.events.ProjectVirtualFileChangedEvent$;
import org.mule.weave.lsp.vfs.events.ProjectVirtualFileCreatedEvent$;
import org.mule.weave.lsp.vfs.events.ProjectVirtualFileDeletedEvent$;
import org.mule.weave.v2.api.tooling.ast.DWAstNode;
import org.mule.weave.v2.api.tooling.impl.message.DefaultMessageBuilder;
import org.mule.weave.v2.api.tooling.message.MessageBuilder;
import org.mule.weave.v2.api.tooling.ts.DWType;
import org.mule.weave.v2.editor.ImplicitInput$;
import org.mule.weave.v2.editor.MappingInput;
import org.mule.weave.v2.editor.QuickFix;
import org.mule.weave.v2.editor.ValidationMessage;
import org.mule.weave.v2.editor.ValidationMessages;
import org.mule.weave.v2.editor.VirtualFileSystem;
import org.mule.weave.v2.editor.WeaveDocumentToolingService;
import org.mule.weave.v2.editor.WeaveToolingService;
import org.mule.weave.v2.parser.MessageCategory;
import org.mule.weave.v2.parser.ScopePhaseCategory$;
import org.mule.weave.v2.parser.TypePhaseCategory$;
import org.mule.weave.v2.parser.ast.variables.NameIdentifier;
import org.mule.weave.v2.sdk.WeaveResource;
import org.mule.weave.v2.ts.WeaveType;
import org.mule.weave.v2.versioncheck.SVersion$;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Array$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\rMa\u0001\u0002\u00180\u0001iB\u0001\"\u0012\u0001\u0003\u0006\u0004%\tA\u0012\u0005\t!\u0002\u0011\t\u0011)A\u0005\u000f\"A\u0011\u000b\u0001BC\u0002\u0013\u0005!\u000b\u0003\u0005\\\u0001\t\u0005\t\u0015!\u0003T\u0011!a\u0006A!A!\u0002\u0013i\u0006\u0002\u00031\u0001\u0005\u0003\u0005\u000b\u0011B1\t\u0011\u0011\u0004!\u0011!Q\u0001\n\u0015DQa\u001c\u0001\u0005\u0002ADqa\u001e\u0001C\u0002\u0013%\u0001\u0010\u0003\u0004\u0000\u0001\u0001\u0006I!\u001f\u0005\f\u0003\u0003\u0001\u0001\u0019!a\u0001\n#\t\u0019\u0001C\u0006\u0002\u0010\u0001\u0001\r\u00111A\u0005\u0012\u0005E\u0001bCA\u000f\u0001\u0001\u0007\t\u0011)Q\u0005\u0003\u000bA!\"a\b\u0001\u0011\u000b\u0007I\u0011BA\u0011\u0011-\tI\u0003\u0001a\u0001\u0002\u0004%I!a\u000b\t\u0017\u0005\u0005\u0003\u00011AA\u0002\u0013%\u00111\t\u0005\f\u0003\u000f\u0002\u0001\u0019!A!B\u0013\ti\u0003C\u0005\u0002J\u0001\u0001\r\u0011\"\u0005\u0002L!I\u00111\u000b\u0001A\u0002\u0013E\u0011Q\u000b\u0005\t\u00033\u0002\u0001\u0015)\u0003\u0002N!9\u00111\r\u0001\u0005B\u0005\u0015\u0004bBA=\u0001\u0011%\u00111\u0010\u0005\b\u0003G\u0003A\u0011BAS\u0011\u001d\tY\u000b\u0001C\u0005\u0003[Cq!!.\u0001\t\u0003\t9\fC\u0004\u0002L\u0002!I!!4\t\u000f\u0005=\u0007\u0001\"\u0001\u0002R\"9\u00111\u001d\u0001\u0005\u0002\u0005\u0015\bbBA\u007f\u0001\u0011\u0005\u0011q \u0005\b\u0003{\u0004A\u0011\u0001B\u0005\u0011\u001d\u0011\t\u0002\u0001C\u0001\u0005'Aq!!@\u0001\t\u0013\u00119\u0002C\u0004\u0003N\u0001!\tAa\u0014\t\u000f\tM\u0003\u0001\"\u0001\u0003V!9!1\f\u0001\u0005\u0002\tu\u0003b\u0002B2\u0001\u0011\u0005!Q\r\u0005\n\u0005o\u0002\u0011\u0013!C\u0001\u0005sBqA!$\u0001\t\u0003\u0011y\tC\u0004\u00032\u0002!\tAa-\t\u0013\t]\u0007!%A\u0005\u0002\te\u0007b\u0002Bo\u0001\u0011%!q\u001c\u0005\b\u0005c\u0004A\u0011\u0001Bz\u0011%\u0011I\u0010AI\u0001\n\u0003\u0011I\u000eC\u0004\u0003|\u0002!IA!@\t\u000f\r=\u0001\u0001\"\u0001\u0004\u0012\t9B)\u0019;b/\u0016\fg/\u001a+p_2LgnZ*feZL7-\u001a\u0006\u0003aE\n\u0001b]3sm&\u001cWm\u001d\u0006\u0003eM\n1\u0001\\:q\u0015\t!T'A\u0003xK\u00064XM\u0003\u00027o\u0005!Q.\u001e7f\u0015\u0005A\u0014aA8sO\u000e\u00011c\u0001\u0001<\u0003B\u0011AhP\u0007\u0002{)\ta(A\u0003tG\u0006d\u0017-\u0003\u0002A{\t1\u0011I\\=SK\u001a\u0004\"AQ\"\u000e\u0003=J!\u0001R\u0018\u0003\u001dQ{w\u000e\\5oON+'O^5dK\u00069\u0001O]8kK\u000e$X#A$\u0011\u0005!sU\"A%\u000b\u0005\u0015S%BA&M\u0003\r\t\u0007/\u001b\u0006\u0003\u001bN\n\u0011\"\u001a=uK:\u001c\u0018n\u001c8\n\u0005=K%a\u0004)s_*,7\r^'fi\u0006$\u0017\r^1\u0002\u0011A\u0014xN[3di\u0002\n1A\u001e4t+\u0005\u0019\u0006C\u0001+Z\u001b\u0005)&B\u0001,X\u0003\u0019)G-\u001b;pe*\u0011\u0001lM\u0001\u0003mJJ!AW+\u0003#YK'\u000f^;bY\u001aKG.Z*zgR,W.\u0001\u0003wMN\u0004\u0013\u0001\u00059vE2L7\u000f[3s'\u0016\u0014h/[2f!\t\u0011e,\u0003\u0002`_\tYB)[1h]>\u001cH/[2t!V\u0014G.[:iKJ\u001cVM\u001d<jG\u0016\fa\u0003Z8dk6,g\u000e^*feZL7-\u001a$bGR|'/\u001f\t\u0003\u0005\nL!aY\u0018\u00035]+\u0017M^3U_>d\u0017N\\4TKJ4\u0018nY3GC\u000e$xN]=\u0002\u0011\u0015DXmY;u_J\u0004\"AZ7\u000e\u0003\u001dT!\u0001[5\u0002\u0015\r|gnY;se\u0016tGO\u0003\u0002kW\u0006!Q\u000f^5m\u0015\u0005a\u0017\u0001\u00026bm\u0006L!A\\4\u0003\u0011\u0015CXmY;u_J\fa\u0001P5oSRtDCB9sgR,h\u000f\u0005\u0002C\u0001!)Q\t\u0003a\u0001\u000f\")\u0011\u000b\u0003a\u0001'\")A\f\u0003a\u0001;\")\u0001\r\u0003a\u0001C\")A\r\u0003a\u0001K\u00061An\\4hKJ,\u0012!\u001f\t\u0003uvl\u0011a\u001f\u0006\u0003y^\nQa\u001d7gi)L!A`>\u0003\r1{wmZ3s\u0003\u001dawnZ4fe\u0002\n1\u0002\u001d:pU\u0016\u001cGoS5oIV\u0011\u0011Q\u0001\t\u0005\u0003\u000f\tY!\u0004\u0002\u0002\n)\u0011Q)M\u0005\u0005\u0003\u001b\tIAA\u0006Qe>TWm\u0019;LS:$\u0017a\u00049s_*,7\r^&j]\u0012|F%Z9\u0015\t\u0005M\u0011\u0011\u0004\t\u0004y\u0005U\u0011bAA\f{\t!QK\\5u\u0011%\tY\u0002DA\u0001\u0002\u0004\t)!A\u0002yIE\nA\u0002\u001d:pU\u0016\u001cGoS5oI\u0002\n\u0001c\u00183pGVlWM\u001c;TKJ4\u0018nY3\u0016\u0005\u0005\r\u0002c\u0001+\u0002&%\u0019\u0011qE+\u0003']+\u0017M^3U_>d\u0017N\\4TKJ4\u0018nY3\u0002!\r,8\u000f^8n-\u0006d\u0017\u000eZ1u_J\u001cXCAA\u0017!\u0015a\u0014qFA\u001a\u0013\r\t\t$\u0010\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0005\u0003k\ti$\u0004\u0002\u00028)!\u0011\u0011HA\u001e\u0003)1\u0018\r\\5eCRLwN\u001c\u0006\u0003\u001b*KA!a\u0010\u00028\tqq+Z1wKZ\u000bG.\u001b3bi>\u0014\u0018\u0001F2vgR|WNV1mS\u0012\fGo\u001c:t?\u0012*\u0017\u000f\u0006\u0003\u0002\u0014\u0005\u0015\u0003\"CA\u000e!\u0005\u0005\t\u0019AA\u0017\u0003E\u0019Wo\u001d;p[Z\u000bG.\u001b3bi>\u00148\u000fI\u0001\bS:$W\r_3e+\t\ti\u0005E\u0002=\u0003\u001fJ1!!\u0015>\u0005\u001d\u0011un\u001c7fC:\f1\"\u001b8eKb,Gm\u0018\u0013fcR!\u00111CA,\u0011%\tYbEA\u0001\u0002\u0004\ti%\u0001\u0005j]\u0012,\u00070\u001a3!Q\r!\u0012Q\f\t\u0004y\u0005}\u0013bAA1{\tAao\u001c7bi&dW-\u0001\u0006j]&$\u0018.\u00197ju\u0016$b!a\u0005\u0002h\u0005%\u0004bBA\u0001+\u0001\u0007\u0011Q\u0001\u0005\b\u0003W*\u0002\u0019AA7\u0003!)g/\u001a8u\u0005V\u001c\b\u0003BA8\u0003kj!!!\u001d\u000b\u0007\u0005M\u0014'A\u0003vi&d7/\u0003\u0003\u0002x\u0005E$\u0001E%oi\u0016\u0014h.\u00197Fm\u0016tGOQ;t\u0003]1\u0017N\u001c3D_J\u0014Xm\u001d9p]\u0012Lgn\u001a#x\r&dW\r\u0006\u0003\u0002~\u0005%\u0005#\u0002\u001f\u0002\u0000\u0005\r\u0015bAAA{\t1q\n\u001d;j_:\u00042\u0001VAC\u0013\r\t9)\u0016\u0002\f-&\u0014H/^1m\r&dW\rC\u0004\u0002\fZ\u0001\r!!$\u0002\u0007M$(\u000f\u0005\u0003\u0002\u0010\u0006ue\u0002BAI\u00033\u00032!a%>\u001b\t\t)JC\u0002\u0002\u0018f\na\u0001\u0010:p_Rt\u0014bAAN{\u00051\u0001K]3eK\u001aLA!a(\u0002\"\n11\u000b\u001e:j]\u001eT1!a'>\u0003I1\u0018\r\\5eCR,\u0017\t\u001c7FI&$xN]:\u0015\t\u0005M\u0011q\u0015\u0005\b\u0003S;\u0002\u0019AAG\u0003\u0019\u0011X-Y:p]\u0006!b/\u00197jI\u0006$X\rR3qK:$WM\\2jKN$b!a\u0005\u00020\u0006M\u0006bBAY1\u0001\u0007\u00111Q\u0001\u0003m\u001aDq!!+\u0019\u0001\u0004\ti)\u0001\u0005m_\u0006$G+\u001f9f)\u0011\tI,a2\u0011\u000bq\ny(a/\u0011\t\u0005u\u00161Y\u0007\u0003\u0003\u007fS1!!1X\u0003\t!8/\u0003\u0003\u0002F\u0006}&!C,fCZ,G+\u001f9f\u0011\u001d\tI-\u0007a\u0001\u0003\u001b\u000b!\u0002^=qKN#(/\u001b8h\u0003=!wnY;nK:$8+\u001a:wS\u000e,GCAA\u0012\u0003\u001dIg\u000e];u\u001f\u001a$b!a5\u0002\\\u0006}\u0007#\u0002\u001f\u0002\u0000\u0005U\u0007c\u0001+\u0002X&\u0019\u0011\u0011\\+\u0003\u00195\u000b\u0007\u000f]5oO&s\u0007/\u001e;\t\u000f\u0005u7\u00041\u0001\u0002\u000e\u0006\u0019QO]5\t\u000f\u0005\u00058\u00041\u0001\u0002\u000e\u0006I\u0011N\u001c9vi:\u000bW.Z\u0001\u0013G>tG/\u001a=u\u001b\u0016$\u0018\rZ1uC\u001a{'\u000f\u0006\u0003\u0002h\u0006m\bCBAu\u0003W\fy/D\u0001j\u0013\r\ti/\u001b\u0002\t\u001fB$\u0018n\u001c8bYB!\u0011\u0011_A|\u001b\t\t\u0019PC\u0002\u0002v*\u000b\u0001\"\\3uC\u0012\fG/Y\u0005\u0005\u0003s\f\u0019PA\bD_:$X\r\u001f;NKR\fG-\u0019;b\u0011\u001d\ti\u000e\ba\u0001\u0003\u001b\u000bAb\u001c9f]\u0012{7-^7f]R$BA!\u0001\u0003\bA\u0019AKa\u0001\n\u0007\t\u0015QKA\u000eXK\u00064X\rR8dk6,g\u000e\u001e+p_2LgnZ*feZL7-\u001a\u0005\b\u0003;l\u0002\u0019AAG)\u0019\u0011\tAa\u0003\u0003\u000e!9\u0011Q\u001c\u0010A\u0002\u00055\u0005b\u0002B\b=\u0001\u0007\u0011q]\u0001\r[\u0006L(-Z\"p]R,\u0007\u0010^\u0001\u001b_B,g\u000eR8dk6,g\u000e^,ji\"|W\u000f^\"p]R,\u0007\u0010\u001e\u000b\u0005\u0005\u0003\u0011)\u0002C\u0004\u0002^~\u0001\r!!$\u0015\u0011\t\u0005!\u0011\u0004B\u000e\u0005oAq!!8!\u0001\u0004\ti\tC\u0004\u0003\u001e\u0001\u0002\rAa\b\u0002\u000b%t\u0007/\u001e;\u0011\t\u0005E(\u0011E\u0005\u0005\u0005G\t\u0019PA\u0007J]B,H/T3uC\u0012\fG/\u0019\u0015\u0005\u00057\u00119\u0003\u0005\u0003\u0003*\tMRB\u0001B\u0016\u0015\u0011\u0011iCa\f\u0002\u0015\u0005tgn\u001c;bi&|gN\u0003\u0002\u00032\u0005)!.\u0019<bq&!!Q\u0007B\u0016\u0005!qU\u000f\u001c7bE2,\u0007b\u0002B\u001dA\u0001\u0007!1H\u0001\u000fKb\u0004Xm\u0019;fI>+H\u000f];u!\u0011\u0011iDa\u0012\u000e\u0005\t}\"\u0002BAa\u0005\u0003RAAa\u0011\u0003F\u00059Ao\\8mS:<'BA&X\u0013\u0011\u0011IEa\u0010\u0003\r\u0011;F+\u001f9fQ\u0011\u00119Da\n\u0002\u001b\rdwn]3E_\u000e,X.\u001a8u)\u0011\t\u0019B!\u0015\t\u000f\u0005u\u0017\u00051\u0001\u0002\u000e\u0006\tr/\u001b;i\u0019\u0006tw-^1hK2+g/\u001a7\u0015\t\u0005\r\"q\u000b\u0005\b\u00053\u0012\u0003\u0019AAG\u0003=!w\u000fT1oOV\fw-\u001a'fm\u0016d\u0017\u0001\u0004<bY&$\u0017\r^3GS2,GCBA\n\u0005?\u0012\t\u0007C\u0004\u00022\u000e\u0002\r!a!\t\u000f\u0005%6\u00051\u0001\u0002\u000e\u0006\tBO]5hO\u0016\u0014h+\u00197jI\u0006$\u0018n\u001c8\u0015\u0011\u0005M!q\rB6\u0005[BqA!\u001b%\u0001\u0004\ti)A\u0006e_\u000e,X.\u001a8u+JL\u0007bBAUI\u0001\u0007\u0011Q\u0012\u0005\n\u0005_\"\u0003\u0013!a\u0001\u0005c\n!c\u001c8WC2LG-\u0019;j_:4\u0015N\\5tQB)AHa\u001d\u0002\u0014%\u0019!QO\u001f\u0003\u0013\u0019+hn\u0019;j_:\u0004\u0014a\u0007;sS\u001e<WM\u001d,bY&$\u0017\r^5p]\u0012\"WMZ1vYR$3'\u0006\u0002\u0003|)\"!\u0011\u000fB?W\t\u0011y\b\u0005\u0003\u0003\u0002\n%UB\u0001BB\u0015\u0011\u0011)Ia\"\u0002\u0013Ut7\r[3dW\u0016$'b\u0001B\u0017{%!!1\u0012BB\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000ei>$\u0015.Y4o_N$\u0018nY:\u0015\t\tE%q\u0015\t\u0007\u0003S\u0014\u0019Ja&\n\u0007\tU\u0015N\u0001\u0003MSN$\b\u0003\u0002BM\u0005Gk!Aa'\u000b\t\tu%qT\u0001\u0006YN\u0004HG\u001b\u0006\u0004\u0005C;\u0014aB3dY&\u00048/Z\u0005\u0005\u0005K\u0013YJ\u0001\u0006ES\u0006<gn\\:uS\u000eDqA!+'\u0001\u0004\u0011Y+\u0001\u0005nKN\u001c\u0018mZ3t!\r!&QV\u0005\u0004\u0005_+&A\u0005,bY&$\u0017\r^5p]6+7o]1hKN\fQ\"];jG.4\u0015\u000e_3t\r>\u0014HC\u0004B[\u0005{\u0013yL!3\u0003N\nE'Q\u001b\t\u0006y\u0005=\"q\u0017\t\u0004)\ne\u0016b\u0001B^+\nA\u0011+^5dW\u001aK\u0007\u0010C\u0004\u0003j\u001d\u0002\r!!$\t\u000f\t\u0005w\u00051\u0001\u0003D\u0006Y1\u000f^1si>3gm]3u!\ra$QY\u0005\u0004\u0005\u000fl$aA%oi\"9!1Z\u0014A\u0002\t\r\u0017!C3oI>3gm]3u\u0011\u001d\u0011ym\na\u0001\u0003\u001b\u000bAa[5oI\"9!1[\u0014A\u0002\u00055\u0015\u0001C:fm\u0016\u0014\u0018\u000e^=\t\u0013\t=q\u0005%AA\u0002\u0005\u001d\u0018aF9vS\u000e\\g)\u001b=fg\u001a{'\u000f\n3fM\u0006,H\u000e\u001e\u00137+\t\u0011YN\u000b\u0003\u0002h\nu\u0014AD7bi\u000eDWm]'fgN\fw-\u001a\u000b\u000b\u0003\u001b\u0012\tOa;\u0003n\n=\bb\u0002BrS\u0001\u0007!Q]\u0001\u0002[B\u0019AKa:\n\u0007\t%XKA\tWC2LG-\u0019;j_:lUm]:bO\u0016DqAa4*\u0001\u0004\ti\tC\u0004\u0003B&\u0002\rAa1\t\u000f\t-\u0017\u00061\u0001\u0003D\u0006Aa/\u00197jI\u0006$X\r\u0006\u0004\u0003,\nU(q\u001f\u0005\b\u0005SR\u0003\u0019AAG\u0011%\u0011yA\u000bI\u0001\u0002\u0004\t9/\u0001\nwC2LG-\u0019;fI\u0011,g-Y;mi\u0012\u0012\u0014AF1qa2L8)^:u_64\u0016\r\\5eCRLwN\\:\u0015\u0011\t-&q`B\u0001\u0007\u000bAqA!\u001b-\u0001\u0004\ti\tC\u0004\u0004\u00041\u0002\rA!\u0001\u0002-\u0011|7-^7f]R$vn\u001c7j]\u001e\u001cVM\u001d<jG\u0016Dqaa\u0002-\u0001\u0004\u0019I!A\u0005usB,G*\u001a<fYB!\u0011QGB\u0006\u0013\u0011\u0019i!a\u000e\u0003'Y\u000bG.\u001b3bi&|g\u000eV=qK2+g/\u001a7\u0002\u0013\u001d,G\u000fT8hO\u0016\u0014H#A=")
public class DataWeaveToolingService
implements ToolingService {
    private WeaveToolingService _documentService;
    private final ProjectMetadata project;
    private final VirtualFileSystem vfs;
    private final DiagnosticsPublisherService publisherService;
    private WeaveToolingServiceFactory documentServiceFactory;
    private final Executor executor;
    private final Logger logger;
    private ProjectKind projectKind;
    private WeaveValidator[] customValidators;
    private volatile boolean indexed;
    private volatile boolean bitmap$0;

    public ProjectMetadata project() {
        return this.project;
    }

    public VirtualFileSystem vfs() {
        return this.vfs;
    }

    private Logger logger() {
        return this.logger;
    }

    public ProjectKind projectKind() {
        return this.projectKind;
    }

    public void projectKind_$eq(ProjectKind x$1) {
        this.projectKind = x$1;
    }

    private WeaveToolingService _documentService$lzycompute() {
        DataWeaveToolingService dataWeaveToolingService = this;
        synchronized (dataWeaveToolingService) {
            if (!this.bitmap$0) {
                this._documentService = this.documentServiceFactory.create();
                this.bitmap$0 = true;
            }
        }
        this.documentServiceFactory = null;
        return this._documentService;
    }

    private WeaveToolingService _documentService() {
        if (!this.bitmap$0) {
            return this._documentService$lzycompute();
        }
        return this._documentService;
    }

    private WeaveValidator[] customValidators() {
        return this.customValidators;
    }

    private void customValidators_$eq(WeaveValidator[] x$1) {
        this.customValidators = x$1;
    }

    public boolean indexed() {
        return this.indexed;
    }

    public void indexed_$eq(boolean x$1) {
        this.indexed = x$1;
    }

    @Override
    public void initialize(ProjectKind projectKind, InternalEventBus eventBus) {
        this.projectKind_$eq(projectKind);
        this.customValidators_$eq(projectKind.customValidators());
        eventBus.register(SettingsChangedEvent$.MODULE$.SETTINGS_CHANGED(), new OnSettingsChanged(this){
            private final /* synthetic */ DataWeaveToolingService $outer;

            public void onSettingsChanged(String[] modifiedSettingsName) {
                if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])modifiedSettingsName)).contains((Object)Settings$.MODULE$.LANGUAGE_LEVEL_PROP_NAME())) {
                    this.$outer.org$mule$weave$lsp$services$DataWeaveToolingService$$validateAllEditors("settingsChanged");
                    return;
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        eventBus.register(IndexingFinishedEvent$.MODULE$.INDEXING_FINISHED(), new OnIndexingFinished(this){
            private final /* synthetic */ DataWeaveToolingService $outer;

            public void onIndexingFinished(Enumeration.Value indexingType) {
                if (IndexingType$.MODULE$.Dependencies().equals((Object)indexingType)) {
                    this.$outer.indexed_$eq(true);
                    this.$outer.org$mule$weave$lsp$services$DataWeaveToolingService$$validateAllEditors("indexingFinishes");
                    return;
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        eventBus.register(ProjectStartedEvent$.MODULE$.PROJECT_STARTED(), new OnProjectStarted(this){
            private final /* synthetic */ DataWeaveToolingService $outer;

            public void onProjectStarted(ProjectMetadata projectMetadata) {
                this.$outer.org$mule$weave$lsp$services$DataWeaveToolingService$$validateAllEditors("projectStarted");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        eventBus.register(ProjectVirtualFileCreatedEvent$.MODULE$.VIRTUAL_FILE_CREATED(), new OnProjectVirtualFileCreatedEvent(this){
            private final /* synthetic */ DataWeaveToolingService $outer;

            public void onVirtualFileCreated(org.mule.weave.v2.editor.VirtualFile vf) {
                if (VFUtils$.MODULE$.isDWFile(vf.url())) {
                    this.$outer.validateFile(vf, "onCreated");
                    return;
                }
                this.$outer.org$mule$weave$lsp$services$DataWeaveToolingService$$findCorrespondingDwFile(vf.url()).foreach((Function1 & Serializable & scala.Serializable)dwVirtualFile -> {
                    $anon$4.$anonfun$onVirtualFileCreated$1(this, dwVirtualFile);
                    return BoxedUnit.UNIT;
                });
            }

            public static final /* synthetic */ void $anonfun$onVirtualFileCreated$1($anon$4 $this, org.mule.weave.v2.editor.VirtualFile dwVirtualFile) {
                $this.$outer.validateFile(dwVirtualFile, "onScenarioChanged");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$onVirtualFileCreated$1$adapted(org.mule.weave.lsp.services.DataWeaveToolingService$$anon$4 org.mule.weave.v2.editor.VirtualFile )}, serializedLambda);
            }
        });
        eventBus.register(ProjectVirtualFileChangedEvent$.MODULE$.VIRTUAL_FILE_CHANGED(), new OnProjectVirtualFileChangedEvent(this){
            private final /* synthetic */ DataWeaveToolingService $outer;

            public void onVirtualFileChanged(org.mule.weave.v2.editor.VirtualFile vf) {
                if (VFUtils$.MODULE$.isDWFile(vf.url())) {
                    this.$outer.validateFile(vf, "onChanged");
                    return;
                }
                this.$outer.org$mule$weave$lsp$services$DataWeaveToolingService$$findCorrespondingDwFile(vf.url()).foreach((Function1 & Serializable & scala.Serializable)dwVirtualFile -> {
                    $anon$5.$anonfun$onVirtualFileChanged$1(this, dwVirtualFile);
                    return BoxedUnit.UNIT;
                });
            }

            public static final /* synthetic */ void $anonfun$onVirtualFileChanged$1($anon$5 $this, org.mule.weave.v2.editor.VirtualFile dwVirtualFile) {
                $this.$outer.validateFile(dwVirtualFile, "onScenarioChanged");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$onVirtualFileChanged$1$adapted(org.mule.weave.lsp.services.DataWeaveToolingService$$anon$5 org.mule.weave.v2.editor.VirtualFile )}, serializedLambda);
            }
        });
        eventBus.register(ProjectVirtualFileDeletedEvent$.MODULE$.VIRTUAL_FILE_DELETED(), new OnProjectVirtualFileDeletedEvent(this){
            private final /* synthetic */ DataWeaveToolingService $outer;

            public void onVirtualFileDeleted(org.mule.weave.v2.editor.VirtualFile vf) {
                if (VFUtils$.MODULE$.isDWFile(vf.url())) {
                    this.$outer.org$mule$weave$lsp$services$DataWeaveToolingService$$validateDependencies(vf, "onDeleted");
                    return;
                }
                this.$outer.org$mule$weave$lsp$services$DataWeaveToolingService$$findCorrespondingDwFile(vf.url()).foreach((Function1 & Serializable & scala.Serializable)dwVirtualFile -> {
                    $anon$6.$anonfun$onVirtualFileDeleted$1(this, dwVirtualFile);
                    return BoxedUnit.UNIT;
                });
            }

            public static final /* synthetic */ void $anonfun$onVirtualFileDeleted$1($anon$6 $this, org.mule.weave.v2.editor.VirtualFile dwVirtualFile) {
                $this.$outer.validateFile(dwVirtualFile, "onScenarioChanged");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$onVirtualFileDeleted$1$adapted(org.mule.weave.lsp.services.DataWeaveToolingService$$anon$6 org.mule.weave.v2.editor.VirtualFile )}, serializedLambda);
            }
        });
    }

    public Option<org.mule.weave.v2.editor.VirtualFile> org$mule$weave$lsp$services$DataWeaveToolingService$$findCorrespondingDwFile(String str) {
        SampleDataComponent sampleDataManager = this.projectKind().sampleDataManager();
        return this.documentService().openEditors().find((Function1 & Serializable & scala.Serializable)oe -> BoxesRunTime.boxToBoolean((boolean)URLUtils$.MODULE$.isChildOfAny(str, (File[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])sampleDataManager.listScenarios(oe.file().getNameIdentifier()))).map((Function1 & Serializable & scala.Serializable)scenario -> scenario.file(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(File.class)))))).map((Function1 & Serializable & scala.Serializable)weaveDocToolingService -> weaveDocToolingService.file());
    }

    public void org$mule$weave$lsp$services$DataWeaveToolingService$$validateAllEditors(String reason) {
        Seq services = (Seq)this.documentService().openEditors().map((Function1 & Serializable & scala.Serializable)openEditor -> openEditor.file().url(), Seq$.MODULE$.canBuildFrom());
        this.documentService().invalidateAll();
        services.foreach((Function1 & Serializable & scala.Serializable)url -> {
            this.triggerValidation(url, reason, this.triggerValidation$default$3());
            return BoxedUnit.UNIT;
        });
    }

    public void org$mule$weave$lsp$services$DataWeaveToolingService$$validateDependencies(org.mule.weave.v2.editor.VirtualFile vf, String reason) {
        NameIdentifier fileLogicalName = vf.getNameIdentifier();
        Seq dependants = this.documentService().dependantsOf(fileLogicalName);
        this.logger().debug(new StringBuilder(25).append("Validate dependants of ").append(fileLogicalName).append(": ").append(dependants.mkString("[", ",", "]")).toString());
        dependants.foreach((Function1 & Serializable & scala.Serializable)ni -> {
            DataWeaveToolingService.$anonfun$validateDependencies$1(this, vf, reason, ni);
            return BoxedUnit.UNIT;
        });
    }

    public Option<WeaveType> loadType(String typeString) {
        return this.documentService().loadType(typeString);
    }

    private WeaveToolingService documentService() {
        return this._documentService();
    }

    public Option<MappingInput> inputOf(String uri, String inputName) {
        WeaveDocumentToolingService documentToolingService = this.openDocument(uri);
        return documentToolingService.inputOf(inputName);
    }

    public Optional<ContextMetadata> contextMetadataFor(String uri) {
        org.mule.weave.v2.editor.VirtualFile vf = this.vfs().file(uri);
        if (vf != null) {
            return this.projectKind().metadataProvider().metadata((VirtualFile)VirtualFileAdapter$.MODULE$.apply(vf));
        }
        return Optional.empty();
    }

    public WeaveDocumentToolingService openDocument(String uri) {
        Optional<ContextMetadata> maybeContext = this.contextMetadataFor(uri);
        if (maybeContext.isPresent()) {
            ContextMetadata context = maybeContext.get();
            return this.openDocument(uri, context.getInputMetadata(), context.getOutput());
        }
        return this.openDocumentWithoutContext(uri);
    }

    public WeaveDocumentToolingService openDocument(String uri, Optional<ContextMetadata> maybeContext) {
        if (maybeContext.isPresent()) {
            ContextMetadata context = maybeContext.get();
            return this.openDocument(uri, context.getInputMetadata(), context.getOutput());
        }
        return this.openDocument(uri);
    }

    public WeaveDocumentToolingService openDocumentWithoutContext(String uri) {
        return this._documentService().open(uri, ImplicitInput$.MODULE$.apply(), Option$.MODULE$.empty());
    }

    private WeaveDocumentToolingService openDocument(String uri, @Nullable InputMetadata input, @Nullable DWType expectedOutput) {
        None$ none$;
        if (expectedOutput != null) {
            if (!(expectedOutput instanceof WeaveType)) {
                throw new IllegalArgumentException(new StringBuilder(83).append("Unexpected `expectedOutput` instance, please, contact the extension owner. Actual: ").append(expectedOutput.getClass().getName()).toString());
            }
            none$ = new Some((Object)((WeaveType)expectedOutput));
        } else {
            none$ = None$.MODULE$;
        }
        None$ output = none$;
        return this._documentService().open(uri, WeaveTypeUtils$.MODULE$.toImplicitInput(input), (Option)output);
    }

    public void closeDocument(String uri) {
        this.documentService().close(uri);
    }

    public WeaveToolingService withLanguageLevel(String dwLanguageLevel) {
        return this._documentService().updateLanguageLevel(SVersion$.MODULE$.fromString(dwLanguageLevel));
    }

    public void validateFile(org.mule.weave.v2.editor.VirtualFile vf, String reason) {
        this.triggerValidation(vf.url(), reason, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.org$mule$weave$lsp$services$DataWeaveToolingService$$validateDependencies(vf, reason));
    }

    public void triggerValidation(String documentUri, String reason, Function0<BoxedUnit> onValidationFinish) {
        this.logger().debug(new StringBuilder(30).append("TriggerValidation of: ").append(documentUri).append(" reason ").append(reason).toString());
        CompletableFuture.runAsync(() -> {
            this.logger().debug(new StringBuilder(40).append("[").append(Thread.currentThread().getName()).append("][").append(this.getClass().getName()).append("] Init TriggerValidation of: ").append(documentUri).append(" reason ").append(reason).toString());
            this.withLanguageLevel(this.projectKind().dependencyManager().dwVersion());
            ValidationMessages messages = this.validate(documentUri, this.validate$default$2());
            List<Diagnostic> diagnostics = this.toDiagnostics(messages);
            this.logger().debug(new StringBuilder(58).append("[").append(Thread.currentThread().getName()).append("][").append(this.getClass().getName()).append("] TriggerValidation finished: ").append(documentUri).append(" reason ").append(reason).append(". Diagnostics: [").append(diagnostics).append("]").toString());
            $this.publisherService.publishDiagnostics(new PublishDiagnosticsParams(documentUri, diagnostics));
            onValidationFinish.apply$mcV$sp();
        }, this.executor);
    }

    public Function0<BoxedUnit> triggerValidation$default$3() {
        return (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {};
    }

    public List<Diagnostic> toDiagnostics(ValidationMessages messages) {
        ArrayList<Diagnostic> diagnostics = new ArrayList<Diagnostic>();
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])messages.errorMessage())).foreach((Function1 & Serializable & scala.Serializable)message -> BoxesRunTime.boxToBoolean((boolean)diagnostics.add(LSPConverters$.MODULE$.toDiagnostic(message, DiagnosticSeverity.Error))));
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])messages.warningMessage())).foreach((Function1 & Serializable & scala.Serializable)message -> BoxesRunTime.boxToBoolean((boolean)diagnostics.add(LSPConverters$.MODULE$.toDiagnostic(message, DiagnosticSeverity.Warning))));
        return diagnostics;
    }

    public QuickFix[] quickFixesFor(String documentUri, int startOffset, int endOffset, String kind, String severity, Optional<ContextMetadata> maybeContext) {
        ValidationMessages messages = this.validate(documentUri, maybeContext);
        String string = severity;
        String string2 = DiagnosticSeverity.Error.name();
        Option messageFound = !(string != null ? !string.equals(string2) : string2 != null) ? new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])messages.errorMessage())).find((Function1 & Serializable & scala.Serializable)m -> BoxesRunTime.boxToBoolean((boolean)this.matchesMessage(m, kind, startOffset, endOffset))) : new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])messages.warningMessage())).find((Function1 & Serializable & scala.Serializable)m -> BoxesRunTime.boxToBoolean((boolean)this.matchesMessage(m, kind, startOffset, endOffset)));
        return (QuickFix[])messageFound.map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.quickFix()).getOrElse((Function0 & Serializable & scala.Serializable)() -> (QuickFix[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(QuickFix.class)));
    }

    public Optional<ContextMetadata> quickFixesFor$default$6() {
        return Optional.empty();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean matchesMessage(ValidationMessage m, String kind, int startOffset, int endOffset) {
        if (m.location().startPosition().index() != startOffset) return false;
        if (m.location().endPosition().index() != endOffset) return false;
        String string = LSPConverters$.MODULE$.toDiagnosticKind(m);
        String string2 = kind;
        if (string != null) {
            if (!string.equals(string2)) return false;
            return true;
        }
        if (string2 == null) return true;
        return false;
    }

    public ValidationMessages validate(String documentUri, Optional<ContextMetadata> maybeContext) {
        WeaveDocumentToolingService documentToolingService;
        WeaveDocumentToolingService weaveDocumentToolingService;
        if (maybeContext.isPresent()) {
            ContextMetadata context = maybeContext.get();
            weaveDocumentToolingService = this.openDocument(documentUri, context.getInputMetadata(), context.getOutput());
        } else {
            Optional<ContextMetadata> maybeContext2 = this.contextMetadataFor(documentUri);
            if (maybeContext2.isPresent()) {
                ContextMetadata context = maybeContext2.get();
                weaveDocumentToolingService = this.openDocument(documentUri, context.getInputMetadata(), null);
            } else {
                weaveDocumentToolingService = documentToolingService = this.openDocumentWithoutContext(documentUri);
            }
        }
        ValidationMessages messages = this.indexed() && Settings$.MODULE$.isTypeLevel(this.project().settings()) ? documentToolingService.typeCheck().concat(this.applyCustomValidations(documentUri, documentToolingService, ValidationTypeLevel.SCOPE)).concat(this.applyCustomValidations(documentUri, documentToolingService, ValidationTypeLevel.TYPE)) : (this.indexed() && Settings$.MODULE$.isScopeLevel(this.project().settings()) ? documentToolingService.scopeCheck().concat(this.applyCustomValidations(documentUri, documentToolingService, ValidationTypeLevel.SCOPE)) : documentToolingService.parseCheck());
        return messages;
    }

    public Optional<ContextMetadata> validate$default$2() {
        return Optional.empty();
    }

    private ValidationMessages applyCustomValidations(String documentUri, WeaveDocumentToolingService documentToolingService, ValidationTypeLevel typeLevel) {
        return (ValidationMessages)documentToolingService.ast().map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.dwAstNode()).map((Function1 & Serializable & scala.Serializable)rootDwAstNode -> {
            TypePhaseCategory$ category = TypePhaseCategory$.MODULE$;
            ValidationTypeLevel validationTypeLevel = typeLevel;
            ValidationTypeLevel validationTypeLevel2 = ValidationTypeLevel.SCOPE;
            if (!(validationTypeLevel != null ? !validationTypeLevel.equals(validationTypeLevel2) : validationTypeLevel2 != null)) {
                category = ScopePhaseCategory$.MODULE$;
            }
            MessageValidationCollectorAdapter messageCollector = new MessageValidationCollectorAdapter((MessageCategory)category);
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.customValidators())).filter((Function1 & Serializable & scala.Serializable)v -> BoxesRunTime.boxToBoolean((boolean)v.appliesTo(documentUri))))).filter((Function1 & Serializable & scala.Serializable)v -> BoxesRunTime.boxToBoolean((boolean)DataWeaveToolingService.$anonfun$applyCustomValidations$4(typeLevel, v))))).foreach((Function1 & Serializable & scala.Serializable)v -> {
                DataWeaveToolingService.$anonfun$applyCustomValidations$5(this, documentUri, rootDwAstNode, messageCollector, v);
                return BoxedUnit.UNIT;
            });
            return messageCollector.getValidationMessages();
        }).getOrElse((Function0 & Serializable & scala.Serializable)() -> new ValidationMessages((ValidationMessage[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(ValidationMessage.class)), (ValidationMessage[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(ValidationMessage.class))));
    }

    public Logger getLogger() {
        return this.logger();
    }

    public static final /* synthetic */ void $anonfun$validateDependencies$1(DataWeaveToolingService $this, org.mule.weave.v2.editor.VirtualFile vf$1, String reason$2, NameIdentifier ni) {
        Option option = vf$1.fs().asResourceResolver().resolve(ni);
        if (option instanceof Some) {
            Some some = (Some)option;
            WeaveResource resource = (WeaveResource)some.value();
            $this.triggerValidation(resource.url(), new StringBuilder(20).append("dependantChanged ->").append(reason$2).append(" ").append(vf$1.url()).toString(), $this.triggerValidation$default$3());
            return;
        }
        if (None$.MODULE$.equals(option)) {
            $this.logger().warn(new StringBuilder(27).append("No resource found for file ").append(vf$1.url()).toString());
            return;
        }
        throw new MatchError((Object)option);
    }

    public static final /* synthetic */ boolean $anonfun$applyCustomValidations$4(ValidationTypeLevel typeLevel$1, WeaveValidator v) {
        ValidationTypeLevel validationTypeLevel = v.validationLevel();
        ValidationTypeLevel validationTypeLevel2 = typeLevel$1;
        return !(validationTypeLevel != null ? !validationTypeLevel.equals(validationTypeLevel2) : validationTypeLevel2 != null);
    }

    public static final /* synthetic */ void $anonfun$applyCustomValidations$5(DataWeaveToolingService $this, String documentUri$2, DWAstNode rootDwAstNode$1, MessageValidationCollectorAdapter messageCollector$1, WeaveValidator v) {
        try {
            v.validate(new DocumentNode(documentUri$2, rootDwAstNode$1), (MessageValidationCollector)messageCollector$1, new MessageBuilderFactory(null){

                public MessageBuilder createMessageBuilder() {
                    return new DefaultMessageBuilder();
                }
            });
        }
        catch (Exception e) {
            $this.getLogger().error(new StringBuilder(53).append("There was an error while executing custom validator: ").append(v.getClass()).toString(), (Throwable)e);
        }
    }

    public DataWeaveToolingService(ProjectMetadata project, VirtualFileSystem vfs, DiagnosticsPublisherService publisherService, WeaveToolingServiceFactory documentServiceFactory, Executor executor) {
        this.project = project;
        this.vfs = vfs;
        this.publisherService = publisherService;
        this.documentServiceFactory = documentServiceFactory;
        this.executor = executor;
        ToolingService.$init$(this);
        this.logger = LoggerFactory.getLogger(this.getClass());
        this.indexed = false;
    }
}

