/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.lsp.services;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.eclipse.lsp4j.DidChangeConfigurationParams;
import org.eclipse.lsp4j.DidChangeWatchedFilesParams;
import org.eclipse.lsp4j.DidChangeWorkspaceFoldersParams;
import org.eclipse.lsp4j.ExecuteCommandParams;
import org.eclipse.lsp4j.SymbolInformation;
import org.eclipse.lsp4j.WorkspaceSymbolParams;
import org.eclipse.lsp4j.services.WorkspaceService;
import org.mule.weave.extension.api.extension.command.WeaveCommand;
import org.mule.weave.lsp.commands.CommandManagerService;
import org.mule.weave.lsp.commands.Commands$;
import org.mule.weave.lsp.commands.InternalWeaveCommand;
import org.mule.weave.lsp.extension.protocol.DataWeaveProtocolClient;
import org.mule.weave.lsp.extension.protocol.SetContextParams;
import org.mule.weave.lsp.extension.protocol.SetContextValue;
import org.mule.weave.lsp.jobs.JobManagerService;
import org.mule.weave.lsp.jobs.Status;
import org.mule.weave.lsp.jobs.Task;
import org.mule.weave.lsp.project.ProjectKind;
import org.mule.weave.lsp.services.WorkspaceServiceContributor;
import org.mule.weave.lsp.services.WorkspaceServiceContributorRegistry;
import org.mule.weave.lsp.services.WorkspaceServiceListener;
import org.mule.weave.lsp.services.events.DocumentChangedEvent$;
import org.mule.weave.lsp.services.events.DocumentFocusChangedEvent$;
import org.mule.weave.lsp.services.events.DocumentOpenedEvent$;
import org.mule.weave.lsp.services.events.OnDocumentChanged;
import org.mule.weave.lsp.services.events.OnDocumentFocused;
import org.mule.weave.lsp.services.events.OnDocumentOpened;
import org.mule.weave.v2.editor.VirtualFile;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Iterable$;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.concurrent.TrieMap;
import scala.collection.concurrent.TrieMap$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

@ScalaSignature(bytes="\u0006\u0001\u0005ug\u0001\u0002\u000e\u001c\u0001\u0019B\u0001\u0002\u0010\u0001\u0003\u0002\u0003\u0006I!\u0010\u0005\t\u000b\u0002\u0011\t\u0011)A\u0005\r\"AA\n\u0001B\u0001B\u0003%Q\nC\u0003T\u0001\u0011\u0005A\u000bC\u0004Z\u0001\t\u0007I\u0011\u0002.\t\r9\u0004\u0001\u0015!\u0003\\\u0011\u001dy\u0007A1A\u0005\nADaA\u001f\u0001!\u0002\u0013\t\bbB>\u0001\u0005\u0004%I\u0001 \u0005\b\u0003\u000f\u0001\u0001\u0015!\u0003~\u0011%\tI\u0001\u0001b\u0001\n\u0013\tY\u0001\u0003\u0005\u0002\u0014\u0001\u0001\u000b\u0011BA\u0007\u0011%\t)\u0002\u0001b\u0001\n\u0013\t9\u0002\u0003\u0005\u0002 \u0001\u0001\u000b\u0011BA\r\u0011\u001d\t\t\u0003\u0001C!\u0003GAq!!\r\u0001\t\u0003\t\u0019\u0004C\u0004\u0002>\u0001!\t!a\u0010\t\u000f\u0005\r\u0003\u0001\"\u0003\u0002F!9\u0011\u0011\n\u0001\u0005\n\u0005-\u0003bBA(\u0001\u0011%\u0011\u0011\u000b\u0005\b\u0003O\u0002A\u0011IA5\u0011\u001d\t)\u000b\u0001C!\u0003OCq!!-\u0001\t\u0003\n\u0019\fC\u0004\u0002F\u0002!\t%a2\t\u000f\u0005E\u0007\u0001\"\u0011\u0002T\nIB)\u0019;b/\u0016\fg/Z,pe.\u001c\b/Y2f'\u0016\u0014h/[2f\u0015\taR$\u0001\u0005tKJ4\u0018nY3t\u0015\tqr$A\u0002mgBT!\u0001I\u0011\u0002\u000b],\u0017M^3\u000b\u0005\t\u001a\u0013\u0001B7vY\u0016T\u0011\u0001J\u0001\u0004_J<7\u0001A\n\u0005\u0001\u001dz\u0003\b\u0005\u0002)[5\t\u0011F\u0003\u0002+W\u0005!A.\u00198h\u0015\u0005a\u0013\u0001\u00026bm\u0006L!AL\u0015\u0003\r=\u0013'.Z2u!\t\u0001d'D\u00012\u0015\ta\"G\u0003\u00024i\u0005)An\u001d95U*\u0011QgI\u0001\bK\u000ed\u0017\u000e]:f\u0013\t9\u0014G\u0001\tX_J\\7\u000f]1dKN+'O^5dKB\u0011\u0011HO\u0007\u00027%\u00111h\u0007\u0002$/>\u00148n\u001d9bG\u0016\u001cVM\u001d<jG\u0016\u001cuN\u001c;sS\n,Ho\u001c:SK\u001eL7\u000f\u001e:z\u0003M9X-\u0019<f!J|Go\\2pY\u000ec\u0017.\u001a8u!\tq4)D\u0001@\u0015\t\u0001\u0015)\u0001\u0005qe>$xnY8m\u0015\t\u0011U$A\u0005fqR,gn]5p]&\u0011Ai\u0010\u0002\u0018\t\u0006$\u0018mV3bm\u0016\u0004&o\u001c;pG>d7\t\\5f]R\f\u0011C[8c\u001b\u0006t\u0017mZ3s'\u0016\u0014h/[2f!\t9%*D\u0001I\u0015\tIU$\u0001\u0003k_\n\u001c\u0018BA&I\u0005EQuNY'b]\u0006<WM]*feZL7-Z\u0001\u000fG>lW.\u00198e\u001b\u0006t\u0017mZ3s!\tq\u0015+D\u0001P\u0015\t\u0001V$\u0001\u0005d_6l\u0017M\u001c3t\u0013\t\u0011vJA\u000bD_6l\u0017M\u001c3NC:\fw-\u001a:TKJ4\u0018nY3\u0002\rqJg.\u001b;?)\u0011)fk\u0016-\u0011\u0005e\u0002\u0001\"\u0002\u001f\u0005\u0001\u0004i\u0004\"B#\u0005\u0001\u00041\u0005\"\u0002'\u0005\u0001\u0004i\u0015\u0001\b9s_*,7\r^,pe.\u001c\b/Y2f\u0007>tGO]5ckR|'o]\u000b\u00027B!AlY3l\u001b\u0005i&B\u00010`\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0003A\u0006\f!bY8mY\u0016\u001cG/[8o\u0015\u0005\u0011\u0017!B:dC2\f\u0017B\u00013^\u0005\u001d!&/[3NCB\u0004\"AZ5\u000e\u0003\u001dT!\u0001[\u000f\u0002\u000fA\u0014xN[3di&\u0011!n\u001a\u0002\f!J|'.Z2u\u0017&tG\r\u0005\u0002:Y&\u0011Qn\u0007\u0002\u001c/>\u00148n\u001d9bG\u0016\u001cVM\u001d<jG\u0016\u001cuN\u001c;sS\n,Ho\u001c:\u0002;A\u0014xN[3di^{'o[:qC\u000e,7i\u001c8ue&\u0014W\u000f^8sg\u0002\n\u0011d^8sWN\u0004\u0018mY3TKJ4\u0018nY3MSN$XM\\3sgV\t\u0011\u000fE\u0002sk^l\u0011a\u001d\u0006\u0003i~\u000bq!\\;uC\ndW-\u0003\u0002wg\n1!)\u001e4gKJ\u0004\"!\u000f=\n\u0005e\\\"\u0001G,pe.\u001c\b/Y2f'\u0016\u0014h/[2f\u0019&\u001cH/\u001a8fe\u0006Qro\u001c:lgB\f7-Z*feZL7-\u001a'jgR,g.\u001a:tA\u0005\trN\u001c#pGVlWM\u001c;DQ\u0006tw-\u001a3\u0016\u0003u\u00042A`A\u0002\u001b\u0005y(bAA\u00017\u00051QM^3oiNL1!!\u0002\u0000\u0005Eye\u000eR8dk6,g\u000e^\"iC:<W\rZ\u0001\u0013_:$unY;nK:$8\t[1oO\u0016$\u0007%\u0001\tp]\u0012{7-^7f]R|\u0005/\u001a8fIV\u0011\u0011Q\u0002\t\u0004}\u0006=\u0011bAA\t\u007f\n\u0001rJ\u001c#pGVlWM\u001c;Pa\u0016tW\rZ\u0001\u0012_:$unY;nK:$x\n]3oK\u0012\u0004\u0013!E8o\t>\u001cW/\\3oi\u001a{7-^:fIV\u0011\u0011\u0011\u0004\t\u0004}\u0006m\u0011bAA\u000f\u007f\n\trJ\u001c#pGVlWM\u001c;G_\u000e,8/\u001a3\u0002%=tGi\\2v[\u0016tGOR8dkN,G\rI\u0001\u001cC\u0012$wk\u001c:lgB\f7-Z*feZL7-\u001a'jgR,g.\u001a:\u0015\t\u0005\u0015\u0012Q\u0006\t\u0005\u0003O\tI#D\u0001b\u0013\r\tY#\u0019\u0002\u0005+:LG\u000f\u0003\u0004\u00020=\u0001\ra^\u0001\u0019o>\u00148n\u001d9bG\u0016\u001cVM\u001d<jG\u0016d\u0015n\u001d;f]\u0016\u0014\u0018\u0001F8o!J|'.Z2u\u0017&tGm\u0011:fCR,G\r\u0006\u0004\u0002&\u0005U\u0012\u0011\b\u0005\u0007\u0003o\u0001\u0002\u0019A3\u0002\u0017A\u0014xN[3di.Kg\u000e\u001a\u0005\u0007\u0003w\u0001\u0002\u0019A6\u00027]|'o[:qC\u000e,7+\u001a:wS\u000e,7i\u001c8ue&\u0014W\u000f^8s\u0003Qyg\u000e\u0015:pU\u0016\u001cGoS5oIJ+Wn\u001c<fIR!\u0011QEA!\u0011\u0019\t9$\u0005a\u0001K\u0006I\"/Z4jgR,'\u000fR8dk6,g\u000e\u001e'jgR,g.\u001a:t)\u0011\t)#a\u0012\t\r\u0005]\"\u00031\u0001f\u0003m)hN]3hSN$XM\u001d#pGVlWM\u001c;MSN$XM\\3sgR!\u0011QEA'\u0011\u0019\t9d\u0005a\u0001K\u0006!bn\u001c;jMf\u001cuN\u001c;fqR\u001c\u0005.\u00198hK\u0012$B!!\n\u0002T!9\u0011Q\u000b\u000bA\u0002\u0005]\u0013A\u0001<g!\u0011\tI&a\u0019\u000e\u0005\u0005m#\u0002BA/\u0003?\na!\u001a3ji>\u0014(bAA1?\u0005\u0011aOM\u0005\u0005\u0003K\nYFA\u0006WSJ$X/\u00197GS2,\u0017AB:z[\n|G\u000e\u0006\u0003\u0002l\u0005m\u0005CBA7\u0003k\nI(\u0004\u0002\u0002p)\u0019a,!\u001d\u000b\u0007\u0005M4&\u0001\u0003vi&d\u0017\u0002BA<\u0003_\u0012\u0011cQ8na2,G/\u00192mK\u001a+H/\u001e:fa\u0011\tY(a\"\u0011\r\u0005u\u0014qPAB\u001b\t\t\t(\u0003\u0003\u0002\u0002\u0006E$\u0001\u0002'jgR\u0004B!!\"\u0002\b2\u0001AaCAE+\u0005\u0005\t\u0011!B\u0001\u0003\u0017\u00131a\u0018\u00132#\u0011\ti)a%\u0011\t\u0005\u001d\u0012qR\u0005\u0004\u0003#\u000b'a\u0002(pi\"Lgn\u001a\t\u0005\u0003+\u000b9*D\u00013\u0013\r\tIJ\r\u0002\u0012'fl'm\u001c7J]\u001a|'/\\1uS>t\u0007bBAO+\u0001\u0007\u0011qT\u0001\u0007a\u0006\u0014\u0018-\\:\u0011\t\u0005U\u0015\u0011U\u0005\u0004\u0003G\u0013$!F,pe.\u001c\b/Y2f'fl'm\u001c7QCJ\fWn]\u0001\u0017I&$7\t[1oO\u0016\u001cuN\u001c4jOV\u0014\u0018\r^5p]R!\u0011QEAU\u0011\u001d\tiJ\u0006a\u0001\u0003W\u0003B!!&\u0002.&\u0019\u0011q\u0016\u001a\u00039\u0011KGm\u00115b]\u001e,7i\u001c8gS\u001e,(/\u0019;j_:\u0004\u0016M]1ng\u0006qQ\r_3dkR,7i\\7nC:$G\u0003BA[\u0003{\u0003b!!\u001c\u0002v\u0005]\u0006\u0003BA\u0014\u0003sK1!a/b\u0005\u0019\te.\u001f*fM\"9\u0011QT\fA\u0002\u0005}\u0006\u0003BAK\u0003\u0003L1!a13\u0005Q)\u00050Z2vi\u0016\u001cu.\\7b]\u0012\u0004\u0016M]1ng\u0006IB-\u001b3DQ\u0006tw-Z,pe.\u001c\b/Y2f\r>dG-\u001a:t)\u0011\t)#!3\t\u000f\u0005u\u0005\u00041\u0001\u0002LB!\u0011QSAg\u0013\r\tyM\r\u0002 \t&$7\t[1oO\u0016<vN]6ta\u0006\u001cWMR8mI\u0016\u00148\u000fU1sC6\u001c\u0018!\u00063jI\u000eC\u0017M\\4f/\u0006$8\r[3e\r&dWm\u001d\u000b\u0005\u0003K\t)\u000eC\u0004\u0002\u001ef\u0001\r!a6\u0011\t\u0005U\u0015\u0011\\\u0005\u0004\u00037\u0014$a\u0007#jI\u000eC\u0017M\\4f/\u0006$8\r[3e\r&dWm\u001d)be\u0006l7\u000f")
public class DataWeaveWorkspaceService
implements WorkspaceService,
WorkspaceServiceContributorRegistry {
    private final DataWeaveProtocolClient weaveProtocolClient;
    private final JobManagerService jobManagerService;
    private final CommandManagerService commandManager;
    private final TrieMap<ProjectKind, WorkspaceServiceContributor> projectWorkspaceContributors;
    private final Buffer<WorkspaceServiceListener> workspaceServiceListeners;
    private final OnDocumentChanged onDocumentChanged;
    private final OnDocumentOpened onDocumentOpened;
    private final OnDocumentFocused onDocumentFocused;

    private TrieMap<ProjectKind, WorkspaceServiceContributor> projectWorkspaceContributors() {
        return this.projectWorkspaceContributors;
    }

    private Buffer<WorkspaceServiceListener> workspaceServiceListeners() {
        return this.workspaceServiceListeners;
    }

    private OnDocumentChanged onDocumentChanged() {
        return this.onDocumentChanged;
    }

    private OnDocumentOpened onDocumentOpened() {
        return this.onDocumentOpened;
    }

    private OnDocumentFocused onDocumentFocused() {
        return this.onDocumentFocused;
    }

    @Override
    public void addWorkspaceServiceListener(WorkspaceServiceListener workspaceServiceListener) {
        this.workspaceServiceListeners().$plus$eq((Object)workspaceServiceListener);
    }

    @Override
    public void onProjectKindCreated(ProjectKind projectKind, WorkspaceServiceContributor workspaceServiceContributor) {
        Option option = this.projectWorkspaceContributors().putIfAbsent((Object)projectKind, (Object)workspaceServiceContributor);
        if (option instanceof Some) {
            return;
        }
        if (None$.MODULE$.equals(option)) {
            this.registerDocumentListeners(projectKind);
            return;
        }
        throw new MatchError((Object)option);
    }

    @Override
    public void onProjectKindRemoved(ProjectKind projectKind) {
        Option option = this.projectWorkspaceContributors().remove((Object)projectKind);
        if (option instanceof Some) {
            this.unregisterDocumentListeners(projectKind);
            return;
        }
        if (None$.MODULE$.equals(option)) {
            return;
        }
        throw new MatchError((Object)option);
    }

    private void registerDocumentListeners(ProjectKind projectKind) {
        projectKind.eventBus().register(DocumentChangedEvent$.MODULE$.DOCUMENT_CHANGED(), this.onDocumentChanged());
        projectKind.eventBus().register(DocumentOpenedEvent$.MODULE$.DOCUMENT_OPENED(), this.onDocumentOpened());
        projectKind.eventBus().register(DocumentFocusChangedEvent$.MODULE$.DOCUMENT_FOCUS_CHANGED(), this.onDocumentFocused());
    }

    private void unregisterDocumentListeners(ProjectKind projectKind) {
        projectKind.eventBus().unRegister(DocumentChangedEvent$.MODULE$.DOCUMENT_CHANGED(), this.onDocumentChanged());
        projectKind.eventBus().unRegister(DocumentOpenedEvent$.MODULE$.DOCUMENT_OPENED(), this.onDocumentOpened());
        projectKind.eventBus().unRegister(DocumentFocusChangedEvent$.MODULE$.DOCUMENT_FOCUS_CHANGED(), this.onDocumentFocused());
    }

    private void notifyContextChanged(VirtualFile vf) {
        SetContextParams params = new SetContextParams((List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)this.commandManager.commands().map((Function1 & Serializable & scala.Serializable)command -> {
            boolean bl;
            WeaveCommand weaveCommand = command;
            if (weaveCommand instanceof InternalWeaveCommand) {
                InternalWeaveCommand internalWeaveCommand = (InternalWeaveCommand)weaveCommand;
                bl = internalWeaveCommand.enabled(vf.url());
            } else {
                bl = true;
            }
            boolean isEnabled = bl;
            return new SetContextValue(new StringBuilder(0).append(command.commandId()).append(Commands$.MODULE$.COMMAND_ENABLED_SUFFIX()).toString(), isEnabled, vf.url());
        }, Seq$.MODULE$.canBuildFrom())).asJava());
        this.weaveProtocolClient.setContext(params);
    }

    public CompletableFuture<List<? extends SymbolInformation>> symbol(WorkspaceSymbolParams params) {
        CompletableFuture[] futures = (CompletableFuture[])((TraversableOnce)this.projectWorkspaceContributors().values().map((Function1 & Serializable & scala.Serializable)projectWorkspaceContributor -> projectWorkspaceContributor.symbol(params), Iterable$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(CompletableFuture.class));
        CompletableFuture<Void> allFutures = CompletableFuture.allOf(futures);
        return allFutures.thenApply(x$1 -> {
            ArrayList symbolsInformation = new ArrayList();
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])futures)).foreach((Function1 & Serializable & scala.Serializable)future -> BoxesRunTime.boxToBoolean((boolean)symbolsInformation.addAll((Collection)future.join())));
            return symbolsInformation;
        });
    }

    public void didChangeConfiguration(DidChangeConfigurationParams params) {
        this.workspaceServiceListeners().foreach((Function1 & Serializable & scala.Serializable)listener -> {
            listener.didChangeConfiguration(params);
            return BoxedUnit.UNIT;
        });
        this.projectWorkspaceContributors().values().foreach((Function1 & Serializable & scala.Serializable)projectWorkspaceContributor -> {
            projectWorkspaceContributor.didChangeConfiguration(params);
            return BoxedUnit.UNIT;
        });
    }

    public CompletableFuture<Object> executeCommand(ExecuteCommandParams params) {
        return CompletableFuture.supplyAsync(() -> $this.commandManager.commandBy(params.getCommand()).map((Function1 & Serializable & scala.Serializable)c -> {
            ObjectRef result = ObjectRef.create(null);
            $this.jobManagerService.execute(new Task(null, result, (WeaveCommand)c, params){
                private final ObjectRef result$1;
                private final WeaveCommand c$1;
                private final ExecuteCommandParams params$3;

                public void run(Status cancelable) {
                    this.result$1.elem = this.c$1.execute(this.params$3);
                }
                {
                    this.result$1 = result$1;
                    this.c$1 = c$1;
                    this.params$3 = params$3;
                }
            }, new StringBuilder(17).append("Running command: ").append(c.name()).toString(), String.valueOf(c.description(params)));
            return result.elem;
        }).orNull(Predef$.MODULE$.$conforms()));
    }

    public void didChangeWorkspaceFolders(DidChangeWorkspaceFoldersParams params) {
        this.workspaceServiceListeners().foreach((Function1 & Serializable & scala.Serializable)listener -> {
            listener.didChangeWorkspaceFolders(params);
            return BoxedUnit.UNIT;
        });
    }

    public void didChangeWatchedFiles(DidChangeWatchedFilesParams params) {
        this.projectWorkspaceContributors().values().foreach((Function1 & Serializable & scala.Serializable)projectWorkspaceContributor -> {
            projectWorkspaceContributor.didChangeWatchedFiles(params);
            return BoxedUnit.UNIT;
        });
    }

    public DataWeaveWorkspaceService(DataWeaveProtocolClient weaveProtocolClient, JobManagerService jobManagerService, CommandManagerService commandManager) {
        this.weaveProtocolClient = weaveProtocolClient;
        this.jobManagerService = jobManagerService;
        this.commandManager = commandManager;
        this.projectWorkspaceContributors = (TrieMap)TrieMap$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.workspaceServiceListeners = (Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.onDocumentChanged = vf -> this.notifyContextChanged(vf);
        this.onDocumentOpened = vf -> this.notifyContextChanged(vf);
        this.onDocumentFocused = vf -> this.notifyContextChanged(vf);
    }
}

