/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.lsp.utils;

import java.io.File;
import java.io.Serializable;
import org.mule.weave.extension.api.component.structure.WeaveModuleStructure;
import org.mule.weave.extension.api.component.structure.WeaveProjectStructure;
import org.mule.weave.extension.api.component.structure.WeaveRootKind;
import org.mule.weave.lsp.project.components.ProjectStructureHelper$;
import org.mule.weave.v2.parser.ast.variables.NameIdentifier;
import org.mule.weave.v2.parser.ast.variables.NameIdentifier$;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class WeaveDirectoryUtils$ {
    public static WeaveDirectoryUtils$ MODULE$;
    private boolean verbose;
    private final String DWTest_FOLDER;
    private final String SAMPLES_FOLDER;
    private final String INPUTS_FOLDER;
    private final String DW_TEST_RESOURCES;
    private final Logger logger;

    static {
        new WeaveDirectoryUtils$();
    }

    public boolean verbose() {
        return this.verbose;
    }

    public void verbose_$eq(boolean x$1) {
        this.verbose = x$1;
    }

    public String DWTest_FOLDER() {
        return this.DWTest_FOLDER;
    }

    public String SAMPLES_FOLDER() {
        return this.SAMPLES_FOLDER;
    }

    public String INPUTS_FOLDER() {
        return this.INPUTS_FOLDER;
    }

    public String DW_TEST_RESOURCES() {
        return this.DW_TEST_RESOURCES;
    }

    private Logger logger() {
        return this.logger;
    }

    public File getDWHome() {
        File defaultDWHomeDir;
        File homeUser = this.getUserHome();
        String weavehome = System.getenv("DW_HOME");
        if (weavehome != null) {
            File home = new File(weavehome);
            return home;
        }
        if (this.verbose()) {
            this.logger().info("'DW_HOME' env not set, trying home directory");
        }
        Object object = !(defaultDWHomeDir = new File(homeUser, ".dw")).exists() ? BoxesRunTime.boxToBoolean((boolean)defaultDWHomeDir.mkdirs()) : BoxedUnit.UNIT;
        return defaultDWHomeDir;
    }

    public File inputsFolder(File scenario) {
        return new File(scenario, this.INPUTS_FOLDER());
    }

    public File getUserHome() {
        return new File(System.getProperty("user.home"));
    }

    public File getWorkingHome() {
        String weavehome = System.getenv("DW_WORKING_PATH");
        if (weavehome != null) {
            File home = new File(weavehome);
            return home;
        }
        return new File(this.getDWHome(), "tmp");
    }

    public File getCacheHome() {
        String weavehome = System.getenv("DW_CACHE_PATH");
        if (weavehome != null) {
            File home = new File(weavehome);
            return home;
        }
        return new File(this.getDWHome(), "cache");
    }

    public File getLibPathHome() {
        String weavehome = System.getenv("DW_LIB_PATH");
        if (weavehome != null) {
            File home = new File(weavehome);
            return home;
        }
        return new File(this.getDWHome(), "libs");
    }

    public String sanitizeFilename(String inputName) {
        return inputName.replaceAll("[^a-zA-Z0-9-_\\.]", "_");
    }

    public String toFolderName(NameIdentifier nameIdentifier) {
        String[] parts = nameIdentifier.name().split(NameIdentifier$.MODULE$.SEPARATOR());
        String[] sanitizedParts = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])parts)).map((Function1 & Serializable & scala.Serializable)inputName -> MODULE$.sanitizeFilename((String)inputName), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        String folder = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])sanitizedParts)).mkString("/");
        return folder;
    }

    public File[] wtfUnitTestFolder(WeaveProjectStructure projectStructure) {
        return (File[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])projectStructure.modules())).flatMap((Function1 & Serializable & scala.Serializable)m -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])m.roots())).flatMap((Function1 & Serializable & scala.Serializable)root -> {
            WeaveRootKind weaveRootKind = root.kind();
            WeaveRootKind weaveRootKind2 = WeaveRootKind.TEST;
            if (!(weaveRootKind != null ? !weaveRootKind.equals(weaveRootKind2) : weaveRootKind2 != null)) {
                return Option$.MODULE$.option2Iterable(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])root.sources())).find((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)WeaveDirectoryUtils$.$anonfun$wtfUnitTestFolder$3(f))));
            }
            return Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(File.class))))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(File.class)));
    }

    public File[] wtfResourcesTestFolder(WeaveProjectStructure projectStructure) {
        return (File[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])projectStructure.modules())).flatMap((Function1 & Serializable & scala.Serializable)module -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])WeaveDirectoryUtils$.MODULE$.moduleResourcesTestFolder(module))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(File.class)));
    }

    public File[] wtfResourcesTestFolderForFile(WeaveProjectStructure projectStructure, String uri) {
        Option<WeaveModuleStructure> maybeModule = ProjectStructureHelper$.MODULE$.moduleOfFile(projectStructure, uri);
        return (File[])maybeModule.map((Function1 & Serializable & scala.Serializable)module -> MODULE$.moduleResourcesTestFolder((WeaveModuleStructure)module)).getOrElse((Function0 & Serializable & scala.Serializable)() -> (File[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(File.class)));
    }

    private File[] moduleResourcesTestFolder(WeaveModuleStructure module) {
        return (File[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])module.roots())).flatMap((Function1 & Serializable & scala.Serializable)root -> {
            WeaveRootKind weaveRootKind = root.kind();
            WeaveRootKind weaveRootKind2 = WeaveRootKind.TEST;
            if (!(weaveRootKind != null ? !weaveRootKind.equals(weaveRootKind2) : weaveRootKind2 != null)) {
                return Option$.MODULE$.option2Iterable(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])root.resources())).find((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)WeaveDirectoryUtils$.$anonfun$moduleResourcesTestFolder$2(f))));
            }
            return Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(File.class)));
    }

    public File[] wtfUnitDefaultTestSourceFolder(WeaveProjectStructure projectStructure) {
        return (File[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])projectStructure.modules())).flatMap((Function1 & Serializable & scala.Serializable)m -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])m.roots())).flatMap((Function1 & Serializable & scala.Serializable)root -> {
            WeaveRootKind weaveRootKind = root.kind();
            WeaveRootKind weaveRootKind2 = WeaveRootKind.TEST;
            if (!(weaveRootKind != null ? !weaveRootKind.equals(weaveRootKind2) : weaveRootKind2 != null)) {
                return Option$.MODULE$.option2Iterable((Option)new Some((Object)root.defaultSourceFolder()));
            }
            return Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(File.class))))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(File.class)));
    }

    public static final /* synthetic */ boolean $anonfun$wtfUnitTestFolder$3(File f) {
        return f.getName().equals(MODULE$.DWTest_FOLDER());
    }

    public static final /* synthetic */ boolean $anonfun$moduleResourcesTestFolder$2(File f) {
        return f.getName().equals(MODULE$.DW_TEST_RESOURCES());
    }

    private WeaveDirectoryUtils$() {
        MODULE$ = this;
        this.verbose = false;
        this.DWTest_FOLDER = "dw";
        this.SAMPLES_FOLDER = "samples";
        this.INPUTS_FOLDER = "inputs";
        this.DW_TEST_RESOURCES = "resources";
        this.logger = LoggerFactory.getLogger(this.getClass());
    }
}

