package org.mule.weave.lsp.project.events

import org.mule.weave.extension.api.component.dependency.DependencyArtifact
import org.mule.weave.lsp.utils.InternalEvent
import org.mule.weave.lsp.utils.InternalEventHandler
import org.mule.weave.lsp.utils.InternalEventType

class DependencyArtifactRemovedEvent(artifacts: Array[DependencyArtifact]) extends InternalEvent {

  override type T = OnDependencyArtifactRemoved

  override def getType: InternalEventType[OnDependencyArtifactRemoved] = {
    DependencyArtifactRemovedEvent.ARTIFACT_REMOVED
  }

  override def dispatch(handler: OnDependencyArtifactRemoved): Unit = {
    handler.onArtifactsRemoved(artifacts)
  }
}

trait OnDependencyArtifactRemoved extends InternalEventHandler {
  def onArtifactsRemoved(artifacts: Array[DependencyArtifact]): Unit
}


object DependencyArtifactRemovedEvent {
  val ARTIFACT_REMOVED = InternalEventType[OnDependencyArtifactRemoved]("ARTIFACT_REMOVED")
}
