package org.mule.weave.lsp.project.events

import org.mule.weave.extension.api.project.ProjectMetadata
import org.mule.weave.lsp.utils.InternalEvent
import org.mule.weave.lsp.utils.InternalEventHandler
import org.mule.weave.lsp.utils.InternalEventType

class ProjectStoppedEvent(projectMetadata: ProjectMetadata) extends InternalEvent {

  override type T = OnProjectStopped

  override def getType: InternalEventType[OnProjectStopped] = {
    ProjectStoppedEvent.PROJECT_STOPPED
  }

  override def dispatch(handler: OnProjectStopped): Unit = {
    handler.onProjectStopped(projectMetadata)
  }
}

trait OnProjectStopped extends InternalEventHandler {
  def onProjectStopped(projectMetadata: ProjectMetadata): Unit
}


object ProjectStoppedEvent {
  val PROJECT_STOPPED: InternalEventType[OnProjectStopped] = InternalEventType[OnProjectStopped]("PROJECT_STOPPED")
}
