package org.mule.weave.lsp.project.events

import org.mule.weave.lsp.utils.InternalEvent
import org.mule.weave.lsp.utils.InternalEventHandler
import org.mule.weave.lsp.utils.InternalEventType

class SettingsChangedEvent(settingsName: Array[String]) extends InternalEvent {
  override type T = OnSettingsChanged

  override def getType: InternalEventType[OnSettingsChanged] = SettingsChangedEvent.SETTINGS_CHANGED

  override def dispatch(handler: OnSettingsChanged): Unit = {
    handler.onSettingsChanged(settingsName)
  }

}

/**
 * Called with all the settings that have been modified
 */
trait OnSettingsChanged extends InternalEventHandler {

  def onSettingsChanged(modifiedSettingsName: Array[String]): Unit

}

object SettingsChangedEvent {
  val SETTINGS_CHANGED = InternalEventType[OnSettingsChanged]("SETTINGS_CHANGED")
}
