package org.mule.weave.lsp.services.events

import org.mule.weave.lsp.services.events.DocumentChangedEvent.DOCUMENT_CHANGED
import org.mule.weave.lsp.utils.InternalEvent
import org.mule.weave.lsp.utils.InternalEventHandler
import org.mule.weave.lsp.utils.InternalEventType
import org.mule.weave.v2.editor.VirtualFile

class DocumentChangedEvent(vf: VirtualFile) extends InternalEvent {
  override type T = OnDocumentChanged

  override def getType: InternalEventType[OnDocumentChanged] = DOCUMENT_CHANGED

  override def dispatch(handler: OnDocumentChanged): Unit = {
    handler.onDocumentChanged(vf)
  }
}

trait OnDocumentChanged extends InternalEventHandler {
  def onDocumentChanged(vf: VirtualFile): Unit
}

object DocumentChangedEvent {
  val DOCUMENT_CHANGED = InternalEventType[OnDocumentChanged]("DOCUMENT_CHANGED")
}