package org.mule.weave.lsp.services.events

import org.mule.weave.lsp.services.events.DocumentOpenedEvent.DOCUMENT_OPENED
import org.mule.weave.lsp.utils.InternalEvent
import org.mule.weave.lsp.utils.InternalEventHandler
import org.mule.weave.lsp.utils.InternalEventType
import org.mule.weave.v2.editor.VirtualFile

class DocumentOpenedEvent(vf: VirtualFile) extends InternalEvent {
  override type T = OnDocumentOpened

  override def getType: InternalEventType[OnDocumentOpened] = DOCUMENT_OPENED

  override def dispatch(handler: OnDocumentOpened): Unit = {
    handler.onDocumentOpened(vf)
  }
}

trait OnDocumentOpened extends InternalEventHandler {
  def onDocumentOpened(vf: VirtualFile): Unit
}

object DocumentOpenedEvent {
  val DOCUMENT_OPENED = InternalEventType[OnDocumentOpened]("DOCUMENT_OPENED")
}