package org.mule.weave.lsp.utils

import org.eclipse.lsp4j.Position
import org.mule.weave.lsp.services.DataWeaveToolingService
import org.mule.weave.lsp.utils.WeaveASTQueryUtils.WTF
import org.mule.weave.v2.editor.VirtualFile
import org.mule.weave.v2.parser.ast.AstNode
import org.mule.weave.v2.parser.ast.functions.FunctionCallNode
import org.mule.weave.v2.parser.ast.functions.FunctionCallParametersNode
import org.mule.weave.v2.parser.ast.structure.StringNode
import org.mule.weave.v2.parser.ast.variables.NameIdentifier
import org.mule.weave.v2.parser.ast.variables.VariableReferenceNode
import org.eclipse.lsp4j
import org.mule.weave.lsp.extension.protocol.WeaveTestItem
import org.mule.weave.v2.parser.ast.structure.ArrayNode

import scala.collection.JavaConverters._

case class WeaveSyntacticTestIndexer(dataWeaveToolingService: DataWeaveToolingService) extends WeaveTestIndexer {
  override def index(file: VirtualFile): Option[WeaveTestItem] = {
    try {
      val maybeAstNode = dataWeaveToolingService.openDocument(file.url()).ast().map(_.astNode)
      val maybeString = WeaveASTQueryUtils.fileKind(maybeAstNode)
      val maybeItem = maybeString match {
        case Some(WTF) => getWeaveItem(file.url(), maybeAstNode)
        case _ => None
      }
      maybeItem
    } catch  {
      case _: Exception => None
    }
  }

  def getWeaveItem(uri: String, maybeAstNode: Option[AstNode]): Option[WeaveTestItem] = {
    maybeAstNode match {
      case Some(FunctionCallNode(VariableReferenceNode(NameIdentifier("describedBy", _), _), FunctionCallParametersNode(Seq(stringNode, arrayNode: ArrayNode)), _, _)) => {
        val children = arrayNode
          .children()
          .flatMap((childNode) => {
            getWeaveItem(uri, Some(childNode))
          })

          weaveItem(stringNode, uri, children.asJava)
      }
      case Some(FunctionCallNode(VariableReferenceNode(NameIdentifier("in", _), _), FunctionCallParametersNode(Seq(FunctionCallNode(VariableReferenceNode(NameIdentifier("withConfig", _), _), FunctionCallParametersNode(Seq(stringNode, _*)), _, _), _*)), _, _)) => {
        weaveItem(stringNode, uri, Seq().asJava)
      }
      case Some(FunctionCallNode(VariableReferenceNode(NameIdentifier("in", _), _), FunctionCallParametersNode(Seq(stringNode, _*)), _, _)) => {
        weaveItem(stringNode, uri, Seq().asJava)
      }
      case Some(node) => {
        node
          .children()
          .flatMap(childNode => {
            getWeaveItem(uri, Some(childNode))
          })
          .headOption
          }
      case _ => None
      }
    }

  def weaveItem(stringNode: AstNode, uri: String, children: java.util.List[WeaveTestItem]): Option[WeaveTestItem] = {
    stringNode match {
      case StringNode(name, _) => {
        val location = stringNode
          .location()
        val range = new lsp4j.Range(new Position(location.startPosition.line, location.startPosition.column), new Position(location.startPosition.line, location.startPosition.column))
        val item = WeaveTestItem(label = name, uri = uri, range = range, children = children)
        Some(item)
      }
    }
  }

}
