package org.mule.weave.lsp.vfs

import org.mule.weave.extension.api.filesystem.{VirtualFile => ApiVirtualFile}
import org.mule.weave.v2.api.tooling.location.ResourceIdentifier
import org.mule.weave.v2.editor.VirtualFile

class VirtualFileAdapter(vf: VirtualFile) extends ApiVirtualFile {

  override def url(): String = {
    vf.url()
  }

  override def resourceIdentifier(): ResourceIdentifier = {
    vf.getNameIdentifier
  }
}

object VirtualFileAdapter {
  def apply(vf: VirtualFile): VirtualFileAdapter = new VirtualFileAdapter(vf)
}


