/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.lsp.commands;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.eclipse.lsp4j.ApplyWorkspaceEditParams;
import org.eclipse.lsp4j.Command;
import org.eclipse.lsp4j.ExecuteCommandParams;
import org.eclipse.lsp4j.MessageParams;
import org.eclipse.lsp4j.MessageType;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4j.WorkspaceEdit;
import org.mule.weave.extension.api.extension.command.WeaveCommand;
import org.mule.weave.lsp.commands.Commands$;
import org.mule.weave.lsp.commands.InsertDocumentationCommand$;
import org.mule.weave.lsp.project.ProjectKind;
import org.mule.weave.lsp.services.DataWeaveToolingService;
import org.mule.weave.lsp.services.UIService;
import org.mule.weave.lsp.services.WorkspaceServiceManager;
import org.mule.weave.v2.editor.WeaveDocumentToolingService;
import org.mule.weave.v2.parser.ast.AstNode;
import scala.Option;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001y4AAD\b\u00015!Aa\u0006\u0001B\u0001B\u0003%q\u0006\u0003\u00056\u0001\t\u0005\t\u0015!\u00037\u0011\u0015I\u0004\u0001\"\u0001;\u0011\u0015y\u0004\u0001\"\u0011A\u0011\u0015q\u0005\u0001\"\u0011P\u0011\u0015q\u0006\u0001\"\u0011A\u0011\u0015y\u0006\u0001\"\u0011a\u000f\u0015\u0011w\u0002#\u0001d\r\u0015qq\u0002#\u0001e\u0011\u0015I\u0014\u0002\"\u0001f\u0011\u001d1\u0017B1A\u0005\u0002\u001dDaA[\u0005!\u0002\u0013A\u0007\"B6\n\t\u0003a'AG%og\u0016\u0014H\u000fR8dk6,g\u000e^1uS>t7i\\7nC:$'B\u0001\t\u0012\u0003!\u0019w.\\7b]\u0012\u001c(B\u0001\n\u0014\u0003\ra7\u000f\u001d\u0006\u0003)U\tQa^3bm\u0016T!AF\f\u0002\t5,H.\u001a\u0006\u00021\u0005\u0019qN]4\u0004\u0001M\u0019\u0001aG\u0012\u0011\u0005q\tS\"A\u000f\u000b\u0005yy\u0012\u0001\u00027b]\u001eT\u0011\u0001I\u0001\u0005U\u00064\u0018-\u0003\u0002#;\t1qJ\u00196fGR\u0004\"\u0001\n\u0017\u000e\u0003\u0015R!AJ\u0014\u0002\u000f\r|W.\\1oI*\u0011\u0001&K\u0001\nKb$XM\\:j_:T!AK\u0016\u0002\u0007\u0005\u0004\u0018N\u0003\u0002)'%\u0011Q&\n\u0002\r/\u0016\fg/Z\"p[6\fg\u000eZ\u0001\u0018o>\u00148n\u001d9bG\u0016\u001cVM\u001d<jG\u0016l\u0015M\\1hKJ\u0004\"\u0001M\u001a\u000e\u0003ER!AM\t\u0002\u0011M,'O^5dKNL!\u0001N\u0019\u0003/]{'o[:qC\u000e,7+\u001a:wS\u000e,W*\u00198bO\u0016\u0014\u0018!C;J'\u0016\u0014h/[2f!\t\u0001t'\u0003\u00029c\tIQ+S*feZL7-Z\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007mjd\b\u0005\u0002=\u00015\tq\u0002C\u0003/\u0007\u0001\u0007q\u0006C\u00036\u0007\u0001\u0007a'A\u0005d_6l\u0017M\u001c3JIR\t\u0011\t\u0005\u0002C\u0017:\u00111)\u0013\t\u0003\t\u001ek\u0011!\u0012\u0006\u0003\rf\ta\u0001\u0010:p_Rt$\"\u0001%\u0002\u000bM\u001c\u0017\r\\1\n\u0005);\u0015A\u0002)sK\u0012,g-\u0003\u0002M\u001b\n11\u000b\u001e:j]\u001eT!AS$\u0002\u000f\u0015DXmY;uKR\u0011\u0001\u000b\u0016\t\u0003#Jk\u0011aR\u0005\u0003'\u001e\u0013a!\u00118z%\u00164\u0007\"B+\u0006\u0001\u00041\u0016A\u00029be\u0006l7\u000f\u0005\u0002X96\t\u0001L\u0003\u0002Z5\u0006)An\u001d95U*\u00111lF\u0001\bK\u000ed\u0017\u000e]:f\u0013\ti\u0006L\u0001\u000bFq\u0016\u001cW\u000f^3D_6l\u0017M\u001c3QCJ\fWn]\u0001\u0005]\u0006lW-A\u0006eKN\u001c'/\u001b9uS>tGCA!b\u0011\u0015)v\u00011\u0001W\u0003iIen]3si\u0012{7-^7f]R\fG/[8o\u0007>lW.\u00198e!\ta\u0014b\u0005\u0002\n!R\t1-A\u0003M\u0003\n+E*F\u0001i!\ta\u0012.\u0003\u0002M;\u00051A*\u0011\"F\u0019\u0002\nQb\u0019:fCR,7i\\7nC:$GcA7qeB\u0011qK\\\u0005\u0003_b\u0013qaQ8n[\u0006tG\rC\u0003r\u001b\u0001\u0007\u0011)A\u0002ve&DQa]\u0007A\u0002Q\fq!Y:u\u001d>$W\r\u0005\u0002vy6\taO\u0003\u0002xq\u0006\u0019\u0011m\u001d;\u000b\u0005eT\u0018A\u00029beN,'O\u0003\u0002|'\u0005\u0011aOM\u0005\u0003{Z\u0014q!Q:u\u001d>$W\r")
public class InsertDocumentationCommand
implements WeaveCommand {
    private final WorkspaceServiceManager workspaceServiceManager;
    private final UIService uIService;

    public static Command createCommand(String string, AstNode astNode) {
        return InsertDocumentationCommand$.MODULE$.createCommand(string, astNode);
    }

    public static String LABEL() {
        return InsertDocumentationCommand$.MODULE$.LABEL();
    }

    public String commandId() {
        return Commands$.MODULE$.DW_GENERATE_WEAVE_DOC();
    }

    public Object execute(ExecuteCommandParams params) {
        Object object;
        List args = params.getArguments();
        String uri = Commands$.MODULE$.argAsString(args, 0);
        int startOffset = Commands$.MODULE$.argAsInt(args, 1);
        int endOffset = Commands$.MODULE$.argAsInt(args, 2);
        int lineNumber = Commands$.MODULE$.argAsInt(args, 3);
        Option<ProjectKind> maybeProjectKind = this.workspaceServiceManager.projectKind(uri);
        if (maybeProjectKind.isDefined()) {
            DataWeaveToolingService validationService = ((ProjectKind)maybeProjectKind.get()).toolingService(DataWeaveToolingService.class);
            WeaveDocumentToolingService documentToolingService = validationService.openDocument(uri);
            Option docs = documentToolingService.scaffoldDocs(startOffset, endOffset);
            if (docs.isDefined()) {
                ApplyWorkspaceEditParams applyWorkspaceEditParams = new ApplyWorkspaceEditParams();
                HashMap<String, List<Object>> localChanges = new HashMap<String, List<Object>>();
                Position position = new Position(lineNumber, 0);
                Range range = new Range(position, position);
                localChanges.put(uri, Arrays.asList((Object[])new TextEdit[]{new TextEdit(range, new StringBuilder(1).append(((String)docs.get()).trim()).append("\n").toString())}));
                applyWorkspaceEditParams.setEdit(new WorkspaceEdit(localChanges));
                object = this.workspaceServiceManager.workspaceEditService().applyEdit(applyWorkspaceEditParams);
            } else {
                this.uIService.showMessage(new MessageParams(MessageType.Warning, "Function already has documentation."));
                object = BoxedUnit.UNIT;
            }
        } else {
            this.uIService.showMessage(new MessageParams(MessageType.Error, new StringBuilder(50).append("No project is associated to: ").append(uri).append(". ").append(this.commandId()).append(" cannot be executed").toString()));
            object = BoxedUnit.UNIT;
        }
        return null;
    }

    public String name() {
        return "Inserts Documentation";
    }

    public String description(ExecuteCommandParams params) {
        return "Inserting Documentation.";
    }

    public InsertDocumentationCommand(WorkspaceServiceManager workspaceServiceManager, UIService uIService) {
        this.workspaceServiceManager = workspaceServiceManager;
        this.uIService = uIService;
    }
}

